/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.mediators;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.mediators.JsonSchemaValidator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.mediators.JsonSchemaValidator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.mediators.JsonSchemaValidator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.threatprotection.APIMThreatAnalyzerException;
import org.wso2.carbon.apimgt.gateway.threatprotection.AnalyzerHolder;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.APIMThreatAnalyzer;
import org.wso2.carbon.apimgt.gateway.threatprotection.configuration.ConfigurationHolder;
import org.wso2.carbon.apimgt.gateway.threatprotection.configuration.JSONConfig;
import org.wso2.carbon.apimgt.gateway.threatprotection.utils.ThreatExceptionHandler;
import org.wso2.carbon.apimgt.gateway.utils.GatewayUtils;
import org.wso2.carbon.apimgt.impl.APIConstants;

public class JsonSchemaValidator
extends AbstractMediator {
    private static final Log logger;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        JsonSchemaValidator.ajc$preClinit();
        logger = LogFactory.getLog(JsonSchemaValidator.class);
    }

    public boolean mediate(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new JsonSchemaValidator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return JsonSchemaValidator.mediate_aroundBody0(this, messageContext2, joinPoint);
    }

    public JSONConfig configureSchemaProperties(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return (JSONConfig)MethodTimeLogger.aspectOf().log(new JsonSchemaValidator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JsonSchemaValidator.configureSchemaProperties_aroundBody2(this, messageContext2, joinPoint);
    }

    public boolean isContentAware() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new JsonSchemaValidator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return JsonSchemaValidator.isContentAware_aroundBody4(this, joinPoint);
    }

    static final /* synthetic */ boolean mediate_aroundBody0(JsonSchemaValidator ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        MessageContext axis2MC;
        Boolean isValid;
        Map<String, InputStream> inputStreams;
        block15: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"JSON schema validation mediator is activated...");
            }
            inputStreams = null;
            isValid = true;
            axis2MC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
            Object contentTypeObject = axis2MC.getProperty("synapse.internal.rest.contentType");
            String contentType = contentTypeObject != null ? contentTypeObject.toString() : axis2MC.getProperty("ContentType").toString();
            String apiContext = messageContext.getProperty("REST_API_CONTEXT").toString();
            String requestMethod = axis2MC.getProperty("HTTP_METHOD_OBJECT").toString();
            if (!APIConstants.SupportedHTTPVerbs.GET.name().equalsIgnoreCase(requestMethod) && ("application/json".equals(contentType) || "text/json".equals(contentType))) {
                JSONConfig jsonConfig = ajc$this.configureSchemaProperties(messageContext);
                ConfigurationHolder.addJsonConfig(jsonConfig);
                APIMThreatAnalyzer apimThreatAnalyzer = AnalyzerHolder.getAnalyzer(contentType);
                try {
                    inputStreams = GatewayUtils.cloneRequestMessage(messageContext);
                    if (inputStreams != null) {
                        InputStream inputStreamJson = inputStreams.get("JSON");
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStreamJson);
                        apimThreatAnalyzer.analyze(bufferedInputStream, apiContext);
                        isValid = true;
                    }
                }
                catch (APIMThreatAnalyzerException e) {
                    String message = "Request is failed due to a JSON schema validation failure: ";
                    logger.error((Object)message, (Throwable)e);
                    isValid = GatewayUtils.handleThreat(messageContext, "400", String.valueOf(message) + e.getMessage());
                    AnalyzerHolder.returnObject(apimThreatAnalyzer);
                    break block15;
                }
                catch (IOException e) {
                    try {
                        String message = "Error occurred while building the request: ";
                        logger.error((Object)message, (Throwable)e);
                        isValid = GatewayUtils.handleThreat(messageContext, "400", String.valueOf(message) + e.getMessage());
                        break block15;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        AnalyzerHolder.returnObject(apimThreatAnalyzer);
                    }
                }
                AnalyzerHolder.returnObject(apimThreatAnalyzer);
            } else if (ajc$this.log.isDebugEnabled()) {
                ajc$this.log.debug((Object)"JSON Schema Validator: Neither request method nor content type is matched with the validator.");
            }
        }
        GatewayUtils.setOriginalInputStream(inputStreams, axis2MC);
        if (isValid.booleanValue()) {
            try {
                RelayUtils.buildMessage((MessageContext)axis2MC);
            }
            catch (IOException | XMLStreamException e) {
                isValid = GatewayUtils.handleThreat(messageContext, "400", e.getMessage());
            }
        }
        return isValid;
    }

    static final /* synthetic */ JSONConfig configureSchemaProperties_aroundBody2(JsonSchemaValidator ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        String errorMessage;
        int propertyCount = 0;
        int stringLength = 0;
        int arrayElementCount = 0;
        int keyLength = 0;
        int maxJSONDepth = 0;
        Object messageProperty = messageContext.getProperty("maxPropertyCount");
        if (messageProperty != null) {
            propertyCount = Integer.parseInt(messageProperty.toString());
        } else {
            errorMessage = "Json schema maxProperty count is missing.";
            ThreatExceptionHandler.handleException(messageContext, errorMessage);
        }
        messageProperty = messageContext.getProperty("maxStringLength");
        if (messageProperty != null) {
            stringLength = Integer.parseInt(messageProperty.toString());
        } else {
            errorMessage = "Json schema Max String length is missing";
            ThreatExceptionHandler.handleException(messageContext, errorMessage);
        }
        messageProperty = messageContext.getProperty("maxArrayElementCount");
        if (messageProperty != null) {
            arrayElementCount = Integer.parseInt(messageProperty.toString());
        } else {
            errorMessage = "Json schema max array element count is missing";
            ThreatExceptionHandler.handleException(messageContext, errorMessage);
        }
        messageProperty = messageContext.getProperty("maxKeyLength");
        if (messageProperty != null) {
            keyLength = Integer.parseInt(messageProperty.toString());
        } else {
            errorMessage = "Json schema maximum key length is missing";
            ThreatExceptionHandler.handleException(messageContext, errorMessage);
        }
        messageProperty = messageContext.getProperty("maxJsonDepth");
        if (messageProperty != null) {
            maxJSONDepth = Integer.parseInt(messageProperty.toString());
        } else {
            errorMessage = "Json schema maximum JSON depth is missing";
            ThreatExceptionHandler.handleException(messageContext, errorMessage);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Max Priority count is:" + propertyCount + ", " + "Max String length is: " + stringLength + ", " + "Max Array element count: " + arrayElementCount + ", " + "Max Key Length: " + keyLength + ", " + "Max JSON depth is:" + maxJSONDepth + ", "));
        }
        JSONConfig jsonConfig = new JSONConfig();
        jsonConfig.setMaxPropertyCount(propertyCount);
        jsonConfig.setMaxStringLength(stringLength);
        jsonConfig.setMaxArrayElementCount(arrayElementCount);
        jsonConfig.setMaxKeyLength(keyLength);
        jsonConfig.setMaxJsonDepth(maxJSONDepth);
        return jsonConfig;
    }

    static final /* synthetic */ boolean isContentAware_aroundBody4(JsonSchemaValidator ajc$this, JoinPoint joinPoint) {
        return false;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JsonSchemaValidator.java", JsonSchemaValidator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mediate", "org.wso2.carbon.apimgt.gateway.mediators.JsonSchemaValidator", "org.apache.synapse.MessageContext", "messageContext", "", "boolean"), 59);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "configureSchemaProperties", "org.wso2.carbon.apimgt.gateway.mediators.JsonSchemaValidator", "org.apache.synapse.MessageContext", "messageContext", "", "org.wso2.carbon.apimgt.gateway.threatprotection.configuration.JSONConfig"), 130);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isContentAware", "org.wso2.carbon.apimgt.gateway.mediators.JsonSchemaValidator", "", "", "", "boolean"), 197);
    }
}

