/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.dto.APICondition;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.listeners.JMSMessageListener$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.listeners.JMSMessageListener$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.listeners.JMSMessageListener$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.listeners.JMSMessageListener$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.listeners.JMSMessageListener$AjcClosure9;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;

public class JMSMessageListener
implements MessageListener {
    private static final Log log;
    private Pattern apiPattern = Pattern.compile("/.*/(.*):\\1_(condition_(\\d*)|default)");
    private static final int API_PATTERN_GROUPS = 3;
    private static final int API_PATTERN_CONDITION_INDEX = 2;
    private Pattern resourcePattern = Pattern.compile("/.*/(.*)/\\1(.*)?:[A-Z]{0,7}_(condition_(\\d*)|default)");
    public static final int RESOURCE_PATTERN_GROUPS = 4;
    public static final int RESOURCE_PATTERN_CONDITION_INDEX = 3;
    private Pattern productResourcePattern = Pattern.compile("/.*/(.*):[A-Z]{0,5}_(condition_(\\d*)|default)");
    private static final int PRODUCT_RESOURCE_PATTERN_GROUPS = 3;
    private static final int PRODUCT_RESOURCE_CONDITION_INDEX = 2;
    private Pattern productAPIPattern = Pattern.compile("/.*:.*(condition_(\\d*)|default)");
    private static final int PRODUCT_API_PATTERN_GROUPS = 2;
    private static final int PRODUCT_API_CONDITION_INDEX = 1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        JMSMessageListener.ajc$preClinit();
        log = LogFactory.getLog(JMSMessageListener.class);
    }

    public void onMessage(Message message) {
        Message message2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)message2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, message2, joinPoint};
            MethodTimeLogger.aspectOf().log(new JMSMessageListener$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        JMSMessageListener.onMessage_aroundBody0(this, message2, joinPoint);
    }

    private void handleThrottleUpdateMessage(JsonNode msg) throws ParseException {
        JsonNode jsonNode = msg;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)jsonNode);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, jsonNode, joinPoint};
            MethodTimeLogger.aspectOf().log(new JMSMessageListener$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        JMSMessageListener.handleThrottleUpdateMessage_aroundBody2(this, jsonNode, joinPoint);
    }

    private synchronized void handleBlockingMessage(JsonNode msg) {
        JsonNode jsonNode = msg;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)jsonNode);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, jsonNode, joinPoint};
            MethodTimeLogger.aspectOf().log(new JMSMessageListener$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        JMSMessageListener.handleBlockingMessage_aroundBody4(this, jsonNode, joinPoint);
    }

    private APICondition extractAPIorResourceKey(String throttleKey) {
        String string = throttleKey;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (APICondition)MethodTimeLogger.aspectOf().log(new JMSMessageListener$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JMSMessageListener.extractAPIorResourceKey_aroundBody6(this, string, joinPoint);
    }

    private synchronized void handleKeyTemplateMessage(JsonNode msg) {
        JsonNode jsonNode = msg;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)jsonNode);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, jsonNode, joinPoint};
            MethodTimeLogger.aspectOf().log(new JMSMessageListener$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        JMSMessageListener.handleKeyTemplateMessage_aroundBody8(this, jsonNode, joinPoint);
    }

    static final /* synthetic */ void onMessage_aroundBody0(JMSMessageListener ajc$this, Message message, JoinPoint joinPoint) {
        try {
            if (message != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event received in JMS Event Receiver - " + message));
                }
                Topic jmsDestination = (Topic)message.getJMSDestination();
                if (message instanceof TextMessage) {
                    String textMessage = ((TextMessage)message).getText();
                    JsonNode payloadData = new ObjectMapper().readTree(textMessage).path("event").path("payloadData");
                    if ("throttleData".equalsIgnoreCase(jmsDestination.getTopicName())) {
                        if (payloadData.get("throttleKey") != null) {
                            ajc$this.handleThrottleUpdateMessage(payloadData);
                        } else if (payloadData.get("blockingCondition") != null) {
                            ajc$this.handleBlockingMessage(payloadData);
                        } else if (payloadData.get("keyTemplateValue") != null) {
                            ajc$this.handleKeyTemplateMessage(payloadData);
                        }
                    }
                } else {
                    log.warn((Object)("Event dropped due to unsupported message type " + message.getClass()));
                }
            } else {
                log.warn((Object)"Dropping the empty/null event received through jms receiver");
            }
        }
        catch (JMSException e) {
            log.error((Object)"JMSException occurred when processing the received message ", (Throwable)e);
        }
        catch (ParseException e) {
            log.error((Object)"Error while processing evaluatedConditions", (Throwable)e);
        }
        catch (JsonProcessingException e) {
            log.error((Object)"Error while parsing JMS payload", (Throwable)e);
        }
    }

    static final /* synthetic */ void handleThrottleUpdateMessage_aroundBody2(JMSMessageListener ajc$this, JsonNode msg, JoinPoint joinPoint) {
        String throttleKey = msg.get("throttleKey").asText();
        String throttleState = msg.get("isThrottled").asText();
        Long timeStamp = Long.parseLong(msg.get("expiryTimeStamp").asText());
        JsonNode evaluatedConditionObject = msg.get("evaluatedConditions");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received Key -  throttleKey : " + throttleKey + " , " + "isThrottled :" + throttleState + " , expiryTime : " + new Date(timeStamp).toString()));
        }
        if ("true".equalsIgnoreCase(throttleState)) {
            ServiceReferenceHolder.getInstance().getAPIThrottleDataService().addThrottleData(throttleKey, timeStamp);
            APICondition extractedKey = ajc$this.extractAPIorResourceKey(throttleKey);
            if (extractedKey != null) {
                if (evaluatedConditionObject != null) {
                    ServiceReferenceHolder.getInstance().getAPIThrottleDataService().addThrottledApiConditions(extractedKey.getResourceKey(), extractedKey.getName(), APIUtil.extractConditionDto((String)evaluatedConditionObject.toString()));
                }
                if (!ServiceReferenceHolder.getInstance().getAPIThrottleDataService().isAPIThrottled(extractedKey.getResourceKey())) {
                    ServiceReferenceHolder.getInstance().getAPIThrottleDataService().addThrottledAPIKey(extractedKey.getResourceKey(), timeStamp);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding throttling key : " + extractedKey));
                    }
                }
            }
        } else {
            ServiceReferenceHolder.getInstance().getAPIThrottleDataService().removeThrottleData(throttleKey);
            APICondition extractedKey = ajc$this.extractAPIorResourceKey(throttleKey);
            if (extractedKey != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing throttling key : " + extractedKey.getResourceKey()));
                }
                ServiceReferenceHolder.getInstance().getAPIThrottleDataService().removeThrottledAPIKey(extractedKey.getResourceKey());
                ServiceReferenceHolder.getInstance().getAPIThrottleDataService().removeThrottledApiConditions(extractedKey.getResourceKey(), extractedKey.getName());
            }
        }
    }

    static final /* synthetic */ void handleBlockingMessage_aroundBody4(JMSMessageListener ajc$this, JsonNode msg, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received Key -  blockingCondition : " + msg.get("blockingCondition").asText() + " , " + "conditionValue :" + msg.get("conditionValue").asText() + " , " + "tenantDomain : " + msg.get("tenantDomain").asText()));
        }
        String condition = msg.get("blockingCondition").asText();
        String conditionValue = msg.get("conditionValue").asText();
        String conditionState = msg.get("state").asText();
        int conditionId = msg.get("id").asInt();
        String tenantDomain = msg.get("tenantDomain").asText();
        if ("APPLICATION".equals(condition)) {
            if ("true".equals(conditionState)) {
                ServiceReferenceHolder.getInstance().getAPIThrottleDataService().addBlockingCondition("APPLICATION", conditionValue, conditionValue);
            } else {
                ServiceReferenceHolder.getInstance().getAPIThrottleDataService().removeBlockCondition("APPLICATION", conditionValue);
            }
        } else if ("API".equals(condition)) {
            if ("true".equals(conditionState)) {
                ServiceReferenceHolder.getInstance().getAPIThrottleDataService().addBlockingCondition("API", conditionValue, conditionValue);
            } else {
                ServiceReferenceHolder.getInstance().getAPIThrottleDataService().removeBlockCondition("API", conditionValue);
            }
        } else if ("USER".equals(condition)) {
            if ("true".equals(conditionState)) {
                ServiceReferenceHolder.getInstance().getAPIThrottleDataService().addBlockingCondition("USER", conditionValue, conditionValue);
            } else {
                ServiceReferenceHolder.getInstance().getAPIThrottleDataService().removeBlockCondition("USER", conditionValue);
            }
        } else if ("IP".equals(condition) || "IPRANGE".equals(condition)) {
            if ("true".equals(conditionState)) {
                ServiceReferenceHolder.getInstance().getAPIThrottleDataService().addIpBlockingCondition(tenantDomain, conditionId, conditionValue, condition);
            } else {
                ServiceReferenceHolder.getInstance().getAPIThrottleDataService().removeIpBlockingCondition(tenantDomain, conditionId);
            }
        } else if ("SUBSCRIPTION".equals(condition)) {
            if ("true".equals(conditionState)) {
                ServiceReferenceHolder.getInstance().getAPIThrottleDataService().addBlockingCondition("SUBSCRIPTION", conditionValue, conditionValue);
            } else {
                ServiceReferenceHolder.getInstance().getAPIThrottleDataService().removeBlockCondition("SUBSCRIPTION", conditionValue);
            }
        }
    }

    static final /* synthetic */ APICondition extractAPIorResourceKey_aroundBody6(JMSMessageListener ajc$this, String throttleKey, JoinPoint joinPoint) {
        Matcher m = ajc$this.resourcePattern.matcher(throttleKey);
        if (m.matches()) {
            if (m.groupCount() == 4) {
                String condition = m.group(3);
                String resourceKey = throttleKey.substring(0, throttleKey.indexOf("_" + condition));
                return new APICondition(resourceKey, condition);
            }
        } else {
            m = ajc$this.apiPattern.matcher(throttleKey);
            if (m.matches() && m.groupCount() == 3) {
                String condition = m.group(2);
                String resourceKey = throttleKey.substring(0, throttleKey.indexOf("_" + condition));
                return new APICondition(resourceKey, condition);
            }
        }
        if ((m = ajc$this.productResourcePattern.matcher(throttleKey)).matches()) {
            if (m.groupCount() == 3) {
                String condition = m.group(2);
                String resourceKey = throttleKey.substring(0, throttleKey.indexOf("_" + condition));
                return new APICondition(resourceKey, condition);
            }
        } else {
            m = ajc$this.productAPIPattern.matcher(throttleKey);
            if (m.matches() && m.groupCount() == 2) {
                String condition = m.group(1);
                String resourceKey = throttleKey.substring(0, throttleKey.indexOf("_" + condition));
                return new APICondition(resourceKey, condition);
            }
        }
        return null;
    }

    static final /* synthetic */ void handleKeyTemplateMessage_aroundBody8(JMSMessageListener ajc$this, JsonNode msg, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received Key -  KeyTemplate : " + msg.get("keyTemplateValue").asText()));
        }
        String keyTemplateValue = msg.get("keyTemplateValue").asText();
        String keyTemplateState = msg.get("keyTemplateState").asText();
        if ("add".equals(keyTemplateState)) {
            ServiceReferenceHolder.getInstance().getAPIThrottleDataService().addKeyTemplate(keyTemplateValue, keyTemplateValue);
        } else {
            ServiceReferenceHolder.getInstance().getAPIThrottleDataService().removeKeyTemplate(keyTemplateValue);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JMSMessageListener.java", JMSMessageListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onMessage", "org.wso2.carbon.apimgt.gateway.listeners.JMSMessageListener", "javax.jms.Message", "message", "", "void"), 67);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleThrottleUpdateMessage", "org.wso2.carbon.apimgt.gateway.listeners.JMSMessageListener", "com.fasterxml.jackson.databind.JsonNode", "msg", "org.json.simple.parser.ParseException", "void"), 121);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22", "handleBlockingMessage", "org.wso2.carbon.apimgt.gateway.listeners.JMSMessageListener", "com.fasterxml.jackson.databind.JsonNode", "msg", "", "void"), 173);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractAPIorResourceKey", "org.wso2.carbon.apimgt.gateway.listeners.JMSMessageListener", "java.lang.String", "throttleKey", "", "org.wso2.carbon.apimgt.gateway.dto.APICondition"), 232);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22", "handleKeyTemplateMessage", "org.wso2.carbon.apimgt.gateway.listeners.JMSMessageListener", "com.fasterxml.jackson.databind.JsonNode", "msg", "", "void"), 271);
    }
}

