/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.listeners.GatewayTokenRevocationMessageListener$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.listeners.GatewayTokenRevocationMessageListener$AjcClosure3;

public class GatewayTokenRevocationMessageListener
implements MessageListener {
    private static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        GatewayTokenRevocationMessageListener.ajc$preClinit();
        log = LogFactory.getLog(GatewayTokenRevocationMessageListener.class);
    }

    public void onMessage(Message message) {
        Message message2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)message2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, message2, joinPoint};
            MethodTimeLogger.aspectOf().log(new GatewayTokenRevocationMessageListener$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        GatewayTokenRevocationMessageListener.onMessage_aroundBody0(this, message2, joinPoint);
    }

    private void handleRevokedTokenMessage(String revokedToken, long expiryTime, String tokenType) {
        String string = revokedToken;
        long l = expiryTime;
        String string2 = tokenType;
        Object[] objectArray = new Object[]{string, Conversions.longObject((long)l), string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, string, Conversions.longObject((long)l), string2, joinPoint};
            MethodTimeLogger.aspectOf().log(new GatewayTokenRevocationMessageListener$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        GatewayTokenRevocationMessageListener.handleRevokedTokenMessage_aroundBody2(this, string, l, string2, joinPoint);
    }

    static final /* synthetic */ void onMessage_aroundBody0(GatewayTokenRevocationMessageListener ajc$this, Message message, JoinPoint joinPoint) {
        try {
            if (message != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event received in JMS Event Receiver - " + message));
                }
                Topic jmsDestination = (Topic)message.getJMSDestination();
                if (message instanceof TextMessage) {
                    String textMessage = ((TextMessage)message).getText();
                    JsonNode payloadData = new ObjectMapper().readTree(textMessage).path("event").path("payloadData");
                    if ("tokenRevocation".equalsIgnoreCase(jmsDestination.getTopicName()) && payloadData.get("revokedToken").asText() != null) {
                        ajc$this.handleRevokedTokenMessage(payloadData.get("revokedToken").asText(), payloadData.get("expiryTime").asLong(), payloadData.get("type").asText());
                    }
                } else {
                    log.warn((Object)("Event dropped due to unsupported message type " + message.getClass()));
                }
            } else {
                log.warn((Object)"Dropping the empty/null event received through jms receiver");
            }
        }
        catch (JsonProcessingException | JMSException e) {
            log.error((Object)"JMSException occurred when processing the received message ", e);
        }
    }

    static final /* synthetic */ void handleRevokedTokenMessage_aroundBody2(GatewayTokenRevocationMessageListener ajc$this, String revokedToken, long expiryTime, String tokenType, JoinPoint joinPoint) {
        boolean isJwtToken = false;
        if (StringUtils.isEmpty((CharSequence)revokedToken)) {
            return;
        }
        if ("API_KEY".equals(tokenType) || "JWT".equals(tokenType)) {
            ServiceReferenceHolder.getInstance().getRevokedTokenService().addRevokedJWTIntoMap(revokedToken, Long.valueOf(expiryTime));
            isJwtToken = true;
        }
        if ("API_KEY".equals(tokenType)) {
            ServiceReferenceHolder.getInstance().getRevokedTokenService().removeApiKeyFromGatewayCache(revokedToken);
        } else {
            ServiceReferenceHolder.getInstance().getRevokedTokenService().removeTokenFromGatewayCache(revokedToken, isJwtToken);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GatewayTokenRevocationMessageListener.java", GatewayTokenRevocationMessageListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onMessage", "org.wso2.carbon.apimgt.gateway.listeners.GatewayTokenRevocationMessageListener", "javax.jms.Message", "message", "", "void"), 36);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleRevokedTokenMessage", "org.wso2.carbon.apimgt.gateway.listeners.GatewayTokenRevocationMessageListener", "java.lang.String:long:java.lang.String", "revokedToken:expiryTime:tokenType", "", "void"), 72);
    }
}

