/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.HashSet;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.gateway.EndpointCertificateDeployer;
import org.wso2.carbon.apimgt.gateway.GoogleAnalyticsConfigDeployer;
import org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.listeners.GatewayJMSMessageListener$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.listeners.GatewayJMSMessageListener$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.listeners.GatewayJMSMessageListener$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.listeners.GatewayJMSMessageListener$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.listeners.GatewayJMSMessageListener$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.listeners.GatewayJMSMessageListener$AjcClosure9;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.certificatemgt.CertificateManagerImpl;
import org.wso2.carbon.apimgt.impl.dto.GatewayArtifactSynchronizerProperties;
import org.wso2.carbon.apimgt.impl.dto.WebhooksDTO;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException;
import org.wso2.carbon.apimgt.impl.notifier.events.APIEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.APIPolicyEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.ApplicationEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.ApplicationPolicyEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.ApplicationRegistrationEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.CertificateEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.DeployAPIInGatewayEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.GoogleAnalyticsConfigEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.PolicyEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.ScopeEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.SubscriptionEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.SubscriptionPolicyEvent;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class GatewayJMSMessageListener
implements MessageListener {
    private static final Log log;
    private boolean debugEnabled = log.isDebugEnabled();
    private InMemoryAPIDeployer inMemoryApiDeployer = new InMemoryAPIDeployer();
    private GatewayArtifactSynchronizerProperties gatewayArtifactSynchronizerProperties = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration().getGatewayArtifactSynchronizerProperties();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        GatewayJMSMessageListener.ajc$preClinit();
        log = LogFactory.getLog(GatewayJMSMessageListener.class);
    }

    public void onMessage(Message message) {
        Message message2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)message2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, message2, joinPoint};
            MethodTimeLogger.aspectOf().log(new GatewayJMSMessageListener$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        GatewayJMSMessageListener.onMessage_aroundBody0(this, message2, joinPoint);
    }

    private void handleNotificationMessage(String eventType, long timestamp, String encodedEvent) {
        String string = eventType;
        long l = timestamp;
        String string2 = encodedEvent;
        Object[] objectArray = new Object[]{string, Conversions.longObject((long)l), string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, string, Conversions.longObject((long)l), string2, joinPoint};
            MethodTimeLogger.aspectOf().log(new GatewayJMSMessageListener$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        GatewayJMSMessageListener.handleNotificationMessage_aroundBody2(this, string, l, string2, joinPoint);
    }

    private void endTenantFlow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new GatewayJMSMessageListener$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        GatewayJMSMessageListener.endTenantFlow_aroundBody4(this, joinPoint);
    }

    private void startTenantFlow(String tenantDomain) {
        String string = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new GatewayJMSMessageListener$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        GatewayJMSMessageListener.startTenantFlow_aroundBody6(this, string, joinPoint);
    }

    private synchronized void handleAsyncWebhooksSubscriptionMessage(JsonNode payloadData) {
        JsonNode jsonNode = payloadData;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)jsonNode);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, jsonNode, joinPoint};
            MethodTimeLogger.aspectOf().log(new GatewayJMSMessageListener$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        GatewayJMSMessageListener.handleAsyncWebhooksSubscriptionMessage_aroundBody8(this, jsonNode, joinPoint);
    }

    private synchronized void handleAsyncWebhooksUnSubscriptionMessage(JsonNode payloadData) {
        JsonNode jsonNode = payloadData;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)jsonNode);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, jsonNode, joinPoint};
            MethodTimeLogger.aspectOf().log(new GatewayJMSMessageListener$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        GatewayJMSMessageListener.handleAsyncWebhooksUnSubscriptionMessage_aroundBody10(this, jsonNode, joinPoint);
    }

    static final /* synthetic */ void onMessage_aroundBody0(GatewayJMSMessageListener ajc$this, Message message, JoinPoint joinPoint) {
        try {
            if (message != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event received in JMS Event Receiver - " + message));
                }
                Topic jmsDestination = (Topic)message.getJMSDestination();
                if (message instanceof TextMessage) {
                    String textMessage = ((TextMessage)message).getText();
                    JsonNode payloadData = new ObjectMapper().readTree(textMessage).path("event").path("payloadData");
                    if ("notification".equalsIgnoreCase(jmsDestination.getTopicName())) {
                        if (payloadData.get("eventType").asText() != null) {
                            if (ajc$this.debugEnabled) {
                                log.debug((Object)("Event received from the topic of " + jmsDestination.getTopicName()));
                            }
                            ajc$this.handleNotificationMessage(payloadData.get("eventType").asText(), payloadData.get("timestamp").asLong(), payloadData.get("event").asText());
                        }
                    } else if ("asyncWebhooksData".equalsIgnoreCase(jmsDestination.getTopicName())) {
                        String mode = payloadData.get("mode").asText();
                        if ("subscribe".equalsIgnoreCase(mode)) {
                            ajc$this.handleAsyncWebhooksSubscriptionMessage(payloadData);
                        } else if ("unsubscribe".equalsIgnoreCase(mode)) {
                            ajc$this.handleAsyncWebhooksUnSubscriptionMessage(payloadData);
                        }
                    }
                } else {
                    log.warn((Object)("Event dropped due to unsupported message type " + message.getClass()));
                }
            } else {
                log.warn((Object)"Dropping the empty/null event received through jms receiver");
            }
        }
        catch (JsonProcessingException | JMSException e) {
            log.error((Object)"JMSException occurred when processing the received message ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ void handleNotificationMessage_aroundBody2(GatewayJMSMessageListener ajc$this, String eventType, long timestamp, String encodedEvent, JoinPoint joinPoint) {
        ApplicationEvent event;
        byte[] eventDecoded = Base64.decodeBase64((String)encodedEvent);
        String eventJson = new String(eventDecoded);
        if (APIConstants.EventType.DEPLOY_API_IN_GATEWAY.name().equals(eventType) || APIConstants.EventType.REMOVE_API_FROM_GATEWAY.name().equals(eventType)) {
            DeployAPIInGatewayEvent gatewayEvent = (DeployAPIInGatewayEvent)new Gson().fromJson(new String(eventDecoded), DeployAPIInGatewayEvent.class);
            String tenantDomain = gatewayEvent.getTenantDomain();
            boolean tenantLoaded = ServiceReferenceHolder.getInstance().isTenantLoaded(tenantDomain);
            if (!tenantLoaded) {
                String syncKey = tenantDomain.concat("__").concat(ajc$this.getClass().getName());
                String string = syncKey.intern();
                synchronized (string) {
                    tenantLoaded = ServiceReferenceHolder.getInstance().isTenantLoaded(tenantDomain);
                    if (!tenantLoaded) {
                        APIUtil.loadTenantConfigBlockingMode((String)tenantDomain);
                    }
                }
            }
            if (tenantLoaded) {
                block85: {
                    HashSet systemConfiguredGatewayLabels = new HashSet(gatewayEvent.getGatewayLabels());
                    systemConfiguredGatewayLabels.retainAll(ajc$this.gatewayArtifactSynchronizerProperties.getGatewayLabels());
                    if (!systemConfiguredGatewayLabels.isEmpty()) {
                        block83: {
                            ServiceReferenceHolder.getInstance().getKeyManagerDataService().updateDeployedAPIRevision(gatewayEvent);
                            if (APIConstants.EventType.DEPLOY_API_IN_GATEWAY.name().equals(eventType)) {
                                boolean tenantFlowStarted = false;
                                try {
                                    try {
                                        ajc$this.startTenantFlow(tenantDomain);
                                        tenantFlowStarted = true;
                                        ajc$this.inMemoryApiDeployer.deployAPI(gatewayEvent);
                                    }
                                    catch (ArtifactSynchronizerException artifactSynchronizerException) {
                                        log.error((Object)("Error in deploying artifacts for " + gatewayEvent.getUuid() + "in the Gateway"));
                                        if (tenantFlowStarted) {
                                            ajc$this.endTenantFlow();
                                        }
                                        break block83;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (tenantFlowStarted) {
                                        ajc$this.endTenantFlow();
                                    }
                                    throw throwable;
                                }
                                if (tenantFlowStarted) {
                                    ajc$this.endTenantFlow();
                                }
                            }
                        }
                        if (APIConstants.EventType.REMOVE_API_FROM_GATEWAY.name().equals(eventType)) {
                            boolean tenantFlowStarted = false;
                            try {
                                try {
                                    ajc$this.startTenantFlow(tenantDomain);
                                    tenantFlowStarted = true;
                                    ajc$this.inMemoryApiDeployer.unDeployAPI(gatewayEvent);
                                }
                                catch (ArtifactSynchronizerException artifactSynchronizerException) {
                                    log.error((Object)"Error in undeploying artifacts");
                                    if (tenantFlowStarted) {
                                        ajc$this.endTenantFlow();
                                    }
                                    break block85;
                                }
                            }
                            catch (Throwable throwable) {
                                if (tenantFlowStarted) {
                                    ajc$this.endTenantFlow();
                                }
                                throw throwable;
                            }
                            if (tenantFlowStarted) {
                                ajc$this.endTenantFlow();
                            }
                        }
                    }
                }
                if (ajc$this.debugEnabled) {
                    log.debug((Object)("Event with ID " + gatewayEvent.getEventId() + " is received and " + gatewayEvent.getUuid() + " is successfully deployed/undeployed"));
                }
            }
        }
        if (APIConstants.EventType.APPLICATION_CREATE.toString().equals(eventType) || APIConstants.EventType.APPLICATION_UPDATE.toString().equals(eventType)) {
            event = (ApplicationEvent)new Gson().fromJson(eventJson, ApplicationEvent.class);
            ServiceReferenceHolder.getInstance().getKeyManagerDataService().addOrUpdateApplication(event);
        } else if (APIConstants.EventType.SUBSCRIPTIONS_CREATE.toString().equals(eventType) || APIConstants.EventType.SUBSCRIPTIONS_UPDATE.toString().equals(eventType)) {
            event = (SubscriptionEvent)new Gson().fromJson(eventJson, SubscriptionEvent.class);
            ServiceReferenceHolder.getInstance().getKeyManagerDataService().addOrUpdateSubscription((SubscriptionEvent)event);
        } else if (APIConstants.EventType.API_UPDATE.toString().equals(eventType)) {
            event = (APIEvent)new Gson().fromJson(eventJson, APIEvent.class);
            ServiceReferenceHolder.getInstance().getKeyManagerDataService().addOrUpdateAPI((APIEvent)event);
        } else if (APIConstants.EventType.API_LIFECYCLE_CHANGE.toString().equals(eventType)) {
            event = (APIEvent)new Gson().fromJson(eventJson, APIEvent.class);
            if (APIStatus.CREATED.toString().equals(event.getApiStatus()) || APIStatus.RETIRED.toString().equals(event.getApiStatus())) {
                ServiceReferenceHolder.getInstance().getKeyManagerDataService().removeAPI((APIEvent)event);
            } else {
                ServiceReferenceHolder.getInstance().getKeyManagerDataService().addOrUpdateAPI((APIEvent)event);
            }
        } else if (APIConstants.EventType.APPLICATION_REGISTRATION_CREATE.toString().equals(eventType)) {
            event = (ApplicationRegistrationEvent)new Gson().fromJson(eventJson, ApplicationRegistrationEvent.class);
            ServiceReferenceHolder.getInstance().getKeyManagerDataService().addOrUpdateApplicationKeyMapping((ApplicationRegistrationEvent)event);
        } else if (APIConstants.EventType.SUBSCRIPTIONS_DELETE.toString().equals(eventType)) {
            event = (SubscriptionEvent)new Gson().fromJson(eventJson, SubscriptionEvent.class);
            ServiceReferenceHolder.getInstance().getKeyManagerDataService().removeSubscription((SubscriptionEvent)event);
        } else if (APIConstants.EventType.APPLICATION_DELETE.toString().equals(eventType)) {
            event = (ApplicationEvent)new Gson().fromJson(eventJson, ApplicationEvent.class);
            ServiceReferenceHolder.getInstance().getKeyManagerDataService().removeApplication(event);
        } else if (APIConstants.EventType.REMOVE_APPLICATION_KEYMAPPING.toString().equals(eventType)) {
            event = (ApplicationRegistrationEvent)new Gson().fromJson(eventJson, ApplicationRegistrationEvent.class);
            ServiceReferenceHolder.getInstance().getKeyManagerDataService().removeApplicationKeyMapping((ApplicationRegistrationEvent)event);
        } else if (APIConstants.EventType.SCOPE_CREATE.toString().equals(eventType)) {
            event = (ScopeEvent)new Gson().fromJson(eventJson, ScopeEvent.class);
            ServiceReferenceHolder.getInstance().getKeyManagerDataService().addScope((ScopeEvent)event);
        } else if (APIConstants.EventType.SCOPE_UPDATE.toString().equals(eventType)) {
            event = (ScopeEvent)new Gson().fromJson(eventJson, ScopeEvent.class);
            ServiceReferenceHolder.getInstance().getKeyManagerDataService().addScope((ScopeEvent)event);
        } else if (APIConstants.EventType.SCOPE_DELETE.toString().equals(eventType)) {
            event = (ScopeEvent)new Gson().fromJson(eventJson, ScopeEvent.class);
            ServiceReferenceHolder.getInstance().getKeyManagerDataService().deleteScope((ScopeEvent)event);
        } else if (APIConstants.EventType.POLICY_CREATE.toString().equals(eventType) || APIConstants.EventType.POLICY_DELETE.toString().equals(eventType)) {
            APIPolicyEvent policyEvent;
            event = (PolicyEvent)new Gson().fromJson(eventJson, PolicyEvent.class);
            boolean updatePolicy = false;
            boolean deletePolicy = false;
            if (APIConstants.EventType.POLICY_CREATE.toString().equals(eventType) || APIConstants.EventType.POLICY_UPDATE.toString().equals(eventType)) {
                updatePolicy = true;
            } else if (APIConstants.EventType.POLICY_DELETE.toString().equals(eventType)) {
                deletePolicy = true;
            }
            if (event.getPolicyType() == APIConstants.PolicyType.API) {
                policyEvent = (APIPolicyEvent)new Gson().fromJson(eventJson, APIPolicyEvent.class);
                if (updatePolicy) {
                    ServiceReferenceHolder.getInstance().getKeyManagerDataService().addOrUpdateAPIPolicy(policyEvent);
                } else if (deletePolicy) {
                    ServiceReferenceHolder.getInstance().getKeyManagerDataService().removeAPIPolicy(policyEvent);
                }
            } else if (event.getPolicyType() == APIConstants.PolicyType.SUBSCRIPTION) {
                policyEvent = (SubscriptionPolicyEvent)new Gson().fromJson(eventJson, SubscriptionPolicyEvent.class);
                if (updatePolicy) {
                    ServiceReferenceHolder.getInstance().getKeyManagerDataService().addOrUpdateSubscriptionPolicy((SubscriptionPolicyEvent)policyEvent);
                } else if (deletePolicy) {
                    ServiceReferenceHolder.getInstance().getKeyManagerDataService().removeSubscriptionPolicy((SubscriptionPolicyEvent)policyEvent);
                }
            } else if (event.getPolicyType() == APIConstants.PolicyType.APPLICATION) {
                policyEvent = (ApplicationPolicyEvent)new Gson().fromJson(eventJson, ApplicationPolicyEvent.class);
                if (updatePolicy) {
                    ServiceReferenceHolder.getInstance().getKeyManagerDataService().addOrUpdateApplicationPolicy((ApplicationPolicyEvent)policyEvent);
                } else if (deletePolicy) {
                    ServiceReferenceHolder.getInstance().getKeyManagerDataService().removeApplicationPolicy((ApplicationPolicyEvent)policyEvent);
                }
            }
        } else if (APIConstants.EventType.ENDPOINT_CERTIFICATE_ADD.toString().equals(eventType) || APIConstants.EventType.ENDPOINT_CERTIFICATE_REMOVE.toString().equals(eventType)) {
            CertificateEvent certificateEvent = (CertificateEvent)new Gson().fromJson(eventJson, CertificateEvent.class);
            if (APIConstants.EventType.ENDPOINT_CERTIFICATE_ADD.toString().equals(eventType)) {
                try {
                    new EndpointCertificateDeployer(certificateEvent.getTenantDomain()).deployCertificate(certificateEvent.getAlias());
                }
                catch (APIManagementException e) {
                    log.error((Object)e);
                }
            } else if (APIConstants.EventType.ENDPOINT_CERTIFICATE_REMOVE.toString().equals(eventType)) {
                boolean tenantFlowStarted = false;
                try {
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(certificateEvent.getTenantDomain(), true);
                    tenantFlowStarted = true;
                    CertificateManagerImpl.getInstance().deleteCertificateFromGateway(certificateEvent.getAlias());
                }
                finally {
                    if (tenantFlowStarted) {
                        PrivilegedCarbonContext.endTenantFlow();
                    }
                }
            }
        } else if (APIConstants.EventType.GA_CONFIG_UPDATE.toString().equals(eventType)) {
            GoogleAnalyticsConfigEvent googleAnalyticsConfigEvent = (GoogleAnalyticsConfigEvent)new Gson().fromJson(eventJson, GoogleAnalyticsConfigEvent.class);
            try {
                new GoogleAnalyticsConfigDeployer(googleAnalyticsConfigEvent.getTenantDomain()).deploy();
            }
            catch (APIManagementException e) {
                log.error((Object)e);
            }
        }
    }

    static final /* synthetic */ void endTenantFlow_aroundBody4(GatewayJMSMessageListener ajc$this, JoinPoint joinPoint) {
        PrivilegedCarbonContext.endTenantFlow();
    }

    static final /* synthetic */ void startTenantFlow_aroundBody6(GatewayJMSMessageListener ajc$this, String tenantDomain, JoinPoint joinPoint) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
    }

    static final /* synthetic */ void handleAsyncWebhooksSubscriptionMessage_aroundBody8(GatewayJMSMessageListener ajc$this, JsonNode payloadData, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received event for -  Async Webhooks API subscription for : " + payloadData.get("apiUUID").asText()));
        }
        String apiUUID = payloadData.get("apiUUID").textValue();
        String appID = payloadData.get("appID").textValue();
        String tenantDomain = payloadData.get("tenantDomain").textValue();
        boolean isThrottled = payloadData.get("isThrottled").asBoolean();
        ServiceReferenceHolder.getInstance().getSubscriptionsDataService().updateThrottleStatus(appID, apiUUID, tenantDomain, isThrottled);
        if (!isThrottled) {
            String topicName = payloadData.get("topic").textValue();
            WebhooksDTO subscriber = new WebhooksDTO();
            subscriber.setApiUUID(apiUUID);
            subscriber.setApiContext(payloadData.get("apiContext").textValue());
            subscriber.setApiName(payloadData.get("apiName").textValue());
            subscriber.setApiVersion(payloadData.get("apiVersion").textValue());
            subscriber.setAppID(appID);
            subscriber.setCallbackURL(payloadData.get("callback").textValue());
            subscriber.setTenantDomain(tenantDomain);
            subscriber.setTenantId(payloadData.get("tenantId").intValue());
            subscriber.setSecret(payloadData.get("secret").textValue());
            subscriber.setExpiryTime(payloadData.get("expireAt").asLong());
            subscriber.setTopicName(topicName);
            subscriber.setApiTier(payloadData.get("apiTier").textValue());
            subscriber.setApplicationTier(payloadData.get("applicationTier").textValue());
            subscriber.setTier(payloadData.get("tier").textValue());
            subscriber.setSubscriberName(payloadData.get("subscriberName").textValue());
            ServiceReferenceHolder.getInstance().getSubscriptionsDataService().addSubscription(apiUUID, topicName, tenantDomain, subscriber);
        }
    }

    static final /* synthetic */ void handleAsyncWebhooksUnSubscriptionMessage_aroundBody10(GatewayJMSMessageListener ajc$this, JsonNode payloadData, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received event for -  Async Webhooks API unsubscription for : " + payloadData.get("apiUUID").asText()));
        }
        String apiKey = payloadData.get("apiUUID").textValue();
        String tenantDomain = payloadData.get("tenantDomain").textValue();
        String topicName = payloadData.get("topic").textValue();
        WebhooksDTO subscriber = new WebhooksDTO();
        subscriber.setCallbackURL(payloadData.get("callback").textValue());
        subscriber.setAppID(payloadData.get("appID").textValue());
        subscriber.setSecret(payloadData.get("secret").textValue());
        ServiceReferenceHolder.getInstance().getSubscriptionsDataService().removeSubscription(apiKey, topicName, tenantDomain, subscriber);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GatewayJMSMessageListener.java", GatewayJMSMessageListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onMessage", "org.wso2.carbon.apimgt.gateway.listeners.GatewayJMSMessageListener", "javax.jms.Message", "message", "", "void"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleNotificationMessage", "org.wso2.carbon.apimgt.gateway.listeners.GatewayJMSMessageListener", "java.lang.String:long:java.lang.String", "eventType:timestamp:encodedEvent", "", "void"), 122);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "endTenantFlow", "org.wso2.carbon.apimgt.gateway.listeners.GatewayJMSMessageListener", "", "", "", "void"), 298);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "startTenantFlow", "org.wso2.carbon.apimgt.gateway.listeners.GatewayJMSMessageListener", "java.lang.String", "tenantDomain", "", "void"), 303);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22", "handleAsyncWebhooksSubscriptionMessage", "org.wso2.carbon.apimgt.gateway.listeners.GatewayJMSMessageListener", "com.fasterxml.jackson.databind.JsonNode", "payloadData", "", "void"), 310);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22", "handleAsyncWebhooksUnSubscriptionMessage", "org.wso2.carbon.apimgt.gateway.listeners.GatewayJMSMessageListener", "com.fasterxml.jackson.databind.JsonNode", "payloadData", "", "void"), 344);
    }
}

