/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.dto.ResourceCacheInvalidationDto;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.listeners.APIMgtGatewayCacheMessageListener$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.listeners.APIMgtGatewayCacheMessageListener$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.listeners.APIMgtGatewayCacheMessageListener$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.listeners.APIMgtGatewayCacheMessageListener$AjcClosure7;

public class APIMgtGatewayCacheMessageListener
implements MessageListener {
    private static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        APIMgtGatewayCacheMessageListener.ajc$preClinit();
        log = LogFactory.getLog(APIMgtGatewayCacheMessageListener.class);
    }

    public void onMessage(Message message) {
        Message message2 = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)message2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, message2, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIMgtGatewayCacheMessageListener$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        APIMgtGatewayCacheMessageListener.onMessage_aroundBody0(this, message2, joinPoint);
    }

    private void handleUserCacheInvalidationMessage(JSONArray jsonValue) throws ParseException {
        JSONArray jSONArray = jsonValue;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)jSONArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, jSONArray, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIMgtGatewayCacheMessageListener$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        APIMgtGatewayCacheMessageListener.handleUserCacheInvalidationMessage_aroundBody2(this, jSONArray, joinPoint);
    }

    private void handleKeyCacheInvalidationMessage(JSONArray jsonValue) throws ParseException {
        JSONArray jSONArray = jsonValue;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)jSONArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, jSONArray, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIMgtGatewayCacheMessageListener$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        APIMgtGatewayCacheMessageListener.handleKeyCacheInvalidationMessage_aroundBody4(this, jSONArray, joinPoint);
    }

    private void handleResourceCacheInvalidationMessage(JSONObject jsonValue) throws ParseException {
        JSONObject jSONObject = jsonValue;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)jSONObject);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, jSONObject, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIMgtGatewayCacheMessageListener$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        APIMgtGatewayCacheMessageListener.handleResourceCacheInvalidationMessage_aroundBody6(this, jSONObject, joinPoint);
    }

    static final /* synthetic */ void onMessage_aroundBody0(APIMgtGatewayCacheMessageListener ajc$this, Message message, JoinPoint joinPoint) {
        try {
            if (message != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event received in JMS Event Receiver - " + message));
                }
                Topic jmsDestination = (Topic)message.getJMSDestination();
                if (message instanceof TextMessage) {
                    String textMessage = ((TextMessage)message).getText();
                    JsonNode payloadData = new ObjectMapper().readTree(textMessage).path("event").path("payloadData");
                    if ("cacheInvalidation".equalsIgnoreCase(jmsDestination.getTopicName()) && payloadData.get("type").asText() != null) {
                        String value = payloadData.get("value").asText();
                        JSONParser jsonParser = new JSONParser();
                        if ("resourceCache".equalsIgnoreCase(payloadData.get("type").asText())) {
                            ajc$this.handleResourceCacheInvalidationMessage((JSONObject)jsonParser.parse(value));
                        } else if ("gatewayKeyCache".equalsIgnoreCase(payloadData.get("type").asText())) {
                            ajc$this.handleKeyCacheInvalidationMessage((JSONArray)jsonParser.parse(value));
                        } else if ("gatewayUsernameCache".equalsIgnoreCase(payloadData.get("type").asText())) {
                            ajc$this.handleUserCacheInvalidationMessage((JSONArray)jsonParser.parse(value));
                        }
                    }
                } else {
                    log.warn((Object)("Event dropped due to unsupported message type " + message.getClass()));
                }
            } else {
                log.warn((Object)"Dropping the empty/null event received through jms receiver");
            }
        }
        catch (JsonProcessingException | JMSException e) {
            log.error((Object)"JMSException occurred when processing the received message ", e);
        }
        catch (ParseException e) {
            log.error((Object)"Error while processing evaluatedConditions", (Throwable)e);
        }
    }

    static final /* synthetic */ void handleUserCacheInvalidationMessage_aroundBody2(APIMgtGatewayCacheMessageListener ajc$this, JSONArray jsonValue, JoinPoint joinPoint) {
        ServiceReferenceHolder.getInstance().getCacheInvalidationService().invalidateCachedUsernames((String[])jsonValue.toArray((Object[])new String[0]));
    }

    static final /* synthetic */ void handleKeyCacheInvalidationMessage_aroundBody4(APIMgtGatewayCacheMessageListener ajc$this, JSONArray jsonValue, JoinPoint joinPoint) {
        ServiceReferenceHolder.getInstance().getCacheInvalidationService().invalidateCachedTokens((String[])jsonValue.toArray((Object[])new String[0]));
    }

    static final /* synthetic */ void handleResourceCacheInvalidationMessage_aroundBody6(APIMgtGatewayCacheMessageListener ajc$this, JSONObject jsonValue, JoinPoint joinPoint) {
        String apiContext = (String)jsonValue.get((Object)"apiContext");
        String apiVersion = (String)jsonValue.get((Object)"apiVersion");
        JSONArray resources = (JSONArray)jsonValue.get((Object)"resources");
        ArrayList<ResourceCacheInvalidationDto> resourceCacheInvalidationDtoList = new ArrayList<ResourceCacheInvalidationDto>();
        for (Object resource : resources) {
            JSONObject uriTemplate = (JSONObject)resource;
            String resourceURLContext = (String)uriTemplate.get((Object)"resourceURLContext");
            String httpVerb = (String)uriTemplate.get((Object)"httpVerb");
            ResourceCacheInvalidationDto uriTemplateDto = new ResourceCacheInvalidationDto();
            uriTemplateDto.setHttpVerb(httpVerb);
            uriTemplateDto.setResourceURLContext(resourceURLContext);
            resourceCacheInvalidationDtoList.add(uriTemplateDto);
        }
        ServiceReferenceHolder.getInstance().getCacheInvalidationService().invalidateResourceCache(apiContext, apiVersion, resourceCacheInvalidationDtoList.toArray(new ResourceCacheInvalidationDto[0]));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("APIMgtGatewayCacheMessageListener.java", APIMgtGatewayCacheMessageListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onMessage", "org.wso2.carbon.apimgt.gateway.listeners.APIMgtGatewayCacheMessageListener", "javax.jms.Message", "message", "", "void"), 43);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleUserCacheInvalidationMessage", "org.wso2.carbon.apimgt.gateway.listeners.APIMgtGatewayCacheMessageListener", "org.json.simple.JSONArray", "jsonValue", "org.json.simple.parser.ParseException", "void"), 85);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleKeyCacheInvalidationMessage", "org.wso2.carbon.apimgt.gateway.listeners.APIMgtGatewayCacheMessageListener", "org.json.simple.JSONArray", "jsonValue", "org.json.simple.parser.ParseException", "void"), 90);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleResourceCacheInvalidationMessage", "org.wso2.carbon.apimgt.gateway.listeners.APIMgtGatewayCacheMessageListener", "org.json.simple.JSONObject", "jsonValue", "org.json.simple.parser.ParseException", "void"), 95);
    }
}

