/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.jwt;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.dto.RevokedJWTTokenDTO;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTDataHolder;
import org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTTokensRetriever$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTTokensRetriever$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTTokensRetriever$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTTokensRetriever$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTTokensRetriever$AjcClosure9;
import org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;

public class RevokedJWTTokensRetriever
extends TimerTask {
    private static final Log log;
    private static final int revokedJWTTokensRetrievalTimeoutInSeconds = 15;
    private static final int revokedJWTTokensRetrievalRetries = 15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        RevokedJWTTokensRetriever.ajc$preClinit();
        log = LogFactory.getLog(RevokedJWTTokensRetriever.class);
    }

    @Override
    public void run() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new RevokedJWTTokensRetriever$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RevokedJWTTokensRetriever.run_aroundBody0(this, joinPoint);
    }

    private RevokedJWTTokenDTO[] retrieveRevokedJWTTokensData() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (RevokedJWTTokenDTO[])MethodTimeLogger.aspectOf().log(new RevokedJWTTokensRetriever$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return RevokedJWTTokensRetriever.retrieveRevokedJWTTokensData_aroundBody2(this, joinPoint);
    }

    private void loadRevokedJWTTokensFromWebService() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new RevokedJWTTokensRetriever$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RevokedJWTTokensRetriever.loadRevokedJWTTokensFromWebService_aroundBody4(this, joinPoint);
    }

    public void startRevokedJWTTokensRetriever() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new RevokedJWTTokensRetriever$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RevokedJWTTokensRetriever.startRevokedJWTTokensRetriever_aroundBody6(this, joinPoint);
    }

    protected EventHubConfigurationDto getEventHubConfiguration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (EventHubConfigurationDto)MethodTimeLogger.aspectOf().log(new RevokedJWTTokensRetriever$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return RevokedJWTTokensRetriever.getEventHubConfiguration_aroundBody8(this, joinPoint);
    }

    static final /* synthetic */ void run_aroundBody0(RevokedJWTTokensRetriever ajc$this, JoinPoint joinPoint) {
        log.debug((Object)"Starting web service based revoked JWT tokens retrieving process.");
        ajc$this.loadRevokedJWTTokensFromWebService();
    }

    static final /* synthetic */ RevokedJWTTokenDTO[] retrieveRevokedJWTTokensData_aroundBody2(RevokedJWTTokensRetriever ajc$this, JoinPoint joinPoint) {
        try {
            boolean retry;
            String url = ajc$this.getEventHubConfiguration().getServiceUrl().concat("/internal/data/v1").concat("/revokedjwt");
            HttpGet method = new HttpGet(url);
            byte[] credentials = Base64.encodeBase64((byte[])(String.valueOf(ajc$this.getEventHubConfiguration().getUsername()) + ":" + ajc$this.getEventHubConfiguration().getPassword()).getBytes(StandardCharsets.UTF_8));
            method.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
            URL keyMgtURL = new URL(url);
            int keyMgtPort = keyMgtURL.getPort();
            String keyMgtProtocol = keyMgtURL.getProtocol();
            HttpClient httpClient = APIUtil.getHttpClient((int)keyMgtPort, (String)keyMgtProtocol);
            HttpResponse httpResponse = null;
            int retryCount = 0;
            do {
                try {
                    httpResponse = httpClient.execute((HttpUriRequest)method);
                    retry = false;
                }
                catch (IOException ex) {
                    if (++retryCount < 15) {
                        retry = true;
                        log.warn((Object)("Failed retrieving revoked JWT token signatures from remote endpoint: " + ex.getMessage() + ". Retrying after " + 15 + " seconds..."));
                        Thread.sleep(15000L);
                        continue;
                    }
                    throw ex;
                }
            } while (retry);
            String responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            if (responseString != null && !responseString.isEmpty()) {
                return (RevokedJWTTokenDTO[])new Gson().fromJson(responseString, RevokedJWTTokenDTO[].class);
            }
        }
        catch (IOException | InterruptedException e) {
            log.error((Object)"Exception when retrieving revoked JWT tokens from remote endpoint ", (Throwable)e);
        }
        return null;
    }

    static final /* synthetic */ void loadRevokedJWTTokensFromWebService_aroundBody4(RevokedJWTTokensRetriever ajc$this, JoinPoint joinPoint) {
        RevokedJWTTokenDTO[] revokedJWTTokenDTOS = ajc$this.retrieveRevokedJWTTokensData();
        if (revokedJWTTokenDTOS != null) {
            RevokedJWTTokenDTO[] revokedJWTTokenDTOArray = revokedJWTTokenDTOS;
            int n = revokedJWTTokenDTOS.length;
            int n2 = 0;
            while (n2 < n) {
                RevokedJWTTokenDTO revokedJWTToken = revokedJWTTokenDTOArray[n2];
                RevokedJWTDataHolder.getInstance().addRevokedJWTToMap(revokedJWTToken.getSignature(), revokedJWTToken.getExpiryTime());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JWT signature : " + revokedJWTToken.getSignature() + " added to the revoke map."));
                }
                ++n2;
            }
        } else {
            log.debug((Object)"No revoked JWT tokens are retrieved via web service");
        }
    }

    static final /* synthetic */ void startRevokedJWTTokensRetriever_aroundBody6(RevokedJWTTokensRetriever ajc$this, JoinPoint joinPoint) {
        new Timer().schedule((TimerTask)ajc$this, ajc$this.getEventHubConfiguration().getInitDelay());
    }

    static final /* synthetic */ EventHubConfigurationDto getEventHubConfiguration_aroundBody8(RevokedJWTTokensRetriever ajc$this, JoinPoint joinPoint) {
        return ServiceReferenceHolder.getInstance().getAPIManagerConfiguration().getEventHubConfigurationDto();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RevokedJWTTokensRetriever.java", RevokedJWTTokensRetriever.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTTokensRetriever", "", "", "", "void"), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "retrieveRevokedJWTTokensData", "org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTTokensRetriever", "", "", "", "[Lorg.wso2.carbon.apimgt.gateway.dto.RevokedJWTTokenDTO;"), 63);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadRevokedJWTTokensFromWebService", "org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTTokensRetriever", "", "", "", "void"), 108);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "startRevokedJWTTokensRetriever", "org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTTokensRetriever", "", "", "", "void"), 128);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getEventHubConfiguration", "org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTTokensRetriever", "", "", "", "org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto"), 133);
    }
}

