/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.streaming.sse;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.passthru.DefaultStreamInterceptor;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONObject;
import org.wso2.carbon.apimgt.common.analytics.collectors.AnalyticsDataProvider;
import org.wso2.carbon.apimgt.common.analytics.collectors.impl.GenericRequestDataCollector;
import org.wso2.carbon.apimgt.common.analytics.exceptions.AnalyticsException;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.Utils;
import org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.analytics.SseResponseEventDataProvider;
import org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.throttling.ThrottleInfo;
import org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.utils.SseUtils;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;

public class SseResponseStreamInterceptor
extends DefaultStreamInterceptor {
    private static final Log log;
    private static final String SSE_STREAM_DELIMITER = "\n\n";
    private static final int DEFAULT_NO_OF_THROTTLE_PUBLISHER_EXECUTORS = 100;
    private String charset = StandardCharsets.UTF_8.name();
    private ExecutorService throttlePublisherService = Executors.newFixedThreadPool(this.noOfExecutorThreads);
    private int noOfExecutorThreads = 100;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        SseResponseStreamInterceptor.ajc$preClinit();
        log = LogFactory.getLog(SseResponseStreamInterceptor.class);
    }

    public boolean interceptTargetResponse(MessageContext axisCtx) {
        MessageContext messageContext = axisCtx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)messageContext);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new SseResponseStreamInterceptor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return SseResponseStreamInterceptor.interceptTargetResponse_aroundBody0(this, messageContext, joinPoint);
    }

    public boolean targetResponse(ByteBuffer buffer, MessageContext axis2Ctx) {
        ByteBuffer byteBuffer = buffer;
        MessageContext messageContext = axis2Ctx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)byteBuffer, (Object)messageContext);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, byteBuffer, messageContext, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new SseResponseStreamInterceptor$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return SseResponseStreamInterceptor.targetResponse_aroundBody2(this, byteBuffer, messageContext, joinPoint);
    }

    public void setNoOfExecutorThreads(int executorThreads) {
        int n = executorThreads;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
            MethodTimeLogger.aspectOf().log(new SseResponseStreamInterceptor$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.noOfExecutorThreads = n;
    }

    private int getEventCount(ByteBuffer stream) {
        ByteBuffer byteBuffer = stream;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)byteBuffer);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, byteBuffer, joinPoint};
            return Conversions.intValue((Object)MethodTimeLogger.aspectOf().log(new SseResponseStreamInterceptor$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return SseResponseStreamInterceptor.getEventCount_aroundBody6(this, byteBuffer, joinPoint);
    }

    private boolean handleThrottlingAndAnalytics(int eventCount, MessageContext axi2Ctx) {
        int n = eventCount;
        MessageContext messageContext = axi2Ctx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n), (Object)messageContext);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), messageContext, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new SseResponseStreamInterceptor$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return SseResponseStreamInterceptor.handleThrottlingAndAnalytics_aroundBody8(this, n, messageContext, joinPoint);
    }

    private void publishAnalyticsData(int eventCount, MessageContext axi2Ctx) throws AnalyticsException {
        int n = eventCount;
        MessageContext messageContext = axi2Ctx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n), (Object)messageContext);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), messageContext, joinPoint};
            MethodTimeLogger.aspectOf().log(new SseResponseStreamInterceptor$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        SseResponseStreamInterceptor.publishAnalyticsData_aroundBody10(this, n, messageContext, joinPoint);
    }

    public void setCharset(String charset) {
        String string = charset;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && ((Object)((Object)this)).getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new SseResponseStreamInterceptor$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.charset = string;
    }

    static final /* synthetic */ boolean interceptTargetResponse_aroundBody0(SseResponseStreamInterceptor ajc$this, MessageContext axisCtx, JoinPoint joinPoint) {
        Object artifactType = axisCtx.getProperty("SYNAPSE_ARTIFACT_TYPE");
        return "SSE".equals(artifactType);
    }

    static final /* synthetic */ boolean targetResponse_aroundBody2(SseResponseStreamInterceptor ajc$this, ByteBuffer buffer, MessageContext axis2Ctx, JoinPoint joinPoint) {
        int eventCount = ajc$this.getEventCount(buffer);
        if (log.isDebugEnabled()) {
            log.debug((Object)("No. of events =" + eventCount));
        }
        if (eventCount > 0) {
            return ajc$this.handleThrottlingAndAnalytics(eventCount, axis2Ctx);
        }
        return true;
    }

    static final /* synthetic */ int getEventCount_aroundBody6(SseResponseStreamInterceptor ajc$this, ByteBuffer stream, JoinPoint joinPoint) {
        Charset charsetValue = Charset.forName(ajc$this.charset);
        String text = charsetValue.decode(stream).toString();
        return StringUtils.countMatches((CharSequence)text, (CharSequence)SSE_STREAM_DELIMITER);
    }

    static final /* synthetic */ boolean handleThrottlingAndAnalytics_aroundBody8(SseResponseStreamInterceptor ajc$this, int eventCount, MessageContext axi2Ctx, JoinPoint joinPoint) {
        Object throttleObject = axi2Ctx.getProperty("sse_throttle_dto");
        if (throttleObject != null) {
            String messageId = UIDGenerator.generateURNString();
            ThrottleInfo throttleInfo = (ThrottleInfo)throttleObject;
            String remoteIP = throttleInfo.getRemoteIp();
            JSONObject propertiesMap = new JSONObject();
            Utils.setRemoteIp(propertiesMap, remoteIP);
            boolean isThrottled = SseUtils.isThrottled(throttleInfo.getSubscriberTenantDomain(), throttleInfo.getResourceLevelThrottleKey(), throttleInfo.getSubscriptionLevelThrottleKey(), throttleInfo.getApplicationLevelThrottleKey());
            if (isThrottled) {
                log.warn((Object)"Request is throttled out");
                return false;
            }
            ajc$this.throttlePublisherService.execute(() -> {
                int n = eventCount;
                String string = messageId;
                ThrottleInfo throttleInfo = throttleInfo;
                JSONObject jSONObject = propertiesMap;
                Object[] objectArray = new Object[]{Conversions.intObject((int)n), string, throttleInfo, jSONObject};
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object[])objectArray);
                if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
                    Object[] objectArray2 = new Object[]{Conversions.intObject((int)n), string, throttleInfo, jSONObject, joinPoint};
                    MethodTimeLogger.aspectOf().log(new SseResponseStreamInterceptor$AjcClosure15(objectArray2).linkClosureAndJoinPoint(65536));
                    return;
                }
                SseResponseStreamInterceptor.lambda$0_aroundBody14(n, string, throttleInfo, jSONObject, joinPoint);
            });
            if (APIUtil.isAnalyticsEnabled()) {
                try {
                    ajc$this.publishAnalyticsData(eventCount, axi2Ctx);
                }
                catch (AnalyticsException e) {
                    log.error((Object)"Error while publishing analytics data", (Throwable)e);
                }
            }
            return true;
        }
        log.error((Object)"Throttle object cannot be null.");
        return true;
    }

    static final /* synthetic */ void publishAnalyticsData_aroundBody10(SseResponseStreamInterceptor ajc$this, int eventCount, MessageContext axi2Ctx, JoinPoint joinPoint) {
        Object responseEventProvider = axi2Ctx.getProperty("sse_analytics_info");
        if (responseEventProvider == null) {
            log.error((Object)"SSE Analytics event provider is null.");
            return;
        }
        SseResponseEventDataProvider provider = (SseResponseEventDataProvider)responseEventProvider;
        provider.setResponseCode((Integer)axi2Ctx.getProperty("HTTP_SC"));
        GenericRequestDataCollector dataCollector = new GenericRequestDataCollector((AnalyticsDataProvider)provider);
        int count = 0;
        while (count < eventCount) {
            dataCollector.collectData();
            ++count;
        }
    }

    static final /* synthetic */ void lambda$0_aroundBody14(int n, String string, ThrottleInfo throttleInfo, JSONObject jSONObject, JoinPoint joinPoint) {
        SseUtils.publishNonThrottledEvent(n, string, throttleInfo, jSONObject);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SseResponseStreamInterceptor.java", SseResponseStreamInterceptor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "interceptTargetResponse", "org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor", "org.apache.axis2.context.MessageContext", "axisCtx", "", "boolean"), 66);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "targetResponse", "org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor", "java.nio.ByteBuffer:org.apache.axis2.context.MessageContext", "buffer:axis2Ctx", "", "boolean"), 72);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNoOfExecutorThreads", "org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor", "int", "executorThreads", "", "void"), 84);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getEventCount", "org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor", "java.nio.ByteBuffer", "stream", "", "int"), 88);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleThrottlingAndAnalytics", "org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor", "int:org.apache.axis2.context.MessageContext", "eventCount:axi2Ctx", "", "boolean"), 94);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "publishAnalyticsData", "org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor", "int:org.apache.axis2.context.MessageContext", "eventCount:axi2Ctx", "org.wso2.carbon.apimgt.common.analytics.exceptions.AnalyticsException", "void"), 127);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCharset", "org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor", "java.lang.String", "charset", "", "void"), 142);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("100a", "lambda$0", "org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseResponseStreamInterceptor", "int:java.lang.String:org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.throttling.ThrottleInfo:org.json.JSONObject", "arg0:arg1:arg2:arg3", "", "void"), 112);
    }
}

