/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.security.oauth;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.cache.Cache;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIKeyValidator;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityConstants;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityUtils;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationResponse;
import org.wso2.carbon.apimgt.gateway.handlers.security.Authenticator;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure19;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure21;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure23;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure25;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure27;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure29;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure31;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure33;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure35;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure37;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure39;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure41;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure43;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure45;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure47;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure49;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure51;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure53;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure55;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure57;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure59;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure61;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure63;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.utils.GatewayUtils;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.caching.CacheProvider;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;
import org.wso2.carbon.apimgt.impl.dto.ExtendedJWTConfigurationDto;
import org.wso2.carbon.apimgt.impl.jwt.SignedJWTInfo;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.tracing.TracingSpan;
import org.wso2.carbon.apimgt.tracing.TracingTracer;
import org.wso2.carbon.apimgt.tracing.Util;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.carbon.metrics.manager.Timer;

public class OAuthAuthenticator
implements Authenticator {
    private static final Log log;
    private List<String> keyManagerList;
    protected APIKeyValidator keyValidator = null;
    protected JWTValidator jwtValidator = null;
    private String securityHeader = "Authorization";
    private SynapseEnvironment environment = null;
    private APIManagerConfiguration config = null;
    private String defaultAPIHeader = "WSO2_AM_API_DEFAULT_VERSION";
    private String consumerKeyHeaderSegment = "Bearer";
    private String oauthHeaderSplitter = ",";
    private String consumerKeySegmentDelimiter = " ";
    private String securityContextHeader;
    private boolean removeOAuthHeadersFromOutMessage = true;
    private boolean removeDefaultAPIHeaderFromOutMessage = true;
    private String clientDomainHeader = "referer";
    private String requestOrigin;
    private String remainingAuthHeader;
    private boolean isMandatory;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;

    static {
        OAuthAuthenticator.ajc$preClinit();
        log = LogFactory.getLog(OAuthAuthenticator.class);
    }

    public OAuthAuthenticator() {
    }

    public OAuthAuthenticator(String authorizationHeader, boolean isMandatory, boolean removeOAuthHeader, List<String> keyManagerList) {
        this.securityHeader = authorizationHeader;
        this.removeOAuthHeadersFromOutMessage = removeOAuthHeader;
        this.isMandatory = isMandatory;
        this.keyManagerList = keyManagerList;
    }

    @Override
    public void init(SynapseEnvironment env) {
        SynapseEnvironment synapseEnvironment = env;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)synapseEnvironment);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, synapseEnvironment, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.environment = synapseEnvironment;
    }

    @Override
    public void destroy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        OAuthAuthenticator.destroy_aroundBody2(this, joinPoint);
    }

    @Override
    @MethodStats
    public AuthenticationResponse authenticate(org.apache.synapse.MessageContext synCtx) throws APIManagementException {
        org.apache.synapse.MessageContext messageContext = synCtx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)messageContext);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return (AuthenticationResponse)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.authenticate_aroundBody4(this, messageContext, joinPoint);
    }

    public String extractCustomerKeyFromAuthHeader(Map headersMap) {
        Map map = headersMap;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)map);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, map, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.extractCustomerKeyFromAuthHeader_aroundBody6(this, map, joinPoint);
    }

    private String removeLeadingAndTrailing(String base) {
        String string = base;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.removeLeadingAndTrailing_aroundBody8(this, string, joinPoint);
    }

    protected APIManagerConfiguration getApiManagerConfiguration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (APIManagerConfiguration)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.getApiManagerConfiguration_aroundBody10(this, joinPoint);
    }

    @Override
    public String getChallengeString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.getChallengeString_aroundBody12(this, joinPoint);
    }

    private String getClientDomain(org.apache.synapse.MessageContext synCtx) {
        org.apache.synapse.MessageContext messageContext = synCtx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)messageContext);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.getClientDomain_aroundBody14(this, messageContext, joinPoint);
    }

    @Override
    public String getRequestOrigin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.requestOrigin;
    }

    public String getSecurityHeader() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.getSecurityHeader_aroundBody18(this, joinPoint);
    }

    public void setSecurityHeader(String securityHeader) {
        String string = securityHeader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.securityHeader = string;
    }

    public String getDefaultAPIHeader() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.defaultAPIHeader;
    }

    public void setDefaultAPIHeader(String defaultAPIHeader) {
        String string = defaultAPIHeader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.defaultAPIHeader = string;
    }

    public String getConsumerKeyHeaderSegment() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure27(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.consumerKeyHeaderSegment;
    }

    public void setConsumerKeyHeaderSegment(String consumerKeyHeaderSegment) {
        String string = consumerKeyHeaderSegment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure29(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.consumerKeyHeaderSegment = string;
    }

    public String getOauthHeaderSplitter() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure31(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.oauthHeaderSplitter;
    }

    public void setOauthHeaderSplitter(String oauthHeaderSplitter) {
        String string = oauthHeaderSplitter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure33(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.oauthHeaderSplitter = string;
    }

    public String getConsumerKeySegmentDelimiter() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure35(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.consumerKeySegmentDelimiter;
    }

    public void setConsumerKeySegmentDelimiter(String consumerKeySegmentDelimiter) {
        String string = consumerKeySegmentDelimiter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure37(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.consumerKeySegmentDelimiter = string;
    }

    private String getSecurityContextHeader() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure39(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.getSecurityContextHeader_aroundBody38(this, joinPoint);
    }

    private void setSecurityContextHeader(String securityContextHeader) {
        String string = securityContextHeader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure41(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.securityContextHeader = string;
    }

    private boolean isRemoveOAuthHeadersFromOutMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure43(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return OAuthAuthenticator.isRemoveOAuthHeadersFromOutMessage_aroundBody42(this, joinPoint);
    }

    private void setRemoveOAuthHeadersFromOutMessage(boolean removeOAuthHeadersFromOutMessage) {
        boolean bl = removeOAuthHeadersFromOutMessage;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure45(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.removeOAuthHeadersFromOutMessage = bl;
    }

    public String getClientDomainHeader() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure47(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.clientDomainHeader;
    }

    public void setClientDomainHeader(String clientDomainHeader) {
        String string = clientDomainHeader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure49(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.clientDomainHeader = string;
    }

    public boolean isRemoveDefaultAPIHeaderFromOutMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure51(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return this.removeDefaultAPIHeaderFromOutMessage;
    }

    public void setRemoveDefaultAPIHeaderFromOutMessage(boolean removeDefaultAPIHeaderFromOutMessage) {
        boolean bl = removeDefaultAPIHeaderFromOutMessage;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure53(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.removeDefaultAPIHeaderFromOutMessage = bl;
    }

    public void setRequestOrigin(String requestOrigin) {
        String string = requestOrigin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure55(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.requestOrigin = string;
    }

    protected Timer getTimer(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (Timer)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure57(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.getTimer_aroundBody56(this, string, joinPoint);
    }

    protected APIKeyValidator getAPIKeyValidator() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (APIKeyValidator)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure59(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.keyValidator;
    }

    @Override
    public int getPriority() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.intValue((Object)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure61(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return OAuthAuthenticator.getPriority_aroundBody60(this, joinPoint);
    }

    private SignedJWTInfo getSignedJwt(String accessToken) throws ParseException {
        String string = accessToken;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (SignedJWTInfo)MethodTimeLogger.aspectOf().log(new OAuthAuthenticator$AjcClosure63(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OAuthAuthenticator.getSignedJwt_aroundBody62(this, string, joinPoint);
    }

    static final /* synthetic */ void destroy_aroundBody2(OAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        if (ajc$this.keyValidator != null) {
            ajc$this.keyValidator.cleanup();
        }
    }

    static final /* synthetic */ AuthenticationResponse authenticate_aroundBody4(OAuthAuthenticator ajc$this, org.apache.synapse.MessageContext synCtx, JoinPoint joinPoint) {
        APIKeyValidationInfoDTO info;
        String authenticationScheme;
        boolean isJwtToken = false;
        String accessToken = null;
        boolean defaultVersionInvoked = false;
        TracingSpan getClientDomainSpan = null;
        TracingSpan authenticationSchemeSpan = null;
        TracingSpan keyInfo = null;
        Map headers = (Map)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS");
        String tenantDomain = GatewayUtils.getTenantDomain();
        if (ajc$this.keyValidator == null) {
            ajc$this.keyValidator = new APIKeyValidator();
        }
        if (ajc$this.jwtValidator == null) {
            ajc$this.jwtValidator = new JWTValidator(ajc$this.keyValidator, tenantDomain);
        }
        ajc$this.config = ajc$this.getApiManagerConfiguration();
        ajc$this.removeOAuthHeadersFromOutMessage = ajc$this.isRemoveOAuthHeadersFromOutMessage();
        ajc$this.securityContextHeader = ajc$this.getSecurityContextHeader();
        if (headers != null) {
            ajc$this.requestOrigin = (String)headers.get("Origin");
            accessToken = ajc$this.extractCustomerKeyFromAuthHeader(headers);
            if (log.isDebugEnabled()) {
                log.debug((Object)(accessToken != null ? "Received Token ".concat(accessToken) : "No valid Authorization header found"));
            }
            defaultVersionInvoked = headers.containsKey(ajc$this.defaultAPIHeader);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Default Version API invoked");
        }
        if (ajc$this.removeOAuthHeadersFromOutMessage) {
            if (StringUtils.isNotBlank((CharSequence)ajc$this.remainingAuthHeader)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Removing OAuth key from Authorization header");
                }
                headers.put(ajc$this.getSecurityHeader(), ajc$this.remainingAuthHeader);
                ajc$this.remainingAuthHeader = "";
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Removing Authorization header from headers");
                }
                headers.remove(ajc$this.getSecurityHeader());
            }
        }
        if (ajc$this.removeDefaultAPIHeaderFromOutMessage) {
            headers.remove(ajc$this.defaultAPIHeader);
        }
        String apiContext = (String)synCtx.getProperty("REST_API_CONTEXT");
        String apiVersion = (String)synCtx.getProperty("SYNAPSE_REST_API_VERSION");
        String httpMethod = (String)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("HTTP_METHOD");
        String matchingResource = (String)synCtx.getProperty("API_ELECTED_RESOURCE");
        SignedJWTInfo signedJWTInfo = null;
        if (Util.tracingEnabled()) {
            TracingSpan keySpan = (TracingSpan)synCtx.getProperty("API:Key_Validation_Latency");
            TracingTracer tracer = Util.getGlobalTracer();
            getClientDomainSpan = Util.startSpan((String)"API:Get_Client_Domain()", (TracingSpan)keySpan, (TracingTracer)tracer);
        }
        String clientDomain = ajc$this.getClientDomain(synCtx);
        if (Util.tracingEnabled()) {
            Util.finishSpan(getClientDomainSpan);
        }
        if (log.isDebugEnabled() && clientDomain != null) {
            log.debug((Object)"Received Client Domain ".concat(clientDomain));
        }
        Timer timer = ajc$this.getTimer(MetricManager.name((String)"org.wso2.am", (String[])new String[]{ajc$this.getClass().getSimpleName(), "GET_RESOURCE_AUTH"}));
        Timer.Context context = timer.start();
        MessageContext axis2MessageCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        MessageContext.setCurrentMessageContext((MessageContext)axis2MessageCtx);
        if (Util.tracingEnabled()) {
            TracingSpan keySpan = (TracingSpan)synCtx.getProperty("API:Key_Validation_Latency");
            TracingTracer tracer = Util.getGlobalTracer();
            authenticationSchemeSpan = Util.startSpan((String)"API:Get_Resource_Authentication_Scheme()", (TracingSpan)keySpan, (TracingTracer)tracer);
        }
        try {
            block54: {
                if (StringUtils.isNotEmpty((CharSequence)accessToken) && accessToken.contains(".")) {
                    try {
                        if (StringUtils.countMatches((CharSequence)accessToken, (CharSequence)".") != 2) {
                            log.debug((Object)"Invalid JWT token. The expected token format is <header.payload.signature>");
                            throw new APISecurityException(900901, "Invalid JWT token");
                        }
                        signedJWTInfo = ajc$this.getSignedJwt(accessToken);
                        if (GatewayUtils.isInternalKey(signedJWTInfo.getJwtClaimsSet()) || GatewayUtils.isAPIKey(signedJWTInfo.getJwtClaimsSet())) {
                            log.debug((Object)"Invalid Token Provided");
                            return new AuthenticationResponse(false, ajc$this.isMandatory, true, 900901, "Invalid Credentials");
                        }
                        String keyManager = ServiceReferenceHolder.getInstance().getJwtValidationService().getKeyManagerNameIfJwtValidatorExist(signedJWTInfo);
                        if (!StringUtils.isNotEmpty((CharSequence)keyManager)) break block54;
                        if (ajc$this.keyManagerList.contains("all") || ajc$this.keyManagerList.contains(keyManager)) {
                            isJwtToken = true;
                            break block54;
                        }
                        return new AuthenticationResponse(false, ajc$this.isMandatory, true, 900901, "Invalid Credentials");
                    }
                    catch (IllegalArgumentException | ParseException e) {
                        log.debug((Object)"Not a JWT token. Failed to decode the token header.", (Throwable)e);
                    }
                    catch (APIManagementException e) {
                        log.error((Object)"error while check validation of JWt", (Throwable)e);
                        return new AuthenticationResponse(false, ajc$this.isMandatory, true, 900901, "Invalid Credentials");
                    }
                }
            }
            authenticationScheme = ajc$this.getAPIKeyValidator().getResourceAuthenticationScheme(synCtx);
        }
        catch (APISecurityException ex) {
            return new AuthenticationResponse(false, ajc$this.isMandatory, true, ex.getErrorCode(), ex.getMessage());
        }
        if (Util.tracingEnabled()) {
            Util.finishSpan((TracingSpan)authenticationSchemeSpan);
        }
        context.stop();
        if ("None".equals(authenticationScheme)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found Authentication Scheme: ".concat(authenticationScheme));
            }
            String clientIP = null;
            MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
            TreeMap transportHeaderMap = (TreeMap)axis2MessageContext.getProperty("TRANSPORT_HEADERS");
            if (transportHeaderMap != null) {
                clientIP = (String)transportHeaderMap.get("X-Forwarded-For");
            }
            if (clientIP != null && !clientIP.isEmpty()) {
                if (clientIP.indexOf(",") > 0) {
                    clientIP = clientIP.substring(0, clientIP.indexOf(","));
                }
            } else {
                clientIP = (String)axis2MessageContext.getProperty("REMOTE_ADDR");
            }
            AuthenticationContext authContext = new AuthenticationContext();
            authContext.setAuthenticated(true);
            authContext.setTier("Unauthenticated");
            authContext.setStopOnQuotaReach(true);
            authContext.setApiKey(clientIP);
            authContext.setKeyType("PRODUCTION");
            authContext.setUsername("anonymous");
            authContext.setCallerToken(null);
            authContext.setApplicationName(null);
            authContext.setApplicationId(clientIP);
            authContext.setApplicationUUID(clientIP);
            authContext.setConsumerKey(null);
            String apiNameFromContextAndVersion = GatewayUtils.getAPINameFromContextAndVersion(synCtx);
            synCtx.setProperty("API_NAME", (Object)apiNameFromContextAndVersion);
            APISecurityUtils.setAuthenticationContext(synCtx, authContext, ajc$this.securityContextHeader);
            return new AuthenticationResponse(true, ajc$this.isMandatory, false, 0, null);
        }
        if ("noMatchedAuthScheme".equals(authenticationScheme)) {
            info = new APIKeyValidationInfoDTO();
            info.setAuthorized(false);
            info.setValidationStatus(900906);
        } else {
            if (accessToken == null || apiContext == null || apiVersion == null) {
                if (log.isDebugEnabled()) {
                    if (accessToken == null) {
                        log.debug((Object)"OAuth headers not found");
                    } else if (apiContext == null) {
                        log.debug((Object)"Couldn't find API Context");
                    } else {
                        log.debug((Object)"Could not find api version");
                    }
                }
                return new AuthenticationResponse(false, ajc$this.isMandatory, true, 900902, "Required OAuth credentials not provided");
            }
            if (isJwtToken) {
                try {
                    AuthenticationContext authenticationContext = ajc$this.jwtValidator.authenticate(signedJWTInfo, synCtx);
                    APISecurityUtils.setAuthenticationContext(synCtx, authenticationContext, ajc$this.securityContextHeader);
                    log.debug((Object)"User is authorized using JWT token to access the resource.");
                    synCtx.setProperty("api.ut.userName", (Object)authenticationContext.getUsername());
                    return new AuthenticationResponse(true, ajc$this.isMandatory, false, 0, null);
                }
                catch (APISecurityException ex) {
                    return new AuthenticationResponse(false, ajc$this.isMandatory, true, ex.getErrorCode(), ex.getMessage());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Matching resource is: ".concat(matchingResource));
            }
            timer = ajc$this.getTimer(MetricManager.name((String)"org.wso2.am", (String[])new String[]{ajc$this.getClass().getSimpleName(), "GET_KEY_VALIDATION_INFO"}));
            context = timer.start();
            if (Util.tracingEnabled()) {
                TracingSpan keySpan = (TracingSpan)synCtx.getProperty("API:Key_Validation_Latency");
                TracingTracer tracer = Util.getGlobalTracer();
                keyInfo = Util.startSpan((String)"API:Get_Key_Validation_Info()", (TracingSpan)keySpan, (TracingTracer)tracer);
            }
            try {
                info = ajc$this.getAPIKeyValidator().getKeyValidationInfo(apiContext, accessToken, apiVersion, authenticationScheme, clientDomain, matchingResource, httpMethod, defaultVersionInvoked, ajc$this.keyManagerList);
            }
            catch (APISecurityException ex) {
                return new AuthenticationResponse(false, ajc$this.isMandatory, true, ex.getErrorCode(), ex.getMessage());
            }
            if (Util.tracingEnabled()) {
                Util.finishSpan((TracingSpan)keyInfo);
            }
            context.stop();
            synCtx.setProperty("api.ut.application.name", (Object)info.getApplicationName());
            synCtx.setProperty("api.ut.userName", (Object)info.getEndUserName());
            synCtx.setProperty("Scopes", info.getScopes() == null ? null : info.getScopes().toString());
        }
        if (info.isAuthorized()) {
            AuthenticationContext authContext = new AuthenticationContext();
            authContext.setAuthenticated(true);
            authContext.setTier(info.getTier());
            authContext.setApiKey(accessToken);
            authContext.setKeyType(info.getType());
            if (info.getEndUserName() != null) {
                authContext.setUsername(info.getEndUserName());
            } else {
                authContext.setUsername("anonymous");
            }
            authContext.setCallerToken(info.getEndUserToken());
            authContext.setApplicationId(info.getApplicationId());
            authContext.setApplicationUUID(info.getApplicationUUID());
            authContext.setApplicationName(info.getApplicationName());
            authContext.setApplicationTier(info.getApplicationTier());
            authContext.setSubscriber(info.getSubscriber());
            authContext.setConsumerKey(info.getConsumerKey());
            authContext.setApiTier(info.getApiTier());
            authContext.setThrottlingDataList(info.getThrottlingDataList());
            authContext.setSubscriberTenantDomain(info.getSubscriberTenantDomain());
            authContext.setSpikeArrestLimit(info.getSpikeArrestLimit());
            authContext.setSpikeArrestUnit(info.getSpikeArrestUnit());
            authContext.setStopOnQuotaReach(info.isStopOnQuotaReach());
            authContext.setIsContentAware(info.isContentAware());
            APISecurityUtils.setAuthenticationContext(synCtx, authContext, ajc$this.securityContextHeader);
            if (info.getProductName() != null && info.getProductProvider() != null) {
                authContext.setProductName(info.getProductName());
                authContext.setProductProvider(info.getProductProvider());
            }
            synCtx.setProperty("api.ut.apiPublisher", (Object)info.getApiPublisher());
            synCtx.setProperty("API_NAME", (Object)info.getApiName());
            if ("GRAPHQL".equals(synCtx.getProperty("API_TYPE"))) {
                synCtx.setProperty("max_query_depth", (Object)info.getGraphQLMaxDepth());
                synCtx.setProperty("max_query_complexity", (Object)info.getGraphQLMaxComplexity());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"User is authorized to access the Resource");
            }
            return new AuthenticationResponse(true, ajc$this.isMandatory, false, 0, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"User is NOT authorized to access the Resource");
        }
        return new AuthenticationResponse(false, ajc$this.isMandatory, true, info.getValidationStatus(), "Access failure for API: " + apiContext + ", version: " + apiVersion + " status: (" + info.getValidationStatus() + ") - " + APISecurityConstants.getAuthenticationFailureMessage(info.getValidationStatus()));
    }

    static final /* synthetic */ String extractCustomerKeyFromAuthHeader_aroundBody6(OAuthAuthenticator ajc$this, Map headersMap, JoinPoint joinPoint) {
        String authHeader = (String)headersMap.get(ajc$this.getSecurityHeader());
        if (authHeader == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"OAuth2 Authentication: Expected authorization header with the name '".concat(ajc$this.getSecurityHeader()).concat("' was not found."));
            }
            return null;
        }
        ArrayList<String> remainingAuthHeaders = new ArrayList<String>();
        String consumerKey = null;
        boolean consumerkeyFound = false;
        String[] headers = authHeader.split(ajc$this.oauthHeaderSplitter);
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                String[] elements = headers[i].split(ajc$this.consumerKeySegmentDelimiter);
                if (elements != null && elements.length > 1) {
                    int j = 0;
                    boolean isConsumerKeyHeaderAvailable = false;
                    String[] stringArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String element = stringArray[n2];
                        if (!"".equals(element.trim())) {
                            if (ajc$this.consumerKeyHeaderSegment.equals(elements[j].trim())) {
                                isConsumerKeyHeaderAvailable = true;
                            } else if (isConsumerKeyHeaderAvailable) {
                                consumerKey = ajc$this.removeLeadingAndTrailing(elements[j].trim());
                                consumerkeyFound = true;
                            }
                        }
                        ++j;
                        ++n2;
                    }
                }
                if (!consumerkeyFound) {
                    remainingAuthHeaders.add(headers[i]);
                } else {
                    consumerkeyFound = false;
                }
                ++i;
            }
        }
        ajc$this.remainingAuthHeader = String.join((CharSequence)ajc$this.oauthHeaderSplitter, remainingAuthHeaders);
        return consumerKey;
    }

    static final /* synthetic */ String removeLeadingAndTrailing_aroundBody8(OAuthAuthenticator ajc$this, String base, JoinPoint joinPoint) {
        String result = base;
        if (base.startsWith("\"") || base.endsWith("\"")) {
            result = base.replace("\"", "");
        }
        return result.trim();
    }

    static final /* synthetic */ APIManagerConfiguration getApiManagerConfiguration_aroundBody10(OAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        return ServiceReferenceHolder.getInstance().getAPIManagerConfiguration();
    }

    static final /* synthetic */ String getChallengeString_aroundBody12(OAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        return "Bearer realm=\"WSO2 API Manager\"";
    }

    static final /* synthetic */ String getClientDomain_aroundBody14(OAuthAuthenticator ajc$this, org.apache.synapse.MessageContext synCtx, JoinPoint joinPoint) {
        String clientDomainHeaderValue = null;
        Map headers = (Map)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS");
        if (headers != null) {
            clientDomainHeaderValue = (String)headers.get(ajc$this.clientDomainHeader);
        }
        return clientDomainHeaderValue;
    }

    static final /* synthetic */ String getSecurityHeader_aroundBody18(OAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        if (ajc$this.securityHeader == null) {
            try {
                ajc$this.securityHeader = APIUtil.getOAuthConfigurationFromAPIMConfig((String)"AuthorizationHeader");
                if (ajc$this.securityHeader == null) {
                    ajc$this.securityHeader = "Authorization";
                }
            }
            catch (APIManagementException e) {
                log.error((Object)"Error while reading authorization header from APIM configurations", (Throwable)e);
            }
        }
        return ajc$this.securityHeader;
    }

    static final /* synthetic */ String getSecurityContextHeader_aroundBody38(OAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        ExtendedJWTConfigurationDto jwtConfigurationDto = ajc$this.config.getJwtConfigurationDto();
        String value = jwtConfigurationDto.getJwtHeader();
        if (value != null) {
            ajc$this.setSecurityContextHeader(value);
        }
        return ajc$this.securityContextHeader;
    }

    static final /* synthetic */ boolean isRemoveOAuthHeadersFromOutMessage_aroundBody42(OAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        String value = ajc$this.config.getFirstProperty("OAuthConfigurations.RemoveOAuthHeadersFromOutMessage");
        if (value != null) {
            ajc$this.setRemoveOAuthHeadersFromOutMessage(Boolean.parseBoolean(value));
        }
        return ajc$this.removeOAuthHeadersFromOutMessage;
    }

    static final /* synthetic */ Timer getTimer_aroundBody56(OAuthAuthenticator ajc$this, String name, JoinPoint joinPoint) {
        return MetricManager.timer((Level)Level.INFO, (String)name);
    }

    static final /* synthetic */ int getPriority_aroundBody60(OAuthAuthenticator ajc$this, JoinPoint joinPoint) {
        return 10;
    }

    static final /* synthetic */ SignedJWTInfo getSignedJwt_aroundBody62(OAuthAuthenticator ajc$this, String accessToken, JoinPoint joinPoint) {
        String signature = accessToken.split("\\.")[2];
        SignedJWTInfo signedJWTInfo = null;
        Cache gatewaySignedJWTParseCache = CacheProvider.getGatewaySignedJWTParseCache();
        if (gatewaySignedJWTParseCache != null) {
            Object cachedEntry = gatewaySignedJWTParseCache.get((Object)signature);
            if (cachedEntry != null) {
                signedJWTInfo = (SignedJWTInfo)cachedEntry;
            }
            if (signedJWTInfo == null || !signedJWTInfo.getToken().equals(accessToken)) {
                SignedJWT signedJWT = SignedJWT.parse((String)accessToken);
                JWTClaimsSet jwtClaimsSet = signedJWT.getJWTClaimsSet();
                signedJWTInfo = new SignedJWTInfo(accessToken, signedJWT, jwtClaimsSet);
                gatewaySignedJWTParseCache.put((Object)signature, (Object)signedJWTInfo);
            }
        } else {
            SignedJWT signedJWT = SignedJWT.parse((String)accessToken);
            JWTClaimsSet jwtClaimsSet = signedJWT.getJWTClaimsSet();
            signedJWTInfo = new SignedJWTInfo(accessToken, signedJWT, jwtClaimsSet);
        }
        return signedJWTInfo;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OAuthAuthenticator.java", OAuthAuthenticator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "org.apache.synapse.core.SynapseEnvironment", "env", "", "void"), 104);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "void"), 108);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSecurityHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "securityHeader", "", "void"), 519);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDefaultAPIHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 523);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDefaultAPIHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "defaultAPIHeader", "", "void"), 527);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConsumerKeyHeaderSegment", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 531);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setConsumerKeyHeaderSegment", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "consumerKeyHeaderSegment", "", "void"), 535);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOauthHeaderSplitter", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 539);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setOauthHeaderSplitter", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "oauthHeaderSplitter", "", "void"), 543);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConsumerKeySegmentDelimiter", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 547);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setConsumerKeySegmentDelimiter", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "consumerKeySegmentDelimiter", "", "void"), 551);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSecurityContextHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 555);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "authenticate", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "org.apache.synapse.MessageContext", "synCtx", "org.wso2.carbon.apimgt.api.APIManagementException", "org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationResponse"), 115);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setSecurityContextHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "securityContextHeader", "", "void"), 564);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isRemoveOAuthHeadersFromOutMessage", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "boolean"), 568);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setRemoveOAuthHeadersFromOutMessage", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "boolean", "removeOAuthHeadersFromOutMessage", "", "void"), 576);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClientDomainHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 580);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClientDomainHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "clientDomainHeader", "", "void"), 584);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isRemoveDefaultAPIHeaderFromOutMessage", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "boolean"), 588);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRemoveDefaultAPIHeaderFromOutMessage", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "boolean", "removeDefaultAPIHeaderFromOutMessage", "", "void"), 592);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setRequestOrigin", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "requestOrigin", "", "void"), 596);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getTimer", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "name", "", "org.wso2.carbon.metrics.manager.Timer"), 600);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getAPIKeyValidator", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "org.wso2.carbon.apimgt.gateway.handlers.security.APIKeyValidator"), 603);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "extractCustomerKeyFromAuthHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.util.Map", "headersMap", "", "java.lang.String"), 428);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriority", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "int"), 608);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSignedJwt", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "accessToken", "java.text.ParseException", "org.wso2.carbon.apimgt.impl.jwt.SignedJWTInfo"), 612);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeLeadingAndTrailing", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "java.lang.String", "base", "", "java.lang.String"), 474);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getApiManagerConfiguration", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "org.wso2.carbon.apimgt.impl.APIManagerConfiguration"), 483);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getChallengeString", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 487);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getClientDomain", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "org.apache.synapse.MessageContext", "synCtx", "", "java.lang.String"), 491);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRequestOrigin", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 501);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSecurityHeader", "org.wso2.carbon.apimgt.gateway.handlers.security.oauth.OAuthAuthenticator", "", "", "", "java.lang.String"), 505);
    }
}

