/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.security.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.util.DateUtils;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import javax.cache.Cache;
import javax.security.cert.X509Certificate;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONObject;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTConfigurationDto;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTInfoDto;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo;
import org.wso2.carbon.apimgt.common.gateway.exception.JWTGeneratorException;
import org.wso2.carbon.apimgt.common.gateway.jwtgenerator.AbstractAPIMgtGatewayJWTGenerator;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.Utils;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIKeyValidator;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityConstants;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure19;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure21;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure23;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure25;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure27;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure29;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.jwt.RevokedJWTDataHolder;
import org.wso2.carbon.apimgt.gateway.utils.GatewayUtils;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.caching.CacheProvider;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;
import org.wso2.carbon.apimgt.impl.dto.ExtendedJWTConfigurationDto;
import org.wso2.carbon.apimgt.impl.jwt.JWTValidationService;
import org.wso2.carbon.apimgt.impl.jwt.SignedJWTInfo;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.utils.SigningUtil;
import org.wso2.carbon.apimgt.keymgt.service.TokenValidationContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;

public class JWTValidator {
    private static final Log log;
    private boolean isGatewayTokenCacheEnabled;
    private APIKeyValidator apiKeyValidator;
    private boolean jwtGenerationEnabled;
    private AbstractAPIMgtGatewayJWTGenerator apiMgtGatewayJWTGenerator;
    JWTConfigurationDto jwtConfigurationDto;
    JWTValidationService jwtValidationService;
    private static volatile long ttl;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;

    static {
        JWTValidator.ajc$preClinit();
        log = LogFactory.getLog(JWTValidator.class);
        ttl = -1L;
    }

    public JWTValidator(APIKeyValidator apiKeyValidator, String tenantDomain) throws APIManagementException {
        int tenantId = APIUtil.getTenantIdFromTenantDomain((String)tenantDomain);
        this.isGatewayTokenCacheEnabled = GatewayUtils.isGatewayTokenCacheEnabled();
        this.apiKeyValidator = apiKeyValidator;
        ExtendedJWTConfigurationDto extendedJWTConfigurationDto = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration().getJwtConfigurationDto();
        this.jwtConfigurationDto = new JWTConfigurationDto((JWTConfigurationDto)extendedJWTConfigurationDto);
        this.jwtGenerationEnabled = extendedJWTConfigurationDto.isEnabled();
        this.apiMgtGatewayJWTGenerator = ServiceReferenceHolder.getInstance().getApiMgtGatewayJWTGenerator().get(this.jwtConfigurationDto.getGatewayJWTGeneratorImpl());
        if (this.jwtGenerationEnabled) {
            if (extendedJWTConfigurationDto.isTenantBasedSigningEnabled()) {
                this.jwtConfigurationDto.setPublicCert(SigningUtil.getPublicCertificate((int)tenantId));
                this.jwtConfigurationDto.setPrivateKey(SigningUtil.getSigningKey((int)tenantId));
            } else {
                this.jwtConfigurationDto.setPublicCert(ServiceReferenceHolder.getInstance().getPublicCert());
                this.jwtConfigurationDto.setPrivateKey(ServiceReferenceHolder.getInstance().getPrivateKey());
            }
            this.jwtConfigurationDto.setTtl(this.getTtl());
            this.apiMgtGatewayJWTGenerator.setJWTConfigurationDto(this.jwtConfigurationDto);
        }
        this.jwtValidationService = ServiceReferenceHolder.getInstance().getJwtValidationService();
    }

    protected JWTValidator(String apiLevelPolicy, boolean isGatewayTokenCacheEnabled, APIKeyValidator apiKeyValidator, boolean jwtGenerationEnabled, AbstractAPIMgtGatewayJWTGenerator apiMgtGatewayJWTGenerator, JWTConfigurationDto jwtConfigurationDto, JWTValidationService jwtValidationService) {
        this.isGatewayTokenCacheEnabled = isGatewayTokenCacheEnabled;
        this.apiKeyValidator = apiKeyValidator;
        this.jwtGenerationEnabled = jwtGenerationEnabled;
        this.apiMgtGatewayJWTGenerator = apiMgtGatewayJWTGenerator;
        this.jwtConfigurationDto = jwtConfigurationDto;
        this.jwtValidationService = jwtValidationService;
    }

    @MethodStats
    public AuthenticationContext authenticate(SignedJWTInfo signedJWTInfo, org.apache.synapse.MessageContext synCtx) throws APISecurityException {
        SignedJWTInfo signedJWTInfo2 = signedJWTInfo;
        org.apache.synapse.MessageContext messageContext = synCtx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)signedJWTInfo2, (Object)messageContext);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, signedJWTInfo2, messageContext, joinPoint};
            return (AuthenticationContext)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.authenticate_aroundBody0(this, signedJWTInfo2, messageContext, joinPoint);
    }

    private long getTtl() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.longValue((Object)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return JWTValidator.getTtl_aroundBody2(this, joinPoint);
    }

    private String generateAndRetrieveJWTToken(String tokenSignature, JWTInfoDto jwtInfoDto) throws APISecurityException {
        String string = tokenSignature;
        JWTInfoDto jWTInfoDto = jwtInfoDto;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)jWTInfoDto);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, jWTInfoDto, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.generateAndRetrieveJWTToken_aroundBody4(this, string, jWTInfoDto, joinPoint);
    }

    private APIKeyValidationInfoDTO validateSubscriptionUsingKeyManager(org.apache.synapse.MessageContext synCtx, JWTValidationInfo jwtValidationInfo) throws APISecurityException {
        org.apache.synapse.MessageContext messageContext = synCtx;
        JWTValidationInfo jWTValidationInfo = jwtValidationInfo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)messageContext, (Object)jWTValidationInfo);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, messageContext, jWTValidationInfo, joinPoint};
            return (APIKeyValidationInfoDTO)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.validateSubscriptionUsingKeyManager_aroundBody6(this, messageContext, jWTValidationInfo, joinPoint);
    }

    private APIKeyValidationInfoDTO validateSubscriptionUsingKeyManager(String apiContext, String apiVersion, JWTValidationInfo jwtValidationInfo) throws APISecurityException {
        String string = apiContext;
        String string2 = apiVersion;
        JWTValidationInfo jWTValidationInfo = jwtValidationInfo;
        Object[] objectArray = new Object[]{string, string2, jWTValidationInfo};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, string, string2, jWTValidationInfo, joinPoint};
            return (APIKeyValidationInfoDTO)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.validateSubscriptionUsingKeyManager_aroundBody8(this, string, string2, jWTValidationInfo, joinPoint);
    }

    @MethodStats
    public AuthenticationContext authenticateForWebSocket(SignedJWTInfo signedJWTInfo, String apiContext, String apiVersion, String matchingResource) throws APISecurityException {
        SignedJWTInfo signedJWTInfo2 = signedJWTInfo;
        String string = apiContext;
        String string2 = apiVersion;
        String string3 = matchingResource;
        Object[] objectArray = new Object[]{signedJWTInfo2, string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, signedJWTInfo2, string, string2, string3, joinPoint};
            return (AuthenticationContext)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure11(objectArray2).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.authenticateForWebSocket_aroundBody10(this, signedJWTInfo2, string, string2, string3, joinPoint);
    }

    private void validateScopes(String apiContext, String apiVersion, String matchingResource, String httpMethod, JWTValidationInfo jwtValidationInfo, SignedJWTInfo jwtToken) throws APISecurityException {
        String string = apiContext;
        String string2 = apiVersion;
        String string3 = matchingResource;
        String string4 = httpMethod;
        JWTValidationInfo jWTValidationInfo = jwtValidationInfo;
        SignedJWTInfo signedJWTInfo = jwtToken;
        Object[] objectArray = new Object[]{string, string2, string3, string4, jWTValidationInfo, signedJWTInfo};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, string, string2, string3, string4, jWTValidationInfo, signedJWTInfo, joinPoint};
            MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure13(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        JWTValidator.validateScopes_aroundBody12(this, string, string2, string3, string4, jWTValidationInfo, signedJWTInfo, joinPoint);
    }

    private JWTValidationInfo checkTokenExpiration(String tokenIdentifier, JWTValidationInfo payload, String tenantDomain) throws APISecurityException {
        String string = tokenIdentifier;
        JWTValidationInfo jWTValidationInfo = payload;
        String string2 = tenantDomain;
        Object[] objectArray = new Object[]{string, jWTValidationInfo, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, string, jWTValidationInfo, string2, joinPoint};
            return (JWTValidationInfo)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure15(objectArray2).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.checkTokenExpiration_aroundBody14(this, string, jWTValidationInfo, string2, joinPoint);
    }

    protected long getTimeStampSkewInSeconds() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.longValue((Object)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return JWTValidator.getTimeStampSkewInSeconds_aroundBody16(this, joinPoint);
    }

    private JWTValidationInfo getJwtValidationInfo(SignedJWTInfo signedJWTInfo, String jti) throws APISecurityException {
        SignedJWTInfo signedJWTInfo2 = signedJWTInfo;
        String string = jti;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)signedJWTInfo2, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, signedJWTInfo2, string, joinPoint};
            return (JWTValidationInfo)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.getJwtValidationInfo_aroundBody18(this, signedJWTInfo2, string, joinPoint);
    }

    private String getJWTTokenIdentifier(SignedJWTInfo signedJWTInfo) {
        SignedJWTInfo signedJWTInfo2 = signedJWTInfo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)signedJWTInfo2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, signedJWTInfo2, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.getJWTTokenIdentifier_aroundBody20(this, signedJWTInfo2, joinPoint);
    }

    protected Cache getGatewayTokenCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.getGatewayTokenCache_aroundBody22(this, joinPoint);
    }

    protected Cache getInvalidTokenCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.getInvalidTokenCache_aroundBody24(this, joinPoint);
    }

    protected Cache getGatewayKeyCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure27(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.getGatewayKeyCache_aroundBody26(this, joinPoint);
    }

    protected Cache getGatewayJWTTokenCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new JWTValidator$AjcClosure29(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTValidator.getGatewayJWTTokenCache_aroundBody28(this, joinPoint);
    }

    static final /* synthetic */ AuthenticationContext authenticate_aroundBody0(JWTValidator ajc$this, SignedJWTInfo signedJWTInfo, org.apache.synapse.MessageContext synCtx, JoinPoint joinPoint) {
        String apiContext = (String)synCtx.getProperty("REST_API_CONTEXT");
        String apiVersion = (String)synCtx.getProperty("SYNAPSE_REST_API_VERSION");
        MessageContext axis2MsgContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String httpMethod = (String)axis2MsgContext.getProperty("HTTP_METHOD");
        String matchingResource = (String)synCtx.getProperty("API_ELECTED_RESOURCE");
        String jwtTokenIdentifier = ajc$this.getJWTTokenIdentifier(signedJWTInfo);
        String jwtHeader = signedJWTInfo.getSignedJWT().getHeader().toString();
        try {
            X509Certificate clientCertificate = Utils.getClientCertificate(axis2MsgContext);
            signedJWTInfo.setX509ClientCertificate(clientCertificate);
        }
        catch (APIManagementException aPIManagementException) {
            log.error((Object)("Error while obtaining client certificate. " + GatewayUtils.getMaskedToken(jwtHeader)));
        }
        if (StringUtils.isNotEmpty((String)jwtTokenIdentifier) && RevokedJWTDataHolder.isJWTTokenSignatureExistsInRevokedMap(jwtTokenIdentifier)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token retrieved from the revoked jwt token map. Token: " + GatewayUtils.getMaskedToken(jwtHeader)));
            }
            log.error((Object)("Invalid JWT token. " + GatewayUtils.getMaskedToken(jwtHeader)));
            throw new APISecurityException(900901, "Invalid JWT token");
        }
        JWTValidationInfo jwtValidationInfo = ajc$this.getJwtValidationInfo(signedJWTInfo, jwtTokenIdentifier);
        if (jwtValidationInfo != null) {
            if (jwtValidationInfo.isValid()) {
                log.debug((Object)("Begin subscription validation via Key Manager: " + jwtValidationInfo.getKeyManager()));
                APIKeyValidationInfoDTO apiKeyValidationInfoDTO = ajc$this.validateSubscriptionUsingKeyManager(synCtx, jwtValidationInfo);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Subscription validation via Key Manager. Status: " + apiKeyValidationInfoDTO.isAuthorized()));
                }
                if (!apiKeyValidationInfoDTO.isAuthorized()) {
                    log.debug((Object)"User is NOT authorized to access the Resource. API Subscription validation failed.");
                    throw new APISecurityException(apiKeyValidationInfoDTO.getValidationStatus(), "User is NOT authorized to access the Resource. API Subscription validation failed.");
                }
                ajc$this.validateScopes(apiContext, apiVersion, matchingResource, httpMethod, jwtValidationInfo, signedJWTInfo);
                synCtx.setProperty("Scopes", (Object)jwtValidationInfo.getScopes().toString());
                if (apiKeyValidationInfoDTO.isAuthorized()) {
                    synCtx.setProperty("api.ut.apiPublisher", (Object)apiKeyValidationInfoDTO.getApiPublisher());
                    synCtx.setProperty("API_NAME", (Object)apiKeyValidationInfoDTO.getApiName());
                    if ("GRAPHQL".equals(synCtx.getProperty("API_TYPE"))) {
                        synCtx.setProperty("max_query_depth", (Object)apiKeyValidationInfoDTO.getGraphQLMaxDepth());
                        synCtx.setProperty("max_query_complexity", (Object)apiKeyValidationInfoDTO.getGraphQLMaxComplexity());
                    }
                    log.debug((Object)"JWT authentication successful.");
                }
                log.debug((Object)"JWT authentication successful.");
                String endUserToken = null;
                if (ajc$this.jwtGenerationEnabled) {
                    JWTInfoDto jwtInfoDto = GatewayUtils.generateJWTInfoDto(null, jwtValidationInfo, apiKeyValidationInfoDTO, synCtx);
                    endUserToken = ajc$this.generateAndRetrieveJWTToken(jwtTokenIdentifier, jwtInfoDto);
                }
                return GatewayUtils.generateAuthenticationContext(jwtTokenIdentifier, jwtValidationInfo, apiKeyValidationInfoDTO, endUserToken, true);
            }
            throw new APISecurityException(jwtValidationInfo.getValidationCode(), APISecurityConstants.getAuthenticationFailureMessage(jwtValidationInfo.getValidationCode()));
        }
        throw new APISecurityException(900900, "Unclassified Authentication Failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ long getTtl_aroundBody2(JWTValidator ajc$this, JoinPoint joinPoint) {
        if (ttl != -1L) {
            return ttl;
        }
        Class<AbstractAPIMgtGatewayJWTGenerator> clazz = AbstractAPIMgtGatewayJWTGenerator.class;
        synchronized (AbstractAPIMgtGatewayJWTGenerator.class) {
            String ttlValue;
            String apimKeyCacheExpiry;
            if (ttl != -1L) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ttl;
            }
            APIManagerConfiguration config = org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
            String gwTokenCacheConfig = config.getFirstProperty("CacheConfigurations.EnableGatewayTokenCache");
            boolean isGWTokenCacheEnabled = Boolean.parseBoolean(gwTokenCacheConfig);
            ttl = isGWTokenCacheEnabled ? ((apimKeyCacheExpiry = config.getFirstProperty("CacheConfigurations.TokenCacheExpiry")) != null ? Long.parseLong(apimKeyCacheExpiry) : Long.valueOf(900L)) : ((ttlValue = config.getFirstProperty("APIKeyValidator.JWTExpiryTime")) != null ? Long.parseLong(ttlValue) : Long.valueOf(900L));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ttl;
        }
    }

    static final /* synthetic */ String generateAndRetrieveJWTToken_aroundBody4(JWTValidator ajc$this, String tokenSignature, JWTInfoDto jwtInfoDto, JoinPoint joinPoint) {
        String endUserToken = null;
        boolean valid = false;
        String jwtTokenCacheKey = jwtInfoDto.getApiContext().concat(":").concat(jwtInfoDto.getVersion()).concat(":").concat(tokenSignature);
        if (ajc$this.isGatewayTokenCacheEnabled) {
            Object token = ajc$this.getGatewayJWTTokenCache().get((Object)jwtTokenCacheKey);
            if (token != null) {
                endUserToken = (String)token;
                String[] splitToken = ((String)token).split("\\.");
                JSONObject payload = new JSONObject(new String(Base64.getUrlDecoder().decode(splitToken[1])));
                long exp = payload.getLong("exp") * 1000L;
                long timestampSkew = ajc$this.getTimeStampSkewInSeconds() * 1000L;
                boolean bl = valid = exp - System.currentTimeMillis() > timestampSkew;
            }
            if (StringUtils.isEmpty((String)endUserToken) || !valid) {
                try {
                    endUserToken = ajc$this.apiMgtGatewayJWTGenerator.generateToken(jwtInfoDto);
                    ajc$this.getGatewayJWTTokenCache().put((Object)jwtTokenCacheKey, (Object)endUserToken);
                }
                catch (JWTGeneratorException e) {
                    log.error((Object)"Error while Generating Backend JWT", (Throwable)e);
                    throw new APISecurityException(900900, "Unclassified Authentication Failure", e);
                }
            }
        } else {
            try {
                endUserToken = ajc$this.apiMgtGatewayJWTGenerator.generateToken(jwtInfoDto);
            }
            catch (JWTGeneratorException e) {
                log.error((Object)"Error while Generating Backend JWT", (Throwable)e);
                throw new APISecurityException(900900, "Unclassified Authentication Failure", e);
            }
        }
        return endUserToken;
    }

    static final /* synthetic */ APIKeyValidationInfoDTO validateSubscriptionUsingKeyManager_aroundBody6(JWTValidator ajc$this, org.apache.synapse.MessageContext synCtx, JWTValidationInfo jwtValidationInfo, JoinPoint joinPoint) {
        String apiContext = (String)synCtx.getProperty("REST_API_CONTEXT");
        String apiVersion = (String)synCtx.getProperty("SYNAPSE_REST_API_VERSION");
        return ajc$this.validateSubscriptionUsingKeyManager(apiContext, apiVersion, jwtValidationInfo);
    }

    static final /* synthetic */ APIKeyValidationInfoDTO validateSubscriptionUsingKeyManager_aroundBody8(JWTValidator ajc$this, String apiContext, String apiVersion, JWTValidationInfo jwtValidationInfo, JoinPoint joinPoint) {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String consumerKey = jwtValidationInfo.getConsumerKey();
        String keyManager = jwtValidationInfo.getKeyManager();
        if (consumerKey != null && keyManager != null) {
            return ajc$this.apiKeyValidator.validateSubscription(apiContext, apiVersion, consumerKey, tenantDomain, keyManager);
        }
        log.debug((Object)"Cannot call Key Manager to validate subscription. Payload of the token does not contain the Authorized party - the party to which the ID Token was issued");
        throw new APISecurityException(900908, "Resource forbidden ");
    }

    static final /* synthetic */ AuthenticationContext authenticateForWebSocket_aroundBody10(JWTValidator ajc$this, SignedJWTInfo signedJWTInfo, String apiContext, String apiVersion, String matchingResource, JoinPoint joinPoint) {
        String tokenSignature = signedJWTInfo.getSignedJWT().getSignature().toString();
        String jwtHeader = signedJWTInfo.getSignedJWT().getHeader().toString();
        JWTClaimsSet jwtClaimsSet = signedJWTInfo.getJwtClaimsSet();
        String jti = jwtClaimsSet.getJWTID();
        JWTValidationInfo jwtValidationInfo = ajc$this.getJwtValidationInfo(signedJWTInfo, jti);
        if (RevokedJWTDataHolder.isJWTTokenSignatureExistsInRevokedMap(tokenSignature)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token retrieved from the revoked jwt token map. Token: " + GatewayUtils.getMaskedToken(jwtHeader)));
            }
            log.error((Object)("Invalid JWT token. " + GatewayUtils.getMaskedToken(jwtHeader)));
            throw new APISecurityException(900901, "Invalid JWT token");
        }
        if (jwtValidationInfo != null && jwtValidationInfo.isValid()) {
            log.debug((Object)("Begin subscription validation via Key Manager: " + jwtValidationInfo.getKeyManager()));
            APIKeyValidationInfoDTO apiKeyValidationInfoDTO = ajc$this.validateSubscriptionUsingKeyManager(apiContext, apiVersion, jwtValidationInfo);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Subscription validation via Key Manager: " + jwtValidationInfo.getKeyManager() + ". Status: " + apiKeyValidationInfoDTO.isAuthorized()));
            }
            if (apiKeyValidationInfoDTO.isAuthorized()) {
                ajc$this.validateScopes(apiContext, apiVersion, matchingResource, "WS", jwtValidationInfo, signedJWTInfo);
                log.debug((Object)("JWT authentication successful. user: " + apiKeyValidationInfoDTO.getEndUserName()));
                String endUserToken = null;
                if (ajc$this.jwtGenerationEnabled) {
                    JWTInfoDto jwtInfoDto = GatewayUtils.generateJWTInfoDto(jwtValidationInfo, apiKeyValidationInfoDTO, apiContext, apiVersion);
                    endUserToken = ajc$this.generateAndRetrieveJWTToken(tokenSignature, jwtInfoDto);
                }
                AuthenticationContext context = GatewayUtils.generateAuthenticationContext(jti, jwtValidationInfo, apiKeyValidationInfoDTO, endUserToken, true);
                context.setApiVersion(apiVersion);
                return context;
            }
            String message = "User is NOT authorized to access the Resource. API Subscription validation failed.";
            log.debug((Object)message);
            throw new APISecurityException(apiKeyValidationInfoDTO.getValidationStatus(), message);
        }
        if (!jwtValidationInfo.isValid()) {
            throw new APISecurityException(900901, "Invalid JWT token");
        }
        throw new APISecurityException(900900, "Unclassified Authentication Failure");
    }

    static final /* synthetic */ void validateScopes_aroundBody12(JWTValidator ajc$this, String apiContext, String apiVersion, String matchingResource, String httpMethod, JWTValidationInfo jwtValidationInfo, SignedJWTInfo jwtToken, JoinPoint joinPoint) {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        TokenValidationContext tokenValidationContext = new TokenValidationContext();
        APIKeyValidationInfoDTO apiKeyValidationInfoDTO = new APIKeyValidationInfoDTO();
        HashSet scopeSet = new HashSet();
        scopeSet.addAll(jwtValidationInfo.getScopes());
        apiKeyValidationInfoDTO.setScopes(scopeSet);
        tokenValidationContext.setValidationInfoDTO(apiKeyValidationInfoDTO);
        tokenValidationContext.setAccessToken(jwtToken.getToken());
        tokenValidationContext.setHttpVerb(httpMethod);
        tokenValidationContext.setMatchingResource(matchingResource);
        tokenValidationContext.setContext(apiContext);
        tokenValidationContext.setVersion(apiVersion);
        boolean valid = ajc$this.apiKeyValidator.validateScopes(tokenValidationContext, tenantDomain);
        if (valid) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope validation successful for the resource: " + matchingResource + ", user: " + jwtValidationInfo.getUser()));
            }
        } else {
            String message = "User is NOT authorized to access the Resource: " + matchingResource + ". Scope validation failed.";
            log.debug((Object)message);
            throw new APISecurityException(900910, message);
        }
    }

    static final /* synthetic */ JWTValidationInfo checkTokenExpiration_aroundBody14(JWTValidator ajc$this, String tokenIdentifier, JWTValidationInfo payload, String tenantDomain, JoinPoint joinPoint) {
        long timestampSkew = ajc$this.getTimeStampSkewInSeconds();
        Date now = new Date();
        Date exp = new Date(payload.getExpiryTime());
        if (!DateUtils.isAfter((Date)exp, (Date)now, (long)timestampSkew)) {
            if (ajc$this.isGatewayTokenCacheEnabled) {
                ajc$this.getGatewayTokenCache().remove((Object)tokenIdentifier);
                ajc$this.getGatewayJWTTokenCache().remove((Object)tokenIdentifier);
                ajc$this.getInvalidTokenCache().put((Object)tokenIdentifier, (Object)tenantDomain);
            }
            payload.setValid(false);
            payload.setValidationCode(900901);
            return payload;
        }
        return payload;
    }

    static final /* synthetic */ long getTimeStampSkewInSeconds_aroundBody16(JWTValidator ajc$this, JoinPoint joinPoint) {
        return OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds();
    }

    static final /* synthetic */ JWTValidationInfo getJwtValidationInfo_aroundBody18(JWTValidator ajc$this, SignedJWTInfo signedJWTInfo, String jti, JoinPoint joinPoint) {
        String jwtHeader = signedJWTInfo.getSignedJWT().getHeader().toString();
        String tenantDomain = GatewayUtils.getTenantDomain();
        JWTValidationInfo jwtValidationInfo = null;
        if (ajc$this.isGatewayTokenCacheEnabled && !SignedJWTInfo.ValidationStatus.NOT_VALIDATED.equals((Object)signedJWTInfo.getValidationStatus())) {
            String cacheToken = (String)ajc$this.getGatewayTokenCache().get((Object)jti);
            if (SignedJWTInfo.ValidationStatus.VALID.equals((Object)signedJWTInfo.getValidationStatus()) && cacheToken != null) {
                if (ajc$this.getGatewayKeyCache().get((Object)jti) != null) {
                    JWTValidationInfo tempJWTValidationInfo = (JWTValidationInfo)ajc$this.getGatewayKeyCache().get((Object)jti);
                    ajc$this.checkTokenExpiration(jti, tempJWTValidationInfo, tenantDomain);
                    jwtValidationInfo = tempJWTValidationInfo;
                }
            } else if (SignedJWTInfo.ValidationStatus.INVALID.equals((Object)signedJWTInfo.getValidationStatus()) && ajc$this.getInvalidTokenCache().get((Object)jti) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Token retrieved from the invalid token cache. Token: " + GatewayUtils.getMaskedToken(jwtHeader)));
                }
                log.error((Object)("Invalid JWT token. " + GatewayUtils.getMaskedToken(jwtHeader)));
                jwtValidationInfo = new JWTValidationInfo();
                jwtValidationInfo.setValidationCode(900901);
                jwtValidationInfo.setValid(false);
            }
        }
        if (jwtValidationInfo == null) {
            try {
                jwtValidationInfo = ajc$this.jwtValidationService.validateJWTToken(signedJWTInfo);
                signedJWTInfo.setValidationStatus(jwtValidationInfo.isValid() ? SignedJWTInfo.ValidationStatus.VALID : SignedJWTInfo.ValidationStatus.INVALID);
                if (ajc$this.isGatewayTokenCacheEnabled) {
                    if (jwtValidationInfo.isValid()) {
                        ajc$this.getGatewayTokenCache().put((Object)jti, (Object)tenantDomain);
                        ajc$this.getGatewayKeyCache().put((Object)jti, (Object)jwtValidationInfo);
                    } else {
                        ajc$this.getInvalidTokenCache().put((Object)jti, (Object)tenantDomain);
                    }
                    if (!"carbon.super".equals(tenantDomain)) {
                        try {
                            PrivilegedCarbonContext.startTenantFlow();
                            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
                            if (jwtValidationInfo.isValid()) {
                                ajc$this.getGatewayTokenCache().put((Object)jti, (Object)tenantDomain);
                            } else {
                                ajc$this.getInvalidTokenCache().put((Object)jti, (Object)tenantDomain);
                            }
                        }
                        finally {
                            PrivilegedCarbonContext.endTenantFlow();
                        }
                    }
                }
                return jwtValidationInfo;
            }
            catch (APIManagementException aPIManagementException) {
                throw new APISecurityException(900900, "Unclassified Authentication Failure");
            }
        }
        return jwtValidationInfo;
    }

    static final /* synthetic */ String getJWTTokenIdentifier_aroundBody20(JWTValidator ajc$this, SignedJWTInfo signedJWTInfo, JoinPoint joinPoint) {
        JWTClaimsSet jwtClaimsSet = signedJWTInfo.getJwtClaimsSet();
        String jwtid = jwtClaimsSet.getJWTID();
        if (StringUtils.isNotEmpty((String)jwtid)) {
            return jwtid;
        }
        return signedJWTInfo.getSignedJWT().getSignature().toString();
    }

    static final /* synthetic */ Cache getGatewayTokenCache_aroundBody22(JWTValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayTokenCache();
    }

    static final /* synthetic */ Cache getInvalidTokenCache_aroundBody24(JWTValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getInvalidTokenCache();
    }

    static final /* synthetic */ Cache getGatewayKeyCache_aroundBody26(JWTValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayKeyCache();
    }

    static final /* synthetic */ Cache getGatewayJWTTokenCache_aroundBody28(JWTValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayJWTTokenCache();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JWTValidator.java", JWTValidator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "authenticate", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "org.wso2.carbon.apimgt.impl.jwt.SignedJWTInfo:org.apache.synapse.MessageContext", "signedJWTInfo:synCtx", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext"), 138);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTtl", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "", "", "", "long"), 231);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getJWTTokenIdentifier", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "org.wso2.carbon.apimgt.impl.jwt.SignedJWTInfo", "signedJWTInfo", "", "java.lang.String"), 562);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getGatewayTokenCache", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "", "", "", "javax.cache.Cache"), 571);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getInvalidTokenCache", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "", "", "", "javax.cache.Cache"), 576);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getGatewayKeyCache", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "", "", "", "javax.cache.Cache"), 581);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getGatewayJWTTokenCache", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "", "", "", "javax.cache.Cache"), 586);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "generateAndRetrieveJWTToken", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "java.lang.String:org.wso2.carbon.apimgt.common.gateway.dto.JWTInfoDto", "tokenSignature:jwtInfoDto", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "java.lang.String"), 266);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateSubscriptionUsingKeyManager", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "org.apache.synapse.MessageContext:org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo", "synCtx:jwtValidationInfo", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO"), 305);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateSubscriptionUsingKeyManager", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "java.lang.String:java.lang.String:org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo", "apiContext:apiVersion:jwtValidationInfo", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO"), 314);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "authenticateForWebSocket", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "org.wso2.carbon.apimgt.impl.jwt.SignedJWTInfo:java.lang.String:java.lang.String:java.lang.String", "signedJWTInfo:apiContext:apiVersion:matchingResource", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext"), 344);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateScopes", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo:org.wso2.carbon.apimgt.impl.jwt.SignedJWTInfo", "apiContext:apiVersion:matchingResource:httpMethod:jwtValidationInfo:jwtToken", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "void"), 417);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkTokenExpiration", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "java.lang.String:org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo:java.lang.String", "tokenIdentifier:payload:tenantDomain", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo"), 461);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getTimeStampSkewInSeconds", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "", "", "", "long"), 482);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getJwtValidationInfo", "org.wso2.carbon.apimgt.gateway.handlers.security.jwt.JWTValidator", "org.wso2.carbon.apimgt.impl.jwt.SignedJWTInfo:java.lang.String", "signedJWTInfo:jti", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo"), 487);
    }
}

