/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.security.basicauth;

import io.swagger.v3.oas.models.OpenAPI;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import javax.cache.Cache;
import javax.cache.Caching;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.security.APIKeyValidator;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure19;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.utils.OpenAPIUtils;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.caching.CacheProvider;
import org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto;
import org.wso2.carbon.apimgt.impl.dto.xsd.BasicAuthValidationInfoDTO;
import org.wso2.carbon.apimgt.impl.utils.GatewayUtils;
import org.wso2.carbon.apimgt.keymgt.stub.usermanager.APIKeyMgtRemoteUserStoreMgtServiceAPIManagementException;
import org.wso2.carbon.apimgt.keymgt.stub.usermanager.APIKeyMgtRemoteUserStoreMgtServiceStub;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.utils.CarbonUtils;

public class BasicAuthCredentialValidator {
    private boolean gatewayKeyCacheEnabled;
    protected Log log = LogFactory.getLog(this.getClass());
    private APIKeyMgtRemoteUserStoreMgtServiceStub apiKeyMgtRemoteUserStoreMgtServiceStub;
    private APIKeyValidator apiKeyValidator;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    public BasicAuthCredentialValidator() throws APISecurityException {
        this.gatewayKeyCacheEnabled = this.isGatewayTokenCacheEnabled();
        this.getGatewayUsernameCache();
        this.apiKeyValidator = new APIKeyValidator();
        ConfigurationContext configurationContext = ServiceReferenceHolder.getInstance().getAxis2ConfigurationContext();
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration();
        EventHubConfigurationDto eventHubConfigurationDto = config.getEventHubConfigurationDto();
        String username = eventHubConfigurationDto.getUsername();
        String password = eventHubConfigurationDto.getPassword();
        String url = eventHubConfigurationDto.getServiceUrl();
        if (url == null) {
            throw new APISecurityException(900900, "API key manager URL unspecified");
        }
        try {
            this.apiKeyMgtRemoteUserStoreMgtServiceStub = new APIKeyMgtRemoteUserStoreMgtServiceStub(configurationContext, String.valueOf(url) + "/services/APIKeyMgtRemoteUserStoreMgtService");
            ServiceClient client = this.apiKeyMgtRemoteUserStoreMgtServiceStub._getServiceClient();
            Options options = client.getOptions();
            options.setCallTransportCleanup(true);
            options.setManageSession(true);
            CarbonUtils.setBasicAccessSecurityHeaders((String)username, (String)password, (ServiceClient)client);
        }
        catch (AxisFault axisFault) {
            throw new APISecurityException(900900, axisFault.getMessage(), axisFault);
        }
    }

    @MethodStats
    public org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO validate(String username, String password) throws APISecurityException {
        String string = username;
        String string2 = password;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            return (org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.validate_aroundBody0(this, string, string2, joinPoint);
    }

    private org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO convertToDTO(BasicAuthValidationInfoDTO generatedDto) {
        BasicAuthValidationInfoDTO basicAuthValidationInfoDTO = generatedDto;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)basicAuthValidationInfoDTO);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, basicAuthValidationInfoDTO, joinPoint};
            return (org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.convertToDTO_aroundBody2(this, basicAuthValidationInfoDTO, joinPoint);
    }

    @MethodStats
    public boolean validateScopes(String username, OpenAPI openAPI, MessageContext synCtx, org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO basicAuthValidationInfoDTO) throws APISecurityException {
        String string = username;
        OpenAPI openAPI2 = openAPI;
        MessageContext messageContext = synCtx;
        org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO basicAuthValidationInfoDTO2 = basicAuthValidationInfoDTO;
        Object[] objectArray = new Object[]{string, openAPI2, messageContext, basicAuthValidationInfoDTO2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, string, openAPI2, messageContext, basicAuthValidationInfoDTO2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648)));
        }
        return BasicAuthCredentialValidator.validateScopes_aroundBody4(this, string, openAPI2, messageContext, basicAuthValidationInfoDTO2, joinPoint);
    }

    private boolean validateInternalUserRoles(List<String> resourceRoles, String[] userRoles) {
        List<String> list = resourceRoles;
        String[] stringArray = userRoles;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, list, (Object)stringArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, list, stringArray, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return BasicAuthCredentialValidator.validateInternalUserRoles_aroundBody6(this, list, stringArray, joinPoint);
    }

    private Cache getGatewayBasicAuthResourceCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.getGatewayBasicAuthResourceCache_aroundBody8(this, joinPoint);
    }

    private Cache getGatewayUsernameCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.getGatewayUsernameCache_aroundBody10(this, joinPoint);
    }

    private Cache getInvalidUsernameCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.getInvalidUsernameCache_aroundBody12(this, joinPoint);
    }

    private APIManagerConfiguration getApiManagerConfiguration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (APIManagerConfiguration)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.getApiManagerConfiguration_aroundBody14(this, joinPoint);
    }

    private Cache getCacheFromCacheManager(String cacheName) {
        String string = cacheName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BasicAuthCredentialValidator.getCacheFromCacheManager_aroundBody16(this, string, joinPoint);
    }

    private boolean isGatewayTokenCacheEnabled() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new BasicAuthCredentialValidator$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return BasicAuthCredentialValidator.isGatewayTokenCacheEnabled_aroundBody18(this, joinPoint);
    }

    static {
        BasicAuthCredentialValidator.ajc$preClinit();
    }

    static final /* synthetic */ org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO validate_aroundBody0(BasicAuthCredentialValidator ajc$this, String username, String password, JoinPoint joinPoint) {
        boolean isAuthenticated;
        org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO basicAuthValidationInfoDTO;
        String cachedPasswordHash = null;
        String providedPasswordHash = null;
        if (ajc$this.gatewayKeyCacheEnabled) {
            providedPasswordHash = GatewayUtils.hashString((byte[])password.getBytes(StandardCharsets.UTF_8));
            org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO cachedValidationInfoObj = (org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO)ajc$this.getGatewayUsernameCache().get((Object)username);
            if (cachedValidationInfoObj != null) {
                cachedPasswordHash = cachedValidationInfoObj.getHashedPassword();
                cachedValidationInfoObj.setCached(true);
            }
            if (cachedPasswordHash != null && cachedPasswordHash.equals(providedPasswordHash)) {
                ajc$this.log.debug((Object)"Basic Authentication: <Valid Username Cache> Username & password authenticated");
                return cachedValidationInfoObj;
            }
            org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO invalidCacheValidationInfoObj = (org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO)ajc$this.getInvalidUsernameCache().get((Object)username);
            if (invalidCacheValidationInfoObj != null) {
                invalidCacheValidationInfoObj.setCached(true);
                String invalidCachedPasswordHash = invalidCacheValidationInfoObj.getHashedPassword();
                if (invalidCachedPasswordHash != null && invalidCachedPasswordHash.equals(providedPasswordHash)) {
                    ajc$this.log.debug((Object)"Basic Authentication: <Invalid Username Cache> Username & password authentication failed");
                    invalidCacheValidationInfoObj.setAuthenticated(false);
                    return invalidCacheValidationInfoObj;
                }
            }
        }
        try {
            BasicAuthValidationInfoDTO generatedInfoDTO = ajc$this.apiKeyMgtRemoteUserStoreMgtServiceStub.getUserAuthenticationInfo(username, password);
            basicAuthValidationInfoDTO = ajc$this.convertToDTO(generatedInfoDTO);
            isAuthenticated = basicAuthValidationInfoDTO.isAuthenticated();
        }
        catch (RemoteException | APIKeyMgtRemoteUserStoreMgtServiceAPIManagementException e) {
            ajc$this.log.error((Object)("Basic Authentication: Error while accessing backend services to validate user authentication for user : " + username));
            throw new APISecurityException(900900, e.getMessage(), e);
        }
        if (ajc$this.gatewayKeyCacheEnabled) {
            basicAuthValidationInfoDTO.setHashedPassword(providedPasswordHash);
            if (isAuthenticated) {
                ajc$this.getGatewayUsernameCache().put((Object)username, (Object)basicAuthValidationInfoDTO);
            } else {
                ajc$this.getInvalidUsernameCache().put((Object)username, (Object)basicAuthValidationInfoDTO);
            }
        }
        return basicAuthValidationInfoDTO;
    }

    static final /* synthetic */ org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO convertToDTO_aroundBody2(BasicAuthCredentialValidator ajc$this, BasicAuthValidationInfoDTO generatedDto, JoinPoint joinPoint) {
        org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO dto = new org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO();
        dto.setAuthenticated(generatedDto.getAuthenticated());
        dto.setHashedPassword(generatedDto.getHashedPassword());
        dto.setDomainQualifiedUsername(generatedDto.getDomainQualifiedUsername());
        dto.setUserRoleList(generatedDto.getUserRoleList());
        return dto;
    }

    /*
     * Unable to fully structure code
     */
    static final /* synthetic */ boolean validateScopes_aroundBody4(BasicAuthCredentialValidator ajc$this, String username, OpenAPI openAPI, MessageContext synCtx, org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO basicAuthValidationInfoDTO, JoinPoint var5_5) {
        userRoleList = basicAuthValidationInfoDTO.getUserRoleList();
        apiContext = (String)synCtx.getProperty("REST_API_CONTEXT");
        apiVersion = (String)synCtx.getProperty("SYNAPSE_REST_API_VERSION");
        apiElectedResource = (String)synCtx.getProperty("API_ELECTED_RESOURCE");
        tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        httpMethod = (String)axis2MessageContext.getProperty("HTTP_METHOD");
        resourceKey = String.valueOf(apiContext) + ":" + apiVersion + ":" + apiElectedResource + ":" + httpMethod;
        scopeMap = ajc$this.apiKeyValidator.retrieveScopes(tenantDomain);
        resourceCacheKey = String.valueOf(resourceKey) + ":" + username;
        if (ajc$this.gatewayKeyCacheEnabled && ajc$this.getGatewayBasicAuthResourceCache().get((Object)resourceCacheKey) != null && basicAuthValidationInfoDTO.isCached()) {
            return true;
        }
        if (openAPI == null) ** GOTO lbl44
        resourceScopes = OpenAPIUtils.getScopesOfResource(openAPI, synCtx);
        if (resourceScopes != null && resourceScopes.size() > 0) {
            for (String resourceScope : resourceScopes) {
                scope = scopeMap.get(resourceScope);
                if (scope == null) continue;
                if (scope.getRoles().isEmpty()) {
                    ajc$this.log.debug((Object)("Scope " + resourceScope + " didn't have roles"));
                    if (ajc$this.gatewayKeyCacheEnabled) {
                        ajc$this.getGatewayBasicAuthResourceCache().put((Object)resourceCacheKey, (Object)resourceKey);
                    }
                    return true;
                }
                if (ajc$this.validateInternalUserRoles(scope.getRoles(), userRoleList)) {
                    if (ajc$this.gatewayKeyCacheEnabled) {
                        ajc$this.getGatewayBasicAuthResourceCache().put((Object)resourceCacheKey, (Object)resourceKey);
                    }
                    return true;
                }
                var34_22 = userRoleList;
                var36_24 = userRoleList.length;
                var38_26 = 0;
                while (var38_26 < var36_24) {
                    role = var34_22[var38_26];
                    if (scope.getRoles().contains(role)) {
                        if (ajc$this.gatewayKeyCacheEnabled) {
                            ajc$this.getGatewayBasicAuthResourceCache().put((Object)resourceCacheKey, (Object)resourceKey);
                        }
                        return true;
                    }
                    ++var38_26;
                }
            }
        } else {
            if (ajc$this.log.isDebugEnabled()) {
                ajc$this.log.debug((Object)"Basic Authentication: No scopes for the API resource: ".concat(resourceKey));
            }
            return true;
lbl44:
            // 1 sources

            if ("GRAPHQL".equals(synCtx.getProperty("API_TYPE"))) {
                operationScopeMappingList = (HashMap)synCtx.getProperty("WSO2ScopeOperationMapping");
                var38_27 = operationList = ((String)synCtx.getProperty("API_ELECTED_RESOURCE")).split(",");
                var40_29 = operationList.length;
                var32_21 = 0;
                while (var32_21 < var40_29) {
                    operation = var38_27[var32_21];
                    operationScope = (String)operationScopeMappingList.get(operation);
                    if (operationScope != null) {
                        if (scopeMap.containsKey(operationScope)) {
                            operationRoles = scopeMap.get(operationScope).getRoles();
                            userHasOperationRole = false;
                            if (operationRoles.isEmpty()) {
                                userHasOperationRole = true;
                            } else {
                                var44_33 = userRoleList;
                                var46_34 = userRoleList.length;
                                var48_35 = 0;
                                while (var48_35 < var46_34) {
                                    role = var44_33[var48_35];
                                    if (operationRoles.contains(role)) {
                                        userHasOperationRole = true;
                                        break;
                                    }
                                    ++var48_35;
                                }
                            }
                            if (!userHasOperationRole) {
                                throw new APISecurityException(900910, "Scope validation failed");
                            }
                        } else {
                            throw new APISecurityException(900900, "Unclassified Authentication Failure");
                        }
                    }
                    ++var32_21;
                }
                if (ajc$this.gatewayKeyCacheEnabled) {
                    ajc$this.getGatewayBasicAuthResourceCache().put((Object)resourceCacheKey, (Object)resourceKey);
                }
                return true;
            }
            if (ajc$this.log.isDebugEnabled()) {
                ajc$this.log.debug((Object)"Basic Authentication: No OpenAPI found in the gateway for the API: ".concat(apiContext).concat(":").concat(apiVersion));
            }
            return true;
        }
        if (ajc$this.log.isDebugEnabled()) {
            ajc$this.log.debug((Object)"Basic Authentication: Scope validation failed for the API resource: ".concat(apiElectedResource));
        }
        throw new APISecurityException(900910, "Scope validation failed");
    }

    static final /* synthetic */ boolean validateInternalUserRoles_aroundBody6(BasicAuthCredentialValidator ajc$this, List resourceRoles, String[] userRoles, JoinPoint joinPoint) {
        for (String role : resourceRoles) {
            String domain;
            int index;
            if (!role.contains(CarbonConstants.DOMAIN_SEPARATOR) || (index = role.indexOf(CarbonConstants.DOMAIN_SEPARATOR)) <= 0 || !"Internal".equalsIgnoreCase(domain = role.substring(0, index))) continue;
            String[] stringArray = userRoles;
            int n = userRoles.length;
            int n2 = 0;
            while (n2 < n) {
                String userRole = stringArray[n2];
                if (role.equalsIgnoreCase(userRole)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    static final /* synthetic */ Cache getGatewayBasicAuthResourceCache_aroundBody8(BasicAuthCredentialValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayBasicAuthResourceCache();
    }

    static final /* synthetic */ Cache getGatewayUsernameCache_aroundBody10(BasicAuthCredentialValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayUsernameCache();
    }

    static final /* synthetic */ Cache getInvalidUsernameCache_aroundBody12(BasicAuthCredentialValidator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getInvalidUsernameCache();
    }

    static final /* synthetic */ APIManagerConfiguration getApiManagerConfiguration_aroundBody14(BasicAuthCredentialValidator ajc$this, JoinPoint joinPoint) {
        return ServiceReferenceHolder.getInstance().getAPIManagerConfiguration();
    }

    static final /* synthetic */ Cache getCacheFromCacheManager_aroundBody16(BasicAuthCredentialValidator ajc$this, String cacheName, JoinPoint joinPoint) {
        return Caching.getCacheManager((String)"API_MANAGER_CACHE").getCache(cacheName);
    }

    static final /* synthetic */ boolean isGatewayTokenCacheEnabled_aroundBody18(BasicAuthCredentialValidator ajc$this, JoinPoint joinPoint) {
        try {
            APIManagerConfiguration config = ajc$this.getApiManagerConfiguration();
            String cacheEnabled = config.getFirstProperty("CacheConfigurations.EnableGatewayTokenCache");
            return Boolean.parseBoolean(cacheEnabled);
        }
        catch (Exception e) {
            ajc$this.log.error((Object)("Did not found valid API Validation Information cache configuration. Use default configuration " + e), (Throwable)e);
            return true;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BasicAuthCredentialValidator.java", BasicAuthCredentialValidator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validate", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "java.lang.String:java.lang.String", "username:password", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO"), 112);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "convertToDTO", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "org.wso2.carbon.apimgt.impl.dto.xsd.BasicAuthValidationInfoDTO", "generatedDto", "", "org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO"), 172);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validateScopes", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "java.lang.String:io.swagger.v3.oas.models.OpenAPI:org.apache.synapse.MessageContext:org.wso2.carbon.apimgt.impl.dto.BasicAuthValidationInfoDTO", "username:openAPI:synCtx:basicAuthValidationInfoDTO", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "boolean"), 193);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateInternalUserRoles", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "java.util.List:[Ljava.lang.String;", "resourceRoles:userRoles", "", "boolean"), 310);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getGatewayBasicAuthResourceCache", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "", "", "", "javax.cache.Cache"), 335);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getGatewayUsernameCache", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "", "", "", "javax.cache.Cache"), 342);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getInvalidUsernameCache", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "", "", "", "javax.cache.Cache"), 349);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getApiManagerConfiguration", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "", "", "", "org.wso2.carbon.apimgt.impl.APIManagerConfiguration"), 358);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getCacheFromCacheManager", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "java.lang.String", "cacheName", "", "javax.cache.Cache"), 368);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isGatewayTokenCacheEnabled", "org.wso2.carbon.apimgt.gateway.handlers.security.basicauth.BasicAuthCredentialValidator", "", "", "", "boolean"), 378);
    }
}

