/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.security.authenticator;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.swagger.v3.oas.models.OpenAPI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import javax.cache.Cache;
import net.minidev.json.JSONObject;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.dto.JWTTokenPayloadInfo;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityUtils;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationResponse;
import org.wso2.carbon.apimgt.gateway.handlers.security.Authenticator;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator$AjcClosure19;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.utils.GatewayUtils;
import org.wso2.carbon.apimgt.gateway.utils.OpenAPIUtils;
import org.wso2.carbon.apimgt.impl.caching.CacheProvider;
import org.wso2.carbon.apimgt.impl.dto.VerbInfoDTO;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.keymgt.model.entity.API;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class InternalAPIKeyAuthenticator
implements Authenticator {
    private static final Log log;
    private String securityParam;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        InternalAPIKeyAuthenticator.ajc$preClinit();
        log = LogFactory.getLog(InternalAPIKeyAuthenticator.class);
    }

    public InternalAPIKeyAuthenticator(String securityParam) {
        this.securityParam = securityParam;
    }

    @Override
    public void init(SynapseEnvironment env) {
        SynapseEnvironment synapseEnvironment = env;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)synapseEnvironment);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, synapseEnvironment, joinPoint};
            MethodTimeLogger.aspectOf().log(new InternalAPIKeyAuthenticator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        InternalAPIKeyAuthenticator.init_aroundBody0(this, synapseEnvironment, joinPoint);
    }

    @Override
    public void destroy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new InternalAPIKeyAuthenticator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        InternalAPIKeyAuthenticator.destroy_aroundBody2(this, joinPoint);
    }

    @Override
    public AuthenticationResponse authenticate(org.apache.synapse.MessageContext synCtx) {
        org.apache.synapse.MessageContext messageContext = synCtx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)messageContext);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return (AuthenticationResponse)MethodTimeLogger.aspectOf().log(new InternalAPIKeyAuthenticator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return InternalAPIKeyAuthenticator.authenticate_aroundBody4(this, messageContext, joinPoint);
    }

    private String extractInternalKey(org.apache.synapse.MessageContext mCtx) {
        org.apache.synapse.MessageContext messageContext = mCtx;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)messageContext);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, messageContext, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new InternalAPIKeyAuthenticator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return InternalAPIKeyAuthenticator.extractInternalKey_aroundBody6(this, messageContext, joinPoint);
    }

    private Cache getGatewayInternalKeyCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new InternalAPIKeyAuthenticator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return InternalAPIKeyAuthenticator.getGatewayInternalKeyCache_aroundBody8(this, joinPoint);
    }

    private Cache getInvalidGatewayInternalKeyCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new InternalAPIKeyAuthenticator$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }
        return InternalAPIKeyAuthenticator.getInvalidGatewayInternalKeyCache_aroundBody10(this, joinPoint);
    }

    private Cache getGatewayInternalKeyDataCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Cache)MethodTimeLogger.aspectOf().log(new InternalAPIKeyAuthenticator$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return InternalAPIKeyAuthenticator.getGatewayInternalKeyDataCache_aroundBody12(this, joinPoint);
    }

    @Override
    public String getChallengeString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new InternalAPIKeyAuthenticator$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return InternalAPIKeyAuthenticator.getChallengeString_aroundBody14(this, joinPoint);
    }

    @Override
    public String getRequestOrigin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new InternalAPIKeyAuthenticator$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
        }
        return InternalAPIKeyAuthenticator.getRequestOrigin_aroundBody16(this, joinPoint);
    }

    @Override
    public int getPriority() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.intValue((Object)MethodTimeLogger.aspectOf().log(new InternalAPIKeyAuthenticator$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return InternalAPIKeyAuthenticator.getPriority_aroundBody18(this, joinPoint);
    }

    static final /* synthetic */ void init_aroundBody0(InternalAPIKeyAuthenticator ajc$this, SynapseEnvironment env, JoinPoint joinPoint) {
    }

    static final /* synthetic */ void destroy_aroundBody2(InternalAPIKeyAuthenticator ajc$this, JoinPoint joinPoint) {
    }

    static final /* synthetic */ AuthenticationResponse authenticate_aroundBody4(InternalAPIKeyAuthenticator ajc$this, org.apache.synapse.MessageContext synCtx, JoinPoint joinPoint) {
        API retrievedApi = GatewayUtils.getAPI(synCtx);
        if (retrievedApi != null) {
            if (log.isDebugEnabled()) {
                log.info((Object)"Internal Key Authentication initialized");
            }
            try {
                String internalKey = ajc$this.extractInternalKey(synCtx);
                if (StringUtils.isEmpty((CharSequence)internalKey)) {
                    return new AuthenticationResponse(false, false, true, 900901, "Invalid Credentials");
                }
                OpenAPI openAPI = (OpenAPI)synCtx.getProperty("OPEN_API_OBJECT");
                if (openAPI == null && !"GRAPHQL".equals(synCtx.getProperty("API_TYPE"))) {
                    log.error((Object)"Swagger is missing in the gateway. Therefore, Internal Key authentication cannot be performed.");
                    return new AuthenticationResponse(false, true, false, 900911, "Internal Server Error");
                }
                JWTTokenPayloadInfo payloadInfo = null;
                String[] splitToken = internalKey.split("\\.");
                if (splitToken.length != 3) {
                    log.error((Object)"Internal Key does not have the format {header}.{payload}.{signature} ");
                    throw new APISecurityException(900901, "Invalid Credentials");
                }
                SignedJWT signedJWT = SignedJWT.parse((String)internalKey);
                JWTClaimsSet payload = signedJWT.getJWTClaimsSet();
                String tokenIdentifier = payload.getJWTID();
                JWSHeader jwsHeader = signedJWT.getHeader();
                String alias = jwsHeader != null && StringUtils.isNotEmpty((CharSequence)jwsHeader.getKeyID()) ? jwsHeader.getKeyID() : APIUtil.getInternalApiKeyAlias();
                if (!GatewayUtils.isInternalKey(payload)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Invalid Internal Key token type. Internal Key: " + GatewayUtils.getMaskedToken(splitToken[0])));
                    }
                    log.error((Object)"Invalid Internal Key token type.");
                    throw new APISecurityException(900901, "Invalid Credentials");
                }
                String apiContext = (String)synCtx.getProperty("REST_API_CONTEXT");
                String apiVersion = (String)synCtx.getProperty("SYNAPSE_REST_API_VERSION");
                String httpMethod = (String)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("HTTP_METHOD");
                String matchingResource = (String)synCtx.getProperty("API_ELECTED_RESOURCE");
                String resourceCacheKey = APIUtil.getResourceInfoDTOCacheKey((String)apiContext, (String)apiVersion, (String)matchingResource, (String)httpMethod);
                VerbInfoDTO verbInfoDTO = new VerbInfoDTO();
                verbInfoDTO.setHttpVerb(httpMethod);
                verbInfoDTO.setAuthType("None");
                verbInfoDTO.setRequestKey(resourceCacheKey);
                verbInfoDTO.setThrottling(OpenAPIUtils.getResourceThrottlingTier(openAPI, synCtx));
                ArrayList<VerbInfoDTO> verbInfoList = new ArrayList<VerbInfoDTO>();
                verbInfoList.add(verbInfoDTO);
                synCtx.setProperty("VERB_INFO", verbInfoList);
                String cacheKey = GatewayUtils.getAccessTokenCacheKey(tokenIdentifier, apiContext, apiVersion, matchingResource, httpMethod);
                String tenantDomain = GatewayUtils.getTenantDomain();
                boolean isVerified = false;
                String cacheToken = (String)ajc$this.getGatewayInternalKeyCache().get((Object)tokenIdentifier);
                if (cacheToken != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Internal Key retrieved from the Internal Key cache.");
                    }
                    if (ajc$this.getGatewayInternalKeyDataCache().get((Object)cacheKey) != null) {
                        payloadInfo = (JWTTokenPayloadInfo)ajc$this.getGatewayInternalKeyDataCache().get((Object)cacheKey);
                        String rawPayload = payloadInfo.getRawPayload();
                        isVerified = rawPayload.equals(splitToken[1]);
                    }
                } else if (ajc$this.getInvalidGatewayInternalKeyCache().get((Object)tokenIdentifier) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Internal Key retrieved from the invalid Internal Key cache. Internal Key: " + GatewayUtils.getMaskedToken(splitToken[0])));
                    }
                    log.error((Object)("Invalid Internal Key." + GatewayUtils.getMaskedToken(splitToken[0])));
                    throw new APISecurityException(900901, "Invalid Credentials");
                }
                if (!isVerified) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Internal Key not found in the cache.");
                    }
                    boolean bl = isVerified = GatewayUtils.verifyTokenSignature(signedJWT, alias) && !GatewayUtils.isJwtTokenExpired(payload);
                    if (isVerified) {
                        ajc$this.getGatewayInternalKeyCache().put((Object)tokenIdentifier, (Object)tenantDomain);
                    } else {
                        ajc$this.getInvalidGatewayInternalKeyCache().put((Object)tokenIdentifier, (Object)tenantDomain);
                    }
                    if (!"carbon.super".equals(tenantDomain)) {
                        try {
                            PrivilegedCarbonContext.startTenantFlow();
                            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super", true);
                            if (isVerified) {
                                ajc$this.getGatewayInternalKeyCache().put((Object)tokenIdentifier, (Object)tenantDomain);
                            }
                        }
                        finally {
                            PrivilegedCarbonContext.endTenantFlow();
                        }
                    }
                }
                if (isVerified) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Internal Key signature is verified.");
                    }
                    if (payloadInfo != null) {
                        payload = payloadInfo.getPayload();
                        if (GatewayUtils.isJwtTokenExpired(payload)) {
                            ajc$this.getGatewayInternalKeyCache().remove((Object)tokenIdentifier);
                            ajc$this.getInvalidGatewayInternalKeyCache().put((Object)tokenIdentifier, (Object)tenantDomain);
                            log.error((Object)"Internal Key is expired");
                            throw new APISecurityException(900901, "Invalid Credentials");
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"InternalKey payload not found in the cache.");
                        }
                        JWTTokenPayloadInfo jwtTokenPayloadInfo = new JWTTokenPayloadInfo();
                        jwtTokenPayloadInfo.setPayload(payload);
                        jwtTokenPayloadInfo.setRawPayload(splitToken[1]);
                        ajc$this.getGatewayInternalKeyDataCache().put((Object)cacheKey, (Object)jwtTokenPayloadInfo);
                    }
                    JSONObject api = GatewayUtils.validateAPISubscription(apiContext, apiVersion, payload, splitToken, false);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Internal Key authentication successful.");
                    }
                    AuthenticationContext authenticationContext = GatewayUtils.generateAuthenticationContext(tokenIdentifier, payload, api, retrievedApi.getApiTier());
                    APISecurityUtils.setAuthenticationContext(synCtx, authenticationContext);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"User is authorized to access the resource using Internal Key.");
                    }
                    return new AuthenticationResponse(true, true, false, 0, null);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Internal Key signature verification failure. Internal Key: " + GatewayUtils.getMaskedToken(splitToken[0])));
                }
                log.error((Object)"Invalid Internal Key. Signature verification failed.");
                throw new APISecurityException(900901, "Invalid Credentials");
            }
            catch (APISecurityException e) {
                return new AuthenticationResponse(false, true, false, e.getErrorCode(), e.getMessage());
            }
            catch (ParseException e) {
                log.error((Object)"Error while parsing Internal Key", (Throwable)e);
                return new AuthenticationResponse(false, true, false, 900900, "Unclassified Authentication Failure");
            }
        }
        return new AuthenticationResponse(false, true, false, 900900, "Unclassified Authentication Failure");
    }

    static final /* synthetic */ String extractInternalKey_aroundBody6(InternalAPIKeyAuthenticator ajc$this, org.apache.synapse.MessageContext mCtx, JoinPoint joinPoint) {
        String internalKey;
        MessageContext axis2MC = ((Axis2MessageContext)mCtx).getAxis2MessageContext();
        Map headers = (Map)axis2MC.getProperty("TRANSPORT_HEADERS");
        if (headers != null && (internalKey = (String)headers.get(ajc$this.securityParam)) != null) {
            headers.remove(ajc$this.securityParam);
            return internalKey.trim();
        }
        return null;
    }

    static final /* synthetic */ Cache getGatewayInternalKeyCache_aroundBody8(InternalAPIKeyAuthenticator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayInternalKeyCache();
    }

    static final /* synthetic */ Cache getInvalidGatewayInternalKeyCache_aroundBody10(InternalAPIKeyAuthenticator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getInvalidGatewayInternalKeyCache();
    }

    static final /* synthetic */ Cache getGatewayInternalKeyDataCache_aroundBody12(InternalAPIKeyAuthenticator ajc$this, JoinPoint joinPoint) {
        return CacheProvider.getGatewayInternalKeyDataCache();
    }

    static final /* synthetic */ String getChallengeString_aroundBody14(InternalAPIKeyAuthenticator ajc$this, JoinPoint joinPoint) {
        return null;
    }

    static final /* synthetic */ String getRequestOrigin_aroundBody16(InternalAPIKeyAuthenticator ajc$this, JoinPoint joinPoint) {
        return null;
    }

    static final /* synthetic */ int getPriority_aroundBody18(InternalAPIKeyAuthenticator ajc$this, JoinPoint joinPoint) {
        return -10;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("InternalAPIKeyAuthenticator.java", InternalAPIKeyAuthenticator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator", "org.apache.synapse.core.SynapseEnvironment", "env", "", "void"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator", "", "", "", "void"), 77);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "authenticate", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator", "org.apache.synapse.MessageContext", "synCtx", "", "org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationResponse"), 82);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractInternalKey", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator", "org.apache.synapse.MessageContext", "mCtx", "", "java.lang.String"), 273);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getGatewayInternalKeyCache", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator", "", "", "", "javax.cache.Cache"), 294);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getInvalidGatewayInternalKeyCache", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator", "", "", "", "javax.cache.Cache"), 299);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getGatewayInternalKeyDataCache", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator", "", "", "", "javax.cache.Cache"), 305);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getChallengeString", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator", "", "", "", "java.lang.String"), 312);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRequestOrigin", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator", "", "", "", "java.lang.String"), 318);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriority", "org.wso2.carbon.apimgt.gateway.handlers.security.authenticator.InternalAPIKeyAuthenticator", "", "", "", "int"), 324);
    }
}

