/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.handlers.graphQL;

import graphql.analysis.FieldComplexityCalculator;
import graphql.analysis.FieldComplexityEnvironment;
import graphql.language.Argument;
import graphql.language.IntValue;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.gateway.MethodStats;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.Utils;
import org.wso2.carbon.apimgt.gateway.handlers.graphQL.FieldComplexityCalculatorImpl$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.handlers.graphQL.FieldComplexityCalculatorImpl$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.handlers.graphQL.FieldComplexityCalculatorImpl$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.handlers.graphQL.FieldComplexityCalculatorImpl$AjcClosure7;

public class FieldComplexityCalculatorImpl
implements FieldComplexityCalculator {
    private static final Log log;
    JSONParser jsonParser = new JSONParser();
    JSONObject policyDefinition;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        FieldComplexityCalculatorImpl.ajc$preClinit();
        log = LogFactory.getLog(FieldComplexityCalculatorImpl.class);
    }

    public FieldComplexityCalculatorImpl(MessageContext messageContext) {
        try {
            String graphQLAccessControlPolicy = (String)messageContext.getProperty("WSO2GraphQLAccessControlPolicy");
            if (graphQLAccessControlPolicy == null) {
                this.policyDefinition = new JSONObject();
            } else {
                JSONObject jsonObject = (JSONObject)this.jsonParser.parse(graphQLAccessControlPolicy);
                this.policyDefinition = (JSONObject)jsonObject.get((Object)"complexity");
            }
        }
        catch (ParseException parseException) {
            String errorMessage = "Policy definition parsing failed. ";
            this.handleFailure(messageContext, errorMessage, errorMessage);
        }
    }

    public int calculate(FieldComplexityEnvironment fieldComplexityEnvironment, int childComplexity) {
        FieldComplexityEnvironment fieldComplexityEnvironment2 = fieldComplexityEnvironment;
        int n = childComplexity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)fieldComplexityEnvironment2, (Object)Conversions.intObject((int)n));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, fieldComplexityEnvironment2, Conversions.intObject((int)n), joinPoint};
            return Conversions.intValue((Object)MethodTimeLogger.aspectOf().log(new FieldComplexityCalculatorImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return FieldComplexityCalculatorImpl.calculate_aroundBody0(this, fieldComplexityEnvironment2, n, joinPoint);
    }

    private int getCustomComplexity(String fieldName, String parentType, JSONObject policyDefinition) {
        String string = fieldName;
        String string2 = parentType;
        JSONObject jSONObject = policyDefinition;
        Object[] objectArray = new Object[]{string, string2, jSONObject};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, string, string2, jSONObject, joinPoint};
            return Conversions.intValue((Object)MethodTimeLogger.aspectOf().log(new FieldComplexityCalculatorImpl$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648)));
        }
        return FieldComplexityCalculatorImpl.getCustomComplexity_aroundBody2(this, string, string2, jSONObject, joinPoint);
    }

    private int getArgumentsValue(List<Argument> argumentList) {
        List<Argument> list = argumentList;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, list);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, list, joinPoint};
            return Conversions.intValue((Object)MethodTimeLogger.aspectOf().log(new FieldComplexityCalculatorImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return FieldComplexityCalculatorImpl.getArgumentsValue_aroundBody4(this, list, joinPoint);
    }

    private void handleFailure(MessageContext messageContext, String errorMessage, String errorDescription) {
        MessageContext messageContext2 = messageContext;
        String string = errorMessage;
        String string2 = errorDescription;
        Object[] objectArray = new Object[]{messageContext2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, messageContext2, string, string2, joinPoint};
            MethodTimeLogger.aspectOf().log(new FieldComplexityCalculatorImpl$AjcClosure7(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        FieldComplexityCalculatorImpl.handleFailure_aroundBody6(this, messageContext2, string, string2, joinPoint);
    }

    static final /* synthetic */ int calculate_aroundBody0(FieldComplexityCalculatorImpl ajc$this, FieldComplexityEnvironment fieldComplexityEnvironment, int childComplexity, JoinPoint joinPoint) {
        String fieldName = fieldComplexityEnvironment.getField().getName();
        String parentType = fieldComplexityEnvironment.getParentType().getName();
        List ArgumentList = fieldComplexityEnvironment.getField().getArguments();
        int argumentsValue = ajc$this.getArgumentsValue(ArgumentList);
        int customFieldComplexity = ajc$this.getCustomComplexity(fieldName, parentType, ajc$this.policyDefinition);
        return argumentsValue * (customFieldComplexity + childComplexity);
    }

    static final /* synthetic */ int getCustomComplexity_aroundBody2(FieldComplexityCalculatorImpl ajc$this, String fieldName, String parentType, JSONObject policyDefinition, JoinPoint joinPoint) {
        JSONObject customComplexity = (JSONObject)policyDefinition.get((Object)parentType);
        if (customComplexity != null && customComplexity.get((Object)fieldName) != null) {
            return ((Long)customComplexity.get((Object)fieldName)).intValue();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No custom complexity value was assigned for " + fieldName + " under type " + parentType));
        }
        return 1;
    }

    static final /* synthetic */ int getArgumentsValue_aroundBody4(FieldComplexityCalculatorImpl ajc$this, List argumentList, JoinPoint joinPoint) {
        int argumentValue = 0;
        if (argumentList.size() > 0) {
            for (Argument object : argumentList) {
                String argumentName = object.getName();
                List<String> slicingArguments = Arrays.asList("first", "last", "limit");
                if (slicingArguments.contains(argumentName.toLowerCase())) {
                    BigInteger value = null;
                    if (object.getValue() instanceof IntValue) {
                        value = ((IntValue)object.getValue()).getValue();
                    }
                    int val = 0;
                    if (value != null) {
                        val = value.intValue();
                    }
                    argumentValue += val;
                    continue;
                }
                argumentValue = 1;
            }
        } else {
            argumentValue = 1;
        }
        return argumentValue;
    }

    static final /* synthetic */ void handleFailure_aroundBody6(FieldComplexityCalculatorImpl ajc$this, MessageContext messageContext, String errorMessage, String errorDescription, JoinPoint joinPoint) {
        messageContext.setProperty("ERROR_CODE", (Object)900422);
        messageContext.setProperty("ERROR_MESSAGE", (Object)errorMessage);
        messageContext.setProperty("ERROR_EXCEPTION", (Object)errorDescription);
        Mediator sequence = messageContext.getSequence("_graphql_failure_handler");
        if (sequence != null && !sequence.mediate(messageContext)) {
            return;
        }
        Utils.sendFault(messageContext, 400);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FieldComplexityCalculatorImpl.java", FieldComplexityCalculatorImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "calculate", "org.wso2.carbon.apimgt.gateway.handlers.graphQL.FieldComplexityCalculatorImpl", "graphql.analysis.FieldComplexityEnvironment:int", "fieldComplexityEnvironment:childComplexity", "", "int"), 54);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getCustomComplexity", "org.wso2.carbon.apimgt.gateway.handlers.graphQL.FieldComplexityCalculatorImpl", "java.lang.String:java.lang.String:org.json.simple.JSONObject", "fieldName:parentType:policyDefinition", "", "int"), 64);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getArgumentsValue", "org.wso2.carbon.apimgt.gateway.handlers.graphQL.FieldComplexityCalculatorImpl", "java.util.List", "argumentList", "", "int"), 77);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleFailure", "org.wso2.carbon.apimgt.gateway.handlers.graphQL.FieldComplexityCalculatorImpl", "org.apache.synapse.MessageContext:java.lang.String:java.lang.String", "messageContext:errorMessage:errorDescription", "", "void"), 111);
    }
}

