/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.dynamicconfigurations.DynamicProfileReloaderHolder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.gateway.GatewayAPIDTO;
import org.wso2.carbon.apimgt.api.gateway.GatewayContentDTO;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer$AjcClosure19;
import org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer$AjcClosure21;
import org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.internal.DataHolder;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.service.APIGatewayAdmin;
import org.wso2.carbon.apimgt.gateway.utils.GatewayUtils;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.dto.GatewayArtifactSynchronizerProperties;
import org.wso2.carbon.apimgt.impl.dto.GatewayCleanupSkipList;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.ArtifactRetriever;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException;
import org.wso2.carbon.apimgt.impl.notifier.events.APIEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.DeployAPIInGatewayEvent;
import org.wso2.carbon.apimgt.keymgt.SubscriptionDataHolder;
import org.wso2.carbon.apimgt.keymgt.model.SubscriptionDataStore;
import org.wso2.carbon.apimgt.keymgt.model.entity.API;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class InMemoryAPIDeployer {
    private static Log log;
    ArtifactRetriever artifactRetriever;
    GatewayArtifactSynchronizerProperties gatewayArtifactSynchronizerProperties;
    private boolean debugEnabled = log.isDebugEnabled();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    static {
        InMemoryAPIDeployer.ajc$preClinit();
        log = LogFactory.getLog(InMemoryAPIDeployer.class);
    }

    public InMemoryAPIDeployer() {
        this.artifactRetriever = ServiceReferenceHolder.getInstance().getArtifactRetriever();
        this.gatewayArtifactSynchronizerProperties = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration().getGatewayArtifactSynchronizerProperties();
    }

    public boolean deployAPI(DeployAPIInGatewayEvent gatewayEvent) throws ArtifactSynchronizerException {
        DeployAPIInGatewayEvent deployAPIInGatewayEvent = gatewayEvent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)deployAPIInGatewayEvent);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, deployAPIInGatewayEvent, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new InMemoryAPIDeployer$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return InMemoryAPIDeployer.deployAPI_aroundBody0(this, deployAPIInGatewayEvent, joinPoint);
    }

    private GatewayAPIDTO retrieveArtifact(String apiId, Set<String> gatewayLabels) throws ArtifactSynchronizerException {
        String string = apiId;
        Set<String> set = gatewayLabels;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, set);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, set, joinPoint};
            return (GatewayAPIDTO)MethodTimeLogger.aspectOf().log(new InMemoryAPIDeployer$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return InMemoryAPIDeployer.retrieveArtifact_aroundBody2(this, string, set, joinPoint);
    }

    public boolean deployAllAPIsAtGatewayStartup(Set<String> assignedGatewayLabels, String tenantDomain) throws ArtifactSynchronizerException {
        Set<String> set = assignedGatewayLabels;
        String string = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, set, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, set, string, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new InMemoryAPIDeployer$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return InMemoryAPIDeployer.deployAllAPIsAtGatewayStartup_aroundBody4(this, set, string, joinPoint);
    }

    private void unDeployAPI(APIGatewayAdmin apiGatewayAdmin, DeployAPIInGatewayEvent gatewayEvent) throws AxisFault {
        APIGatewayAdmin aPIGatewayAdmin = apiGatewayAdmin;
        DeployAPIInGatewayEvent deployAPIInGatewayEvent = gatewayEvent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)((Object)aPIGatewayAdmin), (Object)deployAPIInGatewayEvent);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, aPIGatewayAdmin, deployAPIInGatewayEvent, joinPoint};
            MethodTimeLogger.aspectOf().log(new InMemoryAPIDeployer$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        InMemoryAPIDeployer.unDeployAPI_aroundBody6(this, aPIGatewayAdmin, deployAPIInGatewayEvent, joinPoint);
    }

    public void unDeployAPI(DeployAPIInGatewayEvent gatewayEvent) throws ArtifactSynchronizerException {
        DeployAPIInGatewayEvent deployAPIInGatewayEvent = gatewayEvent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)deployAPIInGatewayEvent);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, deployAPIInGatewayEvent, joinPoint};
            MethodTimeLogger.aspectOf().log(new InMemoryAPIDeployer$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        InMemoryAPIDeployer.unDeployAPI_aroundBody8(this, deployAPIInGatewayEvent, joinPoint);
    }

    public void cleanDeployment(String artifactRepositoryPath) {
        String string = artifactRepositoryPath;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new InMemoryAPIDeployer$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        InMemoryAPIDeployer.cleanDeployment_aroundBody10(this, string, joinPoint);
    }

    private void clean(File artifactRepoPath, Set<String> skippedList) {
        File file = artifactRepoPath;
        Set<String> set = skippedList;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)file, set);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, file, set, joinPoint};
            MethodTimeLogger.aspectOf().log(new InMemoryAPIDeployer$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        InMemoryAPIDeployer.clean_aroundBody12(this, file, set, joinPoint);
    }

    private void addDeployedCertificatesToAPIAssociation(GatewayAPIDTO gatewayAPIDTO) {
        GatewayAPIDTO gatewayAPIDTO2 = gatewayAPIDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)gatewayAPIDTO2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, gatewayAPIDTO2, joinPoint};
            MethodTimeLogger.aspectOf().log(new InMemoryAPIDeployer$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        InMemoryAPIDeployer.addDeployedCertificatesToAPIAssociation_aroundBody14(this, gatewayAPIDTO2, joinPoint);
    }

    private void setClientCertificatesToRemoveIntoGatewayDTO(GatewayAPIDTO gatewayDTO) {
        GatewayAPIDTO gatewayAPIDTO = gatewayDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)gatewayAPIDTO);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, gatewayAPIDTO, joinPoint};
            MethodTimeLogger.aspectOf().log(new InMemoryAPIDeployer$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        InMemoryAPIDeployer.setClientCertificatesToRemoveIntoGatewayDTO_aroundBody16(this, gatewayAPIDTO, joinPoint);
    }

    public void reDeployAPI(String apiName, String version, String tenantDomain) throws ArtifactSynchronizerException {
        String string = apiName;
        String string2 = version;
        String string3 = tenantDomain;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
            MethodTimeLogger.aspectOf().log(new InMemoryAPIDeployer$AjcClosure19(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        InMemoryAPIDeployer.reDeployAPI_aroundBody18(this, string, string2, string3, joinPoint);
    }

    public void unDeployAPI(String apiName, String version, String tenantDomain) throws ArtifactSynchronizerException {
        String string = apiName;
        String string2 = version;
        String string3 = tenantDomain;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
            MethodTimeLogger.aspectOf().log(new InMemoryAPIDeployer$AjcClosure21(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        InMemoryAPIDeployer.unDeployAPI_aroundBody20(this, string, string2, string3, joinPoint);
    }

    static final /* synthetic */ boolean deployAPI_aroundBody0(InMemoryAPIDeployer ajc$this, DeployAPIInGatewayEvent gatewayEvent, JoinPoint joinPoint) {
        String apiId = gatewayEvent.getUuid();
        Set gatewayLabels = gatewayEvent.getGatewayLabels();
        try {
            GatewayAPIDTO gatewayAPIDTO = ajc$this.retrieveArtifact(apiId, gatewayLabels);
            if (gatewayAPIDTO != null) {
                APIGatewayAdmin apiGatewayAdmin = new APIGatewayAdmin();
                MessageContext.setCurrentMessageContext((MessageContext)GatewayUtils.createAxis2MessageContext());
                ajc$this.unDeployAPI(apiGatewayAdmin, gatewayEvent);
                apiGatewayAdmin.deployAPI(gatewayAPIDTO);
                ajc$this.addDeployedCertificatesToAPIAssociation(gatewayAPIDTO);
                if (ajc$this.debugEnabled) {
                    log.debug((Object)("API with " + apiId + " is deployed in gateway with the labels " + String.join((CharSequence)",", gatewayLabels)));
                }
                return true;
            }
        }
        catch (IOException | ArtifactSynchronizerException e) {
            String msg = "Error deploying " + apiId + " in Gateway";
            log.error((Object)msg, e);
            throw new ArtifactSynchronizerException(msg, e);
        }
        finally {
            MessageContext.destroyCurrentMessageContext();
        }
        return true;
    }

    static final /* synthetic */ GatewayAPIDTO retrieveArtifact_aroundBody2(InMemoryAPIDeployer ajc$this, String apiId, Set gatewayLabels, JoinPoint joinPoint) {
        GatewayAPIDTO result;
        String labelString = String.join((CharSequence)"|", gatewayLabels);
        String encodedString = Base64.encodeBase64URLSafeString((byte[])labelString.getBytes());
        if (ajc$this.artifactRetriever != null) {
            try {
                String gatewayRuntimeArtifact = ajc$this.artifactRetriever.retrieveArtifact(apiId, encodedString);
                if (!StringUtils.isNotEmpty((CharSequence)gatewayRuntimeArtifact)) {
                    String msg = "Error retrieving artifacts for API " + apiId + ". Storage returned null";
                    log.error((Object)msg);
                    throw new ArtifactSynchronizerException(msg);
                }
                result = (GatewayAPIDTO)new Gson().fromJson(gatewayRuntimeArtifact, GatewayAPIDTO.class);
            }
            catch (ArtifactSynchronizerException e) {
                String msg = "Error deploying " + apiId + " in Gateway";
                log.error((Object)msg, (Throwable)e);
                throw new ArtifactSynchronizerException(msg, (Throwable)e);
            }
        } else {
            String msg = "Artifact retriever not found";
            log.error((Object)msg);
            throw new ArtifactSynchronizerException(msg);
        }
        return result;
    }

    static final /* synthetic */ boolean deployAllAPIsAtGatewayStartup_aroundBody4(InMemoryAPIDeployer ajc$this, Set assignedGatewayLabels, String tenantDomain, JoinPoint joinPoint) {
        boolean result;
        block11: {
            result = false;
            if (ajc$this.gatewayArtifactSynchronizerProperties.isRetrieveFromStorageEnabled()) {
                if (ajc$this.artifactRetriever != null) {
                    try {
                        try {
                            String labelString = String.join((CharSequence)"|", assignedGatewayLabels);
                            String encodedString = Base64.encodeBase64URLSafeString((byte[])labelString.getBytes());
                            APIGatewayAdmin apiGatewayAdmin = new APIGatewayAdmin();
                            MessageContext.setCurrentMessageContext((MessageContext)GatewayUtils.createAxis2MessageContext());
                            PrivilegedCarbonContext.startTenantFlow();
                            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
                            List gatewayRuntimeArtifacts = ServiceReferenceHolder.getInstance().getArtifactRetriever().retrieveAllArtifacts(encodedString, tenantDomain);
                            for (String runtimeArtifact : gatewayRuntimeArtifacts) {
                                GatewayAPIDTO gatewayAPIDTO = null;
                                try {
                                    if (!StringUtils.isNotEmpty((CharSequence)runtimeArtifact)) continue;
                                    gatewayAPIDTO = (GatewayAPIDTO)new Gson().fromJson(runtimeArtifact, GatewayAPIDTO.class);
                                    log.info((Object)("Deploying synapse artifacts of " + gatewayAPIDTO.getName()));
                                    apiGatewayAdmin.deployAPI(gatewayAPIDTO);
                                    ajc$this.addDeployedCertificatesToAPIAssociation(gatewayAPIDTO);
                                }
                                catch (AxisFault axisFault) {
                                    log.error((Object)("Error in deploying " + gatewayAPIDTO.getName() + " to the Gateway "), (Throwable)axisFault);
                                }
                            }
                            DynamicProfileReloaderHolder.getInstance().reloadAllHandlers();
                            if (ajc$this.debugEnabled) {
                                log.debug((Object)("APIs deployed in gateway with the labels of " + labelString));
                            }
                            result = true;
                            break block11;
                        }
                        catch (AxisFault | ArtifactSynchronizerException e) {
                            String msg = "Error  deploying APIs to the Gateway ";
                            log.error((Object)msg, e);
                            throw new ArtifactSynchronizerException(msg, e);
                        }
                    }
                    finally {
                        MessageContext.destroyCurrentMessageContext();
                        PrivilegedCarbonContext.endTenantFlow();
                    }
                }
                String msg = "Artifact retriever not found";
                log.error((Object)msg);
                throw new ArtifactSynchronizerException(msg);
            }
        }
        return result;
    }

    static final /* synthetic */ void unDeployAPI_aroundBody6(InMemoryAPIDeployer ajc$this, APIGatewayAdmin apiGatewayAdmin, DeployAPIInGatewayEvent gatewayEvent, JoinPoint joinPoint) {
        if (ajc$this.gatewayArtifactSynchronizerProperties.isRetrieveFromStorageEnabled()) {
            GatewayAPIDTO gatewayAPIDTO = new GatewayAPIDTO();
            gatewayAPIDTO.setName(gatewayEvent.getName());
            gatewayAPIDTO.setVersion(gatewayEvent.getVersion());
            gatewayAPIDTO.setProvider(gatewayEvent.getProvider());
            gatewayAPIDTO.setTenantDomain(gatewayEvent.getTenantDomain());
            gatewayAPIDTO.setApiId(gatewayEvent.getUuid());
            ajc$this.setClientCertificatesToRemoveIntoGatewayDTO(gatewayAPIDTO);
            if ("APIProduct".equals(gatewayEvent.getApiType())) {
                APIProductIdentifier apiProductIdentifier = new APIProductIdentifier(gatewayEvent.getProvider(), gatewayEvent.getName(), gatewayEvent.getVersion());
                Set associatedApis = gatewayEvent.getAssociatedApis();
                for (APIEvent associatedApi : associatedApis) {
                    org.wso2.carbon.apimgt.impl.utils.GatewayUtils.setCustomSequencesToBeRemoved((APIProductIdentifier)apiProductIdentifier, (String)associatedApi.getUuid(), (GatewayAPIDTO)gatewayAPIDTO);
                    org.wso2.carbon.apimgt.impl.utils.GatewayUtils.setEndpointsToBeRemoved((APIProductIdentifier)apiProductIdentifier, (String)associatedApi.getUuid(), (GatewayAPIDTO)gatewayAPIDTO);
                }
            } else {
                org.wso2.carbon.apimgt.api.model.API api = new org.wso2.carbon.apimgt.api.model.API(new APIIdentifier(gatewayEvent.getProvider(), gatewayEvent.getName(), gatewayEvent.getVersion()));
                if (APIConstants.APITransportType.GRAPHQL.toString().equalsIgnoreCase(gatewayEvent.getApiType())) {
                    gatewayAPIDTO.setLocalEntriesToBeRemove(org.wso2.carbon.apimgt.impl.utils.GatewayUtils.addStringToList((String)gatewayEvent.getUuid().concat("_graphQL"), (String[])gatewayAPIDTO.getLocalEntriesToBeRemove()));
                }
                if (APIConstants.APITransportType.WS.toString().equalsIgnoreCase(gatewayEvent.getApiType())) {
                    GatewayUtils.setWebsocketEndpointsToBeRemoved(gatewayAPIDTO, gatewayEvent.getTenantDomain());
                } else {
                    org.wso2.carbon.apimgt.impl.utils.GatewayUtils.setEndpointsToBeRemoved((String)gatewayAPIDTO.getName(), (String)gatewayAPIDTO.getVersion(), (GatewayAPIDTO)gatewayAPIDTO);
                }
                org.wso2.carbon.apimgt.impl.utils.GatewayUtils.setCustomSequencesToBeRemoved((org.wso2.carbon.apimgt.api.model.API)api, (GatewayAPIDTO)gatewayAPIDTO);
            }
            gatewayAPIDTO.setLocalEntriesToBeRemove(org.wso2.carbon.apimgt.impl.utils.GatewayUtils.addStringToList((String)gatewayEvent.getUuid(), (String[])gatewayAPIDTO.getLocalEntriesToBeRemove()));
            apiGatewayAdmin.unDeployAPI(gatewayAPIDTO);
            DataHolder.getInstance().getApiToCertificatesMap().remove(gatewayEvent.getUuid());
        }
    }

    static final /* synthetic */ void unDeployAPI_aroundBody8(InMemoryAPIDeployer ajc$this, DeployAPIInGatewayEvent gatewayEvent, JoinPoint joinPoint) {
        try {
            try {
                APIGatewayAdmin apiGatewayAdmin = new APIGatewayAdmin();
                MessageContext.setCurrentMessageContext((MessageContext)GatewayUtils.createAxis2MessageContext());
                ajc$this.unDeployAPI(apiGatewayAdmin, gatewayEvent);
            }
            catch (AxisFault axisFault) {
                throw new ArtifactSynchronizerException("Error while unDeploying api ", (Throwable)axisFault);
            }
        }
        finally {
            MessageContext.destroyCurrentMessageContext();
        }
    }

    static final /* synthetic */ void cleanDeployment_aroundBody10(InMemoryAPIDeployer ajc$this, String artifactRepositoryPath, JoinPoint joinPoint) {
        File artifactRepoPath = Paths.get(artifactRepositoryPath, "synapse-configs", "default").toFile();
        if (artifactRepoPath.exists() && artifactRepoPath.isDirectory()) {
            File sequencesPath;
            File endpointPath;
            File localEntryPath;
            GatewayCleanupSkipList gatewayCleanupSkipList = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration().getGatewayCleanupSkipList();
            File apiPath = Paths.get(artifactRepoPath.getAbsolutePath(), "api").toFile();
            if (apiPath.exists() && apiPath.isDirectory()) {
                ajc$this.clean(apiPath, gatewayCleanupSkipList.getApis());
            }
            if ((localEntryPath = Paths.get(artifactRepoPath.getAbsolutePath(), "local-entries").toFile()).exists() && localEntryPath.isDirectory()) {
                ajc$this.clean(localEntryPath, gatewayCleanupSkipList.getLocalEntries());
            }
            if ((endpointPath = Paths.get(artifactRepoPath.getAbsolutePath(), "endpoints").toFile()).exists() && endpointPath.isDirectory()) {
                ajc$this.clean(endpointPath, gatewayCleanupSkipList.getEndpoints());
            }
            if ((sequencesPath = Paths.get(artifactRepoPath.getAbsolutePath(), "sequences").toFile()).exists() && sequencesPath.isDirectory()) {
                ajc$this.clean(sequencesPath, gatewayCleanupSkipList.getSequences());
            }
        }
    }

    static final /* synthetic */ void clean_aroundBody12(InMemoryAPIDeployer ajc$this, File artifactRepoPath, Set skippedList, JoinPoint joinPoint) {
        if (artifactRepoPath != null && artifactRepoPath.isDirectory()) {
            File[] fileArray = Objects.requireNonNull(artifactRepoPath.listFiles());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!skippedList.contains(file.getName())) {
                    file.delete();
                }
                ++n2;
            }
        }
    }

    static final /* synthetic */ void addDeployedCertificatesToAPIAssociation_aroundBody14(InMemoryAPIDeployer ajc$this, GatewayAPIDTO gatewayAPIDTO, JoinPoint joinPoint) {
        if (gatewayAPIDTO != null) {
            String apiId = gatewayAPIDTO.getApiId();
            ArrayList<String> aliasList = new ArrayList<String>();
            if (gatewayAPIDTO.getClientCertificatesToBeAdd() != null) {
                GatewayContentDTO[] gatewayContentDTOArray = gatewayAPIDTO.getClientCertificatesToBeAdd();
                int n = gatewayContentDTOArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GatewayContentDTO gatewayContentDTO = gatewayContentDTOArray[n2];
                    aliasList.add(gatewayContentDTO.getName());
                    ++n2;
                }
            }
            DataHolder.getInstance().addApiToAliasList(apiId, aliasList);
        }
    }

    static final /* synthetic */ void setClientCertificatesToRemoveIntoGatewayDTO_aroundBody16(InMemoryAPIDeployer ajc$this, GatewayAPIDTO gatewayDTO, JoinPoint joinPoint) {
        if (gatewayDTO != null && StringUtils.isNotEmpty((CharSequence)gatewayDTO.getApiId())) {
            List<String> certificateAliasListForAPI = DataHolder.getInstance().getCertificateAliasListForAPI(gatewayDTO.getApiId());
            gatewayDTO.setClientCertificatesToBeRemove(certificateAliasListForAPI.toArray(new String[0]));
        }
    }

    static final /* synthetic */ void reDeployAPI_aroundBody18(InMemoryAPIDeployer ajc$this, String apiName, String version, String tenantDomain, JoinPoint joinPoint) {
        API retrievedAPI;
        SubscriptionDataStore tenantSubscriptionStore = SubscriptionDataHolder.getInstance().getTenantSubscriptionStore(tenantDomain);
        Set gatewayLabels = ajc$this.gatewayArtifactSynchronizerProperties.getGatewayLabels();
        if (tenantSubscriptionStore != null && (retrievedAPI = tenantSubscriptionStore.getApiByNameAndVersion(apiName, version)) != null) {
            DeployAPIInGatewayEvent deployAPIInGatewayEvent = new DeployAPIInGatewayEvent(UUID.randomUUID().toString(), System.currentTimeMillis(), APIConstants.EventType.REMOVE_API_FROM_GATEWAY.name(), tenantDomain, retrievedAPI.getApiId(), retrievedAPI.getUuid(), gatewayLabels, apiName, version, retrievedAPI.getApiProvider(), retrievedAPI.getApiType(), retrievedAPI.getContext());
            ajc$this.deployAPI(deployAPIInGatewayEvent);
        }
    }

    static final /* synthetic */ void unDeployAPI_aroundBody20(InMemoryAPIDeployer ajc$this, String apiName, String version, String tenantDomain, JoinPoint joinPoint) {
        API retrievedAPI;
        SubscriptionDataStore tenantSubscriptionStore = SubscriptionDataHolder.getInstance().getTenantSubscriptionStore(tenantDomain);
        Set gatewayLabels = ajc$this.gatewayArtifactSynchronizerProperties.getGatewayLabels();
        if (tenantSubscriptionStore != null && (retrievedAPI = tenantSubscriptionStore.getApiByNameAndVersion(apiName, version)) != null) {
            DeployAPIInGatewayEvent deployAPIInGatewayEvent = new DeployAPIInGatewayEvent(UUID.randomUUID().toString(), System.currentTimeMillis(), APIConstants.EventType.REMOVE_API_FROM_GATEWAY.name(), tenantDomain, retrievedAPI.getApiId(), retrievedAPI.getUuid(), gatewayLabels, apiName, version, retrievedAPI.getApiProvider(), retrievedAPI.getApiType(), retrievedAPI.getContext());
            ajc$this.unDeployAPI(deployAPIInGatewayEvent);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("InMemoryAPIDeployer.java", InMemoryAPIDeployer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deployAPI", "org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer", "org.wso2.carbon.apimgt.impl.notifier.events.DeployAPIInGatewayEvent", "gatewayEvent", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException", "boolean"), 82);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "retrieveArtifact", "org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer", "java.lang.String:java.util.Set", "apiId:gatewayLabels", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException", "org.wso2.carbon.apimgt.api.gateway.GatewayAPIDTO"), 110);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unDeployAPI", "org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer", "java.lang.String:java.lang.String:java.lang.String", "apiName:version:tenantDomain", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException", "void"), 344);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deployAllAPIsAtGatewayStartup", "org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer", "java.util.Set:java.lang.String", "assignedGatewayLabels:tenantDomain", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException", "boolean"), 148);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "unDeployAPI", "org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer", "org.wso2.carbon.apimgt.gateway.service.APIGatewayAdmin:org.wso2.carbon.apimgt.impl.notifier.events.DeployAPIInGatewayEvent", "apiGatewayAdmin:gatewayEvent", "org.apache.axis2.AxisFault", "void"), 201);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unDeployAPI", "org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer", "org.wso2.carbon.apimgt.impl.notifier.events.DeployAPIInGatewayEvent", "gatewayEvent", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException", "void"), 248);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cleanDeployment", "org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer", "java.lang.String", "artifactRepositoryPath", "", "void"), 261);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "clean", "org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer", "java.io.File:java.util.Set", "artifactRepoPath:skippedList", "", "void"), 288);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addDeployedCertificatesToAPIAssociation", "org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer", "org.wso2.carbon.apimgt.api.gateway.GatewayAPIDTO", "gatewayAPIDTO", "", "void"), 299);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setClientCertificatesToRemoveIntoGatewayDTO", "org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer", "org.wso2.carbon.apimgt.api.gateway.GatewayAPIDTO", "gatewayDTO", "", "void"), 313);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "reDeployAPI", "org.wso2.carbon.apimgt.gateway.InMemoryAPIDeployer", "java.lang.String:java.lang.String:java.lang.String", "apiName:version:tenantDomain", "org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException", "void"), 324);
    }
}

