/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.dto.CertificateMetadataDTO;
import org.wso2.carbon.apimgt.gateway.EndpointCertificateDeployer$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.EndpointCertificateDeployer$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.EndpointCertificateDeployer$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.EndpointCertificateDeployer$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.certificatemgt.CertificateManagerImpl;
import org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class EndpointCertificateDeployer {
    private static final Log log;
    private String tenantDomain;
    private final EventHubConfigurationDto eventHubConfigurationDto = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration().getEventHubConfigurationDto();
    private String baseURL = String.valueOf(this.eventHubConfigurationDto.getServiceUrl()) + "/internal/data/v1";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        EndpointCertificateDeployer.ajc$preClinit();
        log = LogFactory.getLog(EndpointCertificateDeployer.class);
    }

    public EndpointCertificateDeployer(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public void deployCertificatesAtStartup() throws APIManagementException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new EndpointCertificateDeployer$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        EndpointCertificateDeployer.deployCertificatesAtStartup_aroundBody0(this, joinPoint);
    }

    public void deployCertificate(String alias) throws APIManagementException {
        String string = alias;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new EndpointCertificateDeployer$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        EndpointCertificateDeployer.deployCertificate_aroundBody2(this, string, joinPoint);
    }

    private void retrieveCertificatesAndDeploy(CloseableHttpResponse closeableHttpResponse) throws IOException {
        CloseableHttpResponse closeableHttpResponse2 = closeableHttpResponse;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)closeableHttpResponse2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, closeableHttpResponse2, joinPoint};
            MethodTimeLogger.aspectOf().log(new EndpointCertificateDeployer$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        EndpointCertificateDeployer.retrieveCertificatesAndDeploy_aroundBody4(this, closeableHttpResponse2, joinPoint);
    }

    private CloseableHttpResponse invokeService(String endpoint, String tenantDomain) throws IOException, ArtifactSynchronizerException {
        String string = endpoint;
        String string2 = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            return (CloseableHttpResponse)MethodTimeLogger.aspectOf().log(new EndpointCertificateDeployer$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return EndpointCertificateDeployer.invokeService_aroundBody6(this, string, string2, joinPoint);
    }

    static final /* synthetic */ void deployCertificatesAtStartup_aroundBody0(EndpointCertificateDeployer ajc$this, JoinPoint joinPoint) {
        String endpoint = String.valueOf(ajc$this.baseURL) + "/endpoint-certificates";
        try {
            Throwable throwable = null;
            Object var6_6 = null;
            try (CloseableHttpResponse closeableHttpResponse = ajc$this.invokeService(endpoint, ajc$this.tenantDomain);){
                ajc$this.retrieveCertificatesAndDeploy(closeableHttpResponse);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ArtifactSynchronizerException e) {
            throw new APIManagementException("Error while inserting certificates into truststore", e);
        }
    }

    static final /* synthetic */ void deployCertificate_aroundBody2(EndpointCertificateDeployer ajc$this, String alias, JoinPoint joinPoint) {
        String endpoint = String.valueOf(ajc$this.baseURL) + "/endpoint-certificates".concat("?alias=").concat(alias);
        try {
            Throwable throwable = null;
            Object var7_7 = null;
            try (CloseableHttpResponse closeableHttpResponse = ajc$this.invokeService(endpoint, ajc$this.tenantDomain);){
                ajc$this.retrieveCertificatesAndDeploy(closeableHttpResponse);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ArtifactSynchronizerException e) {
            throw new APIManagementException("Error while inserting certificates into truststore", e);
        }
    }

    static final /* synthetic */ void retrieveCertificatesAndDeploy_aroundBody4(EndpointCertificateDeployer ajc$this, CloseableHttpResponse closeableHttpResponse, JoinPoint joinPoint) {
        boolean tenantFlowStarted = false;
        if (closeableHttpResponse.getStatusLine().getStatusCode() == 200) {
            String content = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
            Type listType = new TypeToken<List<CertificateMetadataDTO>>(){}.getType();
            List certificateMetadataDTOList = (List)new Gson().fromJson(content, listType);
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(ajc$this.tenantDomain, true);
                tenantFlowStarted = true;
                for (CertificateMetadataDTO certificateMetadataDTO : certificateMetadataDTOList) {
                    CertificateManagerImpl.getInstance().addCertificateToGateway(certificateMetadataDTO.getCertificate(), certificateMetadataDTO.getAlias());
                }
            }
            finally {
                if (tenantFlowStarted) {
                    PrivilegedCarbonContext.endTenantFlow();
                }
            }
        }
    }

    static final /* synthetic */ CloseableHttpResponse invokeService_aroundBody6(EndpointCertificateDeployer ajc$this, String endpoint, String tenantDomain, JoinPoint joinPoint) {
        HttpGet method = new HttpGet(endpoint);
        URL url = new URL(endpoint);
        String username = ajc$this.eventHubConfigurationDto.getUsername();
        String password = ajc$this.eventHubConfigurationDto.getPassword();
        byte[] credentials = Base64.encodeBase64((byte[])(String.valueOf(username) + ":" + password).getBytes("UTF-8"));
        int port = url.getPort();
        String protocol = url.getProtocol();
        method.setHeader("Authorization", "Basic " + new String(credentials, "UTF-8"));
        if (tenantDomain != null) {
            method.setHeader("xWSO2Tenant", tenantDomain);
        }
        HttpClient httpClient = APIUtil.getHttpClient((int)port, (String)protocol);
        try {
            return APIUtil.executeHTTPRequest((HttpRequestBase)method, (HttpClient)httpClient);
        }
        catch (APIManagementException e) {
            throw new ArtifactSynchronizerException((Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EndpointCertificateDeployer.java", EndpointCertificateDeployer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deployCertificatesAtStartup", "org.wso2.carbon.apimgt.gateway.EndpointCertificateDeployer", "", "", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deployCertificate", "org.wso2.carbon.apimgt.gateway.EndpointCertificateDeployer", "java.lang.String", "alias", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 72);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "retrieveCertificatesAndDeploy", "org.wso2.carbon.apimgt.gateway.EndpointCertificateDeployer", "org.apache.http.client.methods.CloseableHttpResponse", "closeableHttpResponse", "java.io.IOException", "void"), 84);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "invokeService", "org.wso2.carbon.apimgt.gateway.EndpointCertificateDeployer", "java.lang.String:java.lang.String", "endpoint:tenantDomain", "java.io.IOException:org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException", "org.apache.http.client.methods.CloseableHttpResponse"), 112);
    }
}

