/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.schema.transform;

import com.atlassian.oai.validator.schema.transform.SchemaTransformationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.util.Json;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public abstract class SchemaTransformer {
    protected static final String ADDITIONAL_PROPERTIES_FIELD = "additionalProperties";
    protected static final String DISCRIMINATOR_FIELD = "discriminator";
    protected static final String PROPERTIES_FIELD = "properties";
    protected static final String REQUIRED_FIELD = "required";
    protected static final String READONLY_FIELD = "readOnly";
    protected static final String WRITEONLY_FIELD = "writeOnly";
    protected static final String TYPE_FIELD = "type";
    protected static final String COMPONENTS_FIELD = "components";
    protected static final String SCHEMAS_FIELD = "schemas";
    protected static final String ALLOF_FIELD = "allOf";
    protected static final String ANYOF_FIELD = "anyOf";
    protected static final String ONEOF_FIELD = "oneOf";
    protected static final String SCHEMA_REF_FIELD = "$schema";
    private static final String OBJECT_TYPE = "object";
    private static final String ARRAY_TYPE = "array";

    public abstract void apply(JsonNode var1, SchemaTransformationContext var2);

    static void applyToChildSchemas(JsonNode schemaObject, Consumer<JsonNode> consumer) {
        if (SchemaTransformer.isArrayDefinition(schemaObject)) {
            consumer.accept(SchemaTransformer.itemsDefinition(schemaObject));
            return;
        }
        SchemaTransformer.properties(schemaObject).forEachRemaining(consumer);
        SchemaTransformer.allOf(schemaObject).forEachRemaining(consumer);
        SchemaTransformer.anyOf(schemaObject).forEachRemaining(consumer);
        SchemaTransformer.oneOf(schemaObject).forEachRemaining(consumer);
        SchemaTransformer.schemaComponents(schemaObject).forEachRemaining(consumer);
    }

    protected static boolean hasAllOfField(JsonNode n) {
        return n.has(ALLOF_FIELD);
    }

    @Nullable
    protected static JsonNode itemsDefinition(JsonNode n) {
        return n.get("items");
    }

    protected static boolean isObjectDefinition(@Nullable JsonNode n) {
        if (n == null) {
            return false;
        }
        JsonNode type = n.get(TYPE_FIELD);
        return type != null && type.textValue().equalsIgnoreCase(OBJECT_TYPE);
    }

    protected static boolean isArrayDefinition(@Nullable JsonNode n) {
        if (n == null) {
            return false;
        }
        JsonNode type = n.get(TYPE_FIELD);
        return type != null && type.textValue().equalsIgnoreCase(ARRAY_TYPE);
    }

    protected static void disableAdditionalProperties(ObjectNode n) {
        n.set(ADDITIONAL_PROPERTIES_FIELD, (JsonNode)BooleanNode.getFalse());
    }

    protected static Iterator<JsonNode> properties(@Nullable JsonNode n) {
        return n != null && n.has(PROPERTIES_FIELD) ? n.get(PROPERTIES_FIELD).iterator() : Collections.emptyIterator();
    }

    protected static Iterator<JsonNode> allOf(@Nullable JsonNode n) {
        return n != null && n.has(ALLOF_FIELD) ? n.get(ALLOF_FIELD).iterator() : Collections.emptyIterator();
    }

    protected static Iterator<JsonNode> anyOf(@Nullable JsonNode n) {
        return n != null && n.has(ANYOF_FIELD) ? n.get(ANYOF_FIELD).iterator() : Collections.emptyIterator();
    }

    protected static Iterator<JsonNode> oneOf(@Nullable JsonNode n) {
        return n != null && n.has(ONEOF_FIELD) ? n.get(ONEOF_FIELD).iterator() : Collections.emptyIterator();
    }

    protected static Iterator<JsonNode> schemaComponents(@Nullable JsonNode n) {
        return n != null && n.has(COMPONENTS_FIELD) && n.get(COMPONENTS_FIELD).has(SCHEMAS_FIELD) ? n.get(COMPONENTS_FIELD).get(SCHEMAS_FIELD).iterator() : Collections.emptyIterator();
    }

    @Nullable
    protected static JsonNode property(@Nullable JsonNode n, String fieldName) {
        if (n == null || !n.has(PROPERTIES_FIELD)) {
            return null;
        }
        return n.get(PROPERTIES_FIELD).get(fieldName);
    }

    protected static boolean hasDiscriminatorField(@Nullable JsonNode n) {
        return n != null && n.has(DISCRIMINATOR_FIELD);
    }

    protected static boolean hasAdditionalFieldSet(@Nullable JsonNode n) {
        return n != null && n.has(ADDITIONAL_PROPERTIES_FIELD);
    }

    protected static boolean hasRequiredFields(@Nullable JsonNode n) {
        return n != null && n.has(REQUIRED_FIELD);
    }

    protected static List<String> getRequiredFieldNames(@Nullable JsonNode n) {
        if (!SchemaTransformer.hasRequiredFields(n)) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(n.get(REQUIRED_FIELD).spliterator(), false).map(JsonNode::textValue).collect(Collectors.toList());
    }

    protected static void setRequiredFieldNames(@Nullable JsonNode n, List<String> required) {
        if (n == null || required.isEmpty()) {
            return;
        }
        JsonNode requiredNode = (JsonNode)Json.mapper().convertValue(required, JsonNode.class);
        ((ObjectNode)n).set(REQUIRED_FIELD, requiredNode);
    }

    protected static boolean isReadOnly(@Nullable JsonNode n) {
        return n != null && n.has(READONLY_FIELD) && n.get(READONLY_FIELD).booleanValue();
    }

    protected static boolean isWriteOnly(@Nullable JsonNode n) {
        return n != null && n.has(WRITEONLY_FIELD) && n.get(WRITEONLY_FIELD).booleanValue();
    }

    protected static void setSchemaRef(@Nullable JsonNode n, String value) {
        if (!(n instanceof ObjectNode)) {
            return;
        }
        ((ObjectNode)n).put(SCHEMA_REF_FIELD, value);
    }
}

