/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.schema.transform;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.util.Json;

public class SchemaTransformationContext {
    private final boolean isRequest;
    private final boolean isResponse;
    private final boolean additionalPropertiesValidationEnabled;
    private final JsonNode schemaDefinitions;

    private SchemaTransformationContext(boolean isRequest, boolean isResponse, boolean additionalPropertiesValidationEnabled, JsonNode schemaDefinitions) {
        this.isRequest = isRequest;
        this.isResponse = isResponse;
        this.additionalPropertiesValidationEnabled = additionalPropertiesValidationEnabled;
        this.schemaDefinitions = schemaDefinitions;
    }

    public boolean isRequest() {
        return this.isRequest;
    }

    public boolean isResponse() {
        return this.isResponse;
    }

    public boolean isAdditionalPropertiesValidationEnabled() {
        return this.additionalPropertiesValidationEnabled;
    }

    public JsonNode getSchemaDefinitions() {
        return this.schemaDefinitions;
    }

    public static Builder create() {
        return new Builder();
    }

    public static final class Builder {
        private boolean isRequest;
        private boolean isResponse;
        private boolean additionalPropertiesValidationEnabled;
        private JsonNode definitions;

        private Builder() {
        }

        public Builder forRequest(boolean isRequest) {
            this.isRequest = isRequest;
            return this;
        }

        public Builder forResponse(boolean isResponse) {
            this.isResponse = isResponse;
            return this;
        }

        public Builder withAdditionalPropertiesValidation(boolean enabled) {
            this.additionalPropertiesValidationEnabled = enabled;
            return this;
        }

        public Builder withDefinitions(JsonNode definitions) {
            this.definitions = definitions;
            if (this.definitions == null) {
                this.definitions = Json.mapper().createObjectNode();
            }
            return this;
        }

        public SchemaTransformationContext build() {
            return new SchemaTransformationContext(this.isRequest, this.isResponse, this.additionalPropertiesValidationEnabled, this.definitions);
        }
    }
}

