/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.schema.keyword;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DiscriminatorSyntaxChecker
extends AbstractSyntaxChecker {
    private static final DiscriminatorSyntaxChecker INSTANCE = new DiscriminatorSyntaxChecker();

    static DiscriminatorSyntaxChecker getInstance() {
        return INSTANCE;
    }

    DiscriminatorSyntaxChecker() {
        super("discriminator", NodeType.OBJECT, new NodeType[0]);
    }

    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode propertyNameNode = this.getNode(tree).get("propertyName");
        if (propertyNameNode == null) {
            report.error(this.msg(tree, bundle, "err.swaggerv2.discriminator.propertyName.required"));
            return;
        }
        String discriminatorPropertyName = propertyNameNode.textValue();
        if (discriminatorPropertyName == null || discriminatorPropertyName.isEmpty()) {
            report.error(this.msg(tree, bundle, "err.swaggerv2.discriminator.propertyName.empty"));
            return;
        }
        this.validateMapping(bundle, report, tree);
        Optional<JsonNode> maybeCompositionNode = this.getOneOrAnyOfCompositionNodeIfPresent(tree.getNode());
        if (maybeCompositionNode.isPresent()) {
            JsonNode compositionNode = maybeCompositionNode.get();
            Iterator children = compositionNode.elements();
            while (children.hasNext()) {
                this.validatePropertyName(bundle, report, tree, (JsonNode)children.next(), discriminatorPropertyName);
            }
            return;
        }
        this.validatePropertyName(bundle, report, tree, tree.getNode(), discriminatorPropertyName);
    }

    private Optional<JsonNode> getOneOrAnyOfCompositionNodeIfPresent(JsonNode node) {
        return Optional.ofNullable(node.has("oneOf") ? node.get("oneOf") : node.get("anyOf"));
    }

    private void validatePropertyName(MessageBundle bundle, ProcessingReport report, SchemaTree tree, JsonNode node, String discriminatorPropertyName) throws ProcessingException {
        Optional<PropertyLookupResult> maybePropertyLookupResult = this.findProperty(tree, node, discriminatorPropertyName, new HashSet<JsonNode>());
        if (!maybePropertyLookupResult.isPresent()) {
            report.error(this.msg(tree, bundle, "err.swaggerv2.discriminator.propertyName.noProperty").putArgument("fieldName", (Object)discriminatorPropertyName));
            return;
        }
        JsonNode propertyNode = maybePropertyLookupResult.get().getPropertyNode();
        String type = this.getTypeOfProperty(tree, propertyNode);
        if (!"string".equalsIgnoreCase(type)) {
            report.error(this.msg(tree, bundle, "err.swaggerv2.discriminator.wrongType").putArgument("fieldName", (Object)discriminatorPropertyName));
            return;
        }
        JsonNode requiredProperties = maybePropertyLookupResult.get().getParentNode().get("required");
        if (requiredProperties == null || !requiredProperties.isArray() || requiredProperties.size() == 0 || !DiscriminatorSyntaxChecker.arrayNodeContains(requiredProperties, discriminatorPropertyName)) {
            report.error(this.msg(tree, bundle, "err.swaggerv2.discriminator.notRequired").putArgument("fieldName", (Object)discriminatorPropertyName));
        }
    }

    private void validateMapping(MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode mappingNode = this.getNode(tree).get("mapping");
        if (mappingNode == null) {
            return;
        }
        if (!mappingNode.isObject()) {
            report.error(this.msg(tree, bundle, "err.swaggerv2.discriminator.mapping.wrongType"));
            return;
        }
        Iterator mappings = mappingNode.fields();
        while (mappings.hasNext()) {
            String mappingValue;
            Map.Entry mapping = (Map.Entry)mappings.next();
            if (!((JsonNode)mapping.getValue()).isTextual()) {
                report.error(this.msg(tree, bundle, "err.swaggerv2.discriminator.mapping.value.invalidType").putArgument("mappingName", mapping.getKey()));
            }
            if (tree.matchingPointer(JsonRef.fromString((String)(mappingValue = ((JsonNode)mapping.getValue()).textValue()))) != null || tree.matchingPointer(this.shortnameRef(tree, mappingValue)) != null) continue;
            report.error(this.msg(tree, bundle, "err.swaggerv2.discriminator.mapping.value.invalidRef").putArgument("mappingName", mapping.getKey()).putArgument("mappingValue", (Object)mappingValue));
        }
    }

    private Optional<PropertyLookupResult> findProperty(SchemaTree tree, JsonNode node, String propertyName, Set<JsonNode> visitedNodes) throws JsonReferenceException {
        if (visitedNodes.contains(node)) {
            return Optional.empty();
        }
        visitedNodes.add(node);
        if (node.has("properties")) {
            JsonNode propertiesNode = node.get("properties");
            if (!propertiesNode.has(propertyName)) {
                return Optional.empty();
            }
            return Optional.of(new PropertyLookupResult(propertyName, propertiesNode.get(propertyName), node));
        }
        if (node.has("$ref")) {
            JsonRef ref = JsonRef.fromString((String)node.get("$ref").textValue());
            JsonPointer jsonPointer = tree.matchingPointer(ref);
            if (jsonPointer == null) {
                return Optional.empty();
            }
            JsonNode referencedNode = (JsonNode)jsonPointer.get((TreeNode)tree.getBaseNode());
            return this.findProperty(tree, referencedNode, propertyName, visitedNodes);
        }
        if (node.has("allOf")) {
            JsonNode allOfNode = node.get("allOf");
            Iterator children = allOfNode.elements();
            while (children.hasNext()) {
                Optional<PropertyLookupResult> maybeProperty = this.findProperty(tree, (JsonNode)children.next(), propertyName, visitedNodes);
                if (!maybeProperty.isPresent()) continue;
                return maybeProperty;
            }
        }
        return Optional.empty();
    }

    private ProcessingMessage msg(SchemaTree tree, MessageBundle bundle, String key) {
        return this.newMsg(tree, bundle, key).put("key", key);
    }

    private String getTypeOfProperty(SchemaTree tree, JsonNode property) throws JsonReferenceException {
        if (property.has("type")) {
            return property.get("type").textValue();
        }
        if (property.has("$ref")) {
            JsonRef ref = JsonRef.fromString((String)property.get("$ref").textValue());
            JsonNode referent = (JsonNode)tree.matchingPointer(ref).get((TreeNode)tree.getBaseNode());
            if (referent == null || referent.get("type") == null) {
                return null;
            }
            return referent.get("type").textValue();
        }
        return null;
    }

    private static boolean arrayNodeContains(JsonNode arrayNode, String element) {
        return DiscriminatorSyntaxChecker.stream(arrayNode.elements()).anyMatch(e -> e.textValue().equals(element));
    }

    private static <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
    }

    private JsonRef shortnameRef(SchemaTree tree, String shortname) throws JsonReferenceException {
        if (shortname.startsWith("#/components") || shortname.startsWith("#/definitions")) {
            return JsonRef.fromString((String)shortname);
        }
        if (tree.getBaseNode().has("components")) {
            return JsonRef.fromString((String)("#/components/schemas/" + shortname));
        }
        return JsonRef.fromString((String)("#/definitions/" + shortname));
    }

    private static class PropertyLookupResult {
        private final String propertyName;
        private final JsonNode propertyNode;
        private final JsonNode parentNode;

        public PropertyLookupResult(String propertyName, JsonNode propertyNode, JsonNode parentNode) {
            this.propertyName = propertyName;
            this.propertyNode = propertyNode;
            this.parentNode = parentNode;
        }

        public JsonNode getParentNode() {
            return this.parentNode;
        }

        public JsonNode getPropertyNode() {
            return this.propertyNode;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

