/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DiscriminatorKeywordValidator
extends AbstractKeywordValidator {
    private static final Logger log = LoggerFactory.getLogger(DiscriminatorKeywordValidator.class);
    private final ThreadLocal<Set<VisitedInfo>> visitedNodes = ThreadLocal.withInitial(HashSet::new);
    private final String propertyName;
    private final JsonNode mappingNode;

    public DiscriminatorKeywordValidator(JsonNode digest) {
        super("discriminator");
        this.propertyName = digest.get(this.keyword).get("propertyName").textValue();
        this.mappingNode = digest.get(this.keyword).get("mapping");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        VisitedInfo visitInfo = new VisitedInfo(data.getInstance().getPointer(), data.getSchema().getPointer());
        if (this.visitedNodes.get().remove(visitInfo)) {
            return;
        }
        this.visitedNodes.get().add(visitInfo);
        try {
            this.doValidate(processor, report, bundle, data);
        }
        finally {
            this.visitedNodes.get().remove(visitInfo);
        }
    }

    public void doValidate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        JsonNode discriminatorNode = data.getInstance().getNode().get(this.propertyName);
        if (discriminatorNode == null) {
            report.error(this.msg(data, bundle, "err.swaggerv2.discriminator.missing").putArgument("discriminatorField", (Object)this.propertyName));
            return;
        }
        if (!discriminatorNode.isTextual()) {
            report.error(this.msg(data, bundle, "err.swaggerv2.discriminator.nonText").putArgument("discriminatorField", (Object)this.propertyName));
            return;
        }
        String discriminatorPropertyValue = discriminatorNode.textValue();
        if (discriminatorPropertyValue.isEmpty()) {
            report.error(this.msg(data, bundle, "err.swaggerv2.discriminator.missing").putArgument("discriminatorField", (Object)this.propertyName));
            return;
        }
        JsonNode currentSchemaNode = data.getSchema().getNode();
        if (currentSchemaNode.has("oneOf") || currentSchemaNode.has("anyOf")) {
            log.debug("Support for discriminators with oneOf/anyOf not implemented yet. Validation may be inaccurate.");
            return;
        }
        this.validateAllOfComposition(processor, report, bundle, data, discriminatorNode);
    }

    private void validateAllOfComposition(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data, JsonNode discriminatorNode) throws ProcessingException {
        SchemaTree schemaTree = data.getSchema();
        String parentDefinitionRef = "#" + schemaTree.getPointer().toString();
        String discriminatorPropertyValue = discriminatorNode.textValue();
        Map<String, JsonNode> validDiscriminatorValues = this.findValidDiscriminatorValues(data, parentDefinitionRef);
        if (!validDiscriminatorValues.containsKey(discriminatorPropertyValue)) {
            report.error(this.msg(data, bundle, "err.swaggerv2.discriminator.invalid").putArgument("discriminatorField", (Object)this.propertyName).putArgument("value", (Object)discriminatorPropertyValue).putArgument("allowedValues", validDiscriminatorValues.keySet()));
        }
        JsonPointer ptrToChildSchema = this.pointerToDiscriminatedSchema(data, this.mappedDiscriminatorNode(discriminatorNode, discriminatorPropertyValue));
        SchemaTree childSchemaTree = schemaTree.setPointer(ptrToChildSchema);
        ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
        if (childSchemaTree.getNode() == null) {
            report.error(this.msg(data, bundle, "err.swaggerv2.discriminator.reference.invalid").putArgument("schema", (Object)ptrToChildSchema.toString()).put("report", subReport.asJson()));
            return;
        }
        FullData newData = data.withSchema(childSchemaTree);
        processor.process((ProcessingReport)subReport, (MessageProvider)newData);
        if (!subReport.isSuccess()) {
            report.error(this.msg(data, bundle, "err.swaggerv2.discriminator.fail").putArgument("schema", (Object)ptrToChildSchema.toString()).put("report", subReport.asJson()));
        }
    }

    private JsonNode mappedDiscriminatorNode(JsonNode originalDiscriminatorNode, String discriminatorPropertyValue) {
        if (this.mappingNode != null && this.mappingNode.get(discriminatorPropertyValue) != null) {
            return this.mappingNode.get(discriminatorPropertyValue);
        }
        return originalDiscriminatorNode;
    }

    private Map<String, JsonNode> findValidDiscriminatorValues(FullData data, String parentDefinitionRef) {
        HashMap<String, JsonNode> validDiscriminatorValues = new HashMap<String, JsonNode>();
        this.definitionsNode(data).fields().forEachRemaining(e -> {
            JsonNode def = (JsonNode)e.getValue();
            if (!def.has("allOf")) {
                return;
            }
            def.get("allOf").forEach(n -> {
                if (n.has("$ref") && n.get("$ref").textValue().equals(parentDefinitionRef)) {
                    validDiscriminatorValues.put((String)e.getKey(), def);
                }
            });
        });
        if (this.mappingNode != null) {
            this.mappingNode.fields().forEachRemaining(e -> {
                JsonNode cfr_ignored_0 = (JsonNode)validDiscriminatorValues.put((String)e.getKey(), (JsonNode)e.getValue());
            });
        }
        return validDiscriminatorValues;
    }

    private JsonPointer pointerToDiscriminatedSchema(FullData data, JsonNode discriminatorNode) {
        String discriminatorNodeText = this.normalizeDiscriminatorNode(discriminatorNode.textValue());
        if (data.getSchema().getBaseNode().has("components")) {
            return JsonPointer.of((Object)"components", (Object[])new Object[]{"schemas", discriminatorNodeText});
        }
        return JsonPointer.of((Object)"definitions", (Object[])new Object[]{discriminatorNodeText});
    }

    private JsonNode definitionsNode(FullData data) {
        JsonNode baseNode = data.getSchema().getBaseNode();
        if (baseNode.has("components")) {
            return baseNode.get("components").get("schemas");
        }
        return baseNode.get("definitions");
    }

    private String normalizeDiscriminatorNode(String discriminatorNodeText) {
        if (discriminatorNodeText.startsWith("#/")) {
            int n = discriminatorNodeText.lastIndexOf(47);
            return discriminatorNodeText.substring(n + 1);
        }
        return discriminatorNodeText;
    }

    public String toString() {
        return this.keyword;
    }

    private ProcessingMessage msg(FullData data, MessageBundle bundle, String key) {
        return this.newMsg(data, bundle, key).put("key", key);
    }

    private static class VisitedInfo {
        private final JsonPointer instancePointer;
        private final JsonPointer schemaPointer;

        public VisitedInfo(JsonPointer instancePointer, JsonPointer schemaPointer) {
            this.instancePointer = instancePointer;
            this.schemaPointer = schemaPointer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VisitedInfo that = (VisitedInfo)o;
            return Objects.equals(this.instancePointer, that.instancePointer) && Objects.equals(this.schemaPointer, that.schemaPointer);
        }

        public int hashCode() {
            return Objects.hash(this.instancePointer, this.schemaPointer);
        }
    }
}

