/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.schema;

import com.atlassian.oai.validator.schema.format.Base64Attribute;
import com.atlassian.oai.validator.schema.format.DoubleAttribute;
import com.atlassian.oai.validator.schema.format.FloatAttribute;
import com.atlassian.oai.validator.schema.format.Int32Attribute;
import com.atlassian.oai.validator.schema.format.Int64Attribute;
import com.atlassian.oai.validator.schema.keyword.Discriminator;
import com.atlassian.oai.validator.schema.keyword.Nullable;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.messages.JsonSchemaSyntaxMessageBundle;
import com.github.fge.jsonschema.core.report.ListReportProvider;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ReportProvider;
import com.github.fge.jsonschema.format.draftv3.DateAttribute;
import com.github.fge.jsonschema.library.DraftV4Library;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.messages.JsonSchemaValidationBundle;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.bundle.PropertiesBundle;
import com.github.fge.msgsimple.load.MessageBundleLoader;
import com.github.fge.msgsimple.load.MessageBundles;

public class SwaggerV20Library {
    public static final String OAI_V2_METASCHEMA_URI = "https://openapis.org/specification/versions/2.0#";

    private SwaggerV20Library() {
    }

    static Library get() {
        return DraftV4Library.get().thaw().addFormatAttribute("int32", Int32Attribute.getInstance()).addFormatAttribute("int64", Int64Attribute.getInstance()).addFormatAttribute("float", FloatAttribute.getInstance()).addFormatAttribute("double", DoubleAttribute.getInstance()).addFormatAttribute("date", DateAttribute.getInstance()).addFormatAttribute("byte", Base64Attribute.getInstance()).addKeyword(Nullable.getInstance()).addKeyword(Discriminator.getInstance()).freeze();
    }

    public static JsonSchemaFactory schemaFactory() {
        return JsonSchemaFactory.newBuilder().setValidationConfiguration(ValidationConfiguration.newBuilder().setDefaultLibrary(OAI_V2_METASCHEMA_URI, SwaggerV20Library.get()).setSyntaxMessages(MessageBundles.getBundle(SyntaxBundle.class)).setValidationMessages(MessageBundles.getBundle(ValidationBundle.class)).freeze()).setReportProvider((ReportProvider)new ListReportProvider(LogLevel.ERROR, LogLevel.FATAL)).freeze();
    }

    public static JsonSchemaFactory schemaFactory(LogLevel logLevel, LogLevel exceptionThreshold) {
        return JsonSchemaFactory.newBuilder().setValidationConfiguration(ValidationConfiguration.newBuilder().setDefaultLibrary(OAI_V2_METASCHEMA_URI, SwaggerV20Library.get()).setSyntaxMessages(MessageBundles.getBundle(SyntaxBundle.class)).setValidationMessages(MessageBundles.getBundle(ValidationBundle.class)).freeze()).setReportProvider((ReportProvider)new ListReportProvider(logLevel, exceptionThreshold)).freeze();
    }

    public static class ValidationBundle
    implements MessageBundleLoader {
        private static final String PATH = "/swagger/validation/schema-validation.properties";

        public MessageBundle getBundle() {
            return MessageBundles.getBundle(JsonSchemaValidationBundle.class).thaw().appendBundle(PropertiesBundle.forPath((String)PATH)).freeze();
        }
    }

    public static class SyntaxBundle
    implements MessageBundleLoader {
        private static final String PATH = "/swagger/validation/schema-validation.properties";

        public MessageBundle getBundle() {
            return MessageBundles.getBundle(JsonSchemaSyntaxMessageBundle.class).thaw().appendBundle(PropertiesBundle.forPath((String)PATH)).freeze();
        }
    }
}

