/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.schema;

import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.schema.CustomDateTimeFormatter;
import com.atlassian.oai.validator.schema.SwaggerV20Library;
import com.atlassian.oai.validator.schema.transform.AdditionalPropertiesInjectionTransformer;
import com.atlassian.oai.validator.schema.transform.RequiredFieldTransformer;
import com.atlassian.oai.validator.schema.transform.SchemaDefinitionsInjectionTransformer;
import com.atlassian.oai.validator.schema.transform.SchemaRefInjectionTransformer;
import com.atlassian.oai.validator.schema.transform.SchemaTransformationContext;
import com.atlassian.oai.validator.schema.transform.SchemaTransformer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import io.swagger.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaValidator {
    private static final Logger log = LoggerFactory.getLogger(SchemaValidator.class);
    public static final String ADDITIONAL_PROPERTIES_KEY = "validation.schema.additionalProperties";
    public static final String INVALID_JSON_KEY = "validation.schema.invalidJson";
    public static final String UNKNOWN_ERROR_KEY = "validation.schema.unknownError";
    private static final String ALLOF_FIELD = "allOf";
    private final MessageResolver messages;
    private final LoadingCache<JsonSchemaKey, JsonSchema> jsonSchemaCache;
    private final List<SchemaTransformer> transformers = Arrays.asList(SchemaDefinitionsInjectionTransformer.getInstance(), SchemaRefInjectionTransformer.getInstance(), AdditionalPropertiesInjectionTransformer.getInstance(), RequiredFieldTransformer.getInstance());

    public SchemaValidator(OpenAPI api, @Nonnull MessageResolver messages) {
        this.messages = Objects.requireNonNull(messages, "A message resolver is required");
        final JsonNode definitions = Optional.ofNullable(api.getComponents()).map(Components::getSchemas).map(schemas -> (JsonNode)Json.mapper().convertValue(schemas, JsonNode.class)).orElseGet(() -> Json.mapper().createObjectNode());
        final JsonSchemaFactory schemaFactory = SwaggerV20Library.schemaFactory();
        this.jsonSchemaCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<JsonSchemaKey, JsonSchema>(){

            public JsonSchema load(JsonSchemaKey key) throws ProcessingException {
                JsonNode schemaObject = SchemaValidator.this.readAndTransformSchemaObject(key.schema, key.forRequest, key.forResponse, definitions);
                return schemaFactory.getJsonSchema(schemaObject);
            }
        });
    }

    @Nonnull
    public ValidationReport validate(@Nonnull String value, @Nullable Schema schema, @Nullable String keyPrefix) {
        Objects.requireNonNull(value, "A value is required");
        return this.validate(() -> SchemaValidator.readContent(value, schema), schema, keyPrefix);
    }

    @Nonnull
    public ValidationReport validate(@Nonnull JsonNodeSupplier supplier, @Nullable Schema schema, @Nullable String keyPrefix) {
        if (schema == null) {
            return ValidationReport.empty();
        }
        try {
            ListProcessingReport processingReport;
            try {
                JsonNode content = supplier.get();
                JsonSchema jsonSchema = this.resolveJsonSchema(schema, keyPrefix);
                processingReport = (ListProcessingReport)jsonSchema.validate(content, true);
            }
            catch (ProcessingException e) {
                return this.getProcessingMessage(e.getProcessingMessage(), "processingError", keyPrefix);
            }
            catch (IOException e) {
                return ValidationReport.singleton(this.messages.create("validation." + keyPrefix + ".schema.invalidJson", this.messages.get(INVALID_JSON_KEY, e.getMessage()).getMessage(), new String[0]));
            }
            if (processingReport != null && !processingReport.isSuccess()) {
                return StreamSupport.stream(processingReport.spliterator(), false).map(pm -> this.getProcessingMessage((ProcessingMessage)pm, null, keyPrefix)).reduce(ValidationReport.empty(), ValidationReport::merge);
            }
            return ValidationReport.empty();
        }
        catch (RuntimeException e) {
            log.debug("Error during schema validation", (Throwable)e);
            return ValidationReport.singleton(this.messages.create("validation." + keyPrefix + ".schema.unknownError", this.messages.get(UNKNOWN_ERROR_KEY, e.getMessage()).getMessage(), new String[0]));
        }
    }

    private JsonSchema resolveJsonSchema(Schema schema, @Nullable String keyPrefix) throws ProcessingException {
        boolean forRequest = "request.body".equalsIgnoreCase(keyPrefix);
        boolean forResponse = "response.body".equalsIgnoreCase(keyPrefix);
        JsonSchemaKey jsonSchemaKey = new JsonSchemaKey(schema, forRequest, forResponse);
        try {
            return (JsonSchema)this.jsonSchemaCache.get((Object)jsonSchemaKey);
        }
        catch (ExecutionException e) {
            List causalChain = Throwables.getCausalChain((Throwable)e);
            throw (ProcessingException)causalChain.stream().filter(exception -> exception instanceof ProcessingException).findFirst().orElseGet(() -> new ProcessingException("JsonSchema creation failed.", (Throwable)Iterables.getLast((Iterable)causalChain)));
        }
    }

    private JsonNode readAndTransformSchemaObject(Schema schema, boolean forRequest, boolean forResponse, JsonNode definitions) {
        ObjectNode schemaObject = (ObjectNode)Json.mapper().convertValue((Object)schema, ObjectNode.class);
        SchemaTransformationContext transformationContext = SchemaTransformationContext.create().forRequest(forRequest).forResponse(forResponse).withAdditionalPropertiesValidation(this.additionalPropertiesValidationEnabled()).withDefinitions(definitions.deepCopy()).build();
        this.transformers.forEach(t -> t.apply((JsonNode)schemaObject, transformationContext));
        this.checkForKnownGotchasAndLogMessage((JsonNode)schemaObject);
        return schemaObject;
    }

    private static JsonNode readContent(@Nonnull String value, @Nonnull Schema schema) throws IOException {
        if ("null".equalsIgnoreCase(value)) {
            return Json.mapper().readTree("null");
        }
        if (schema instanceof DateTimeSchema) {
            return SchemaValidator.createStringNode(SchemaValidator.normaliseDateTime(value));
        }
        if ("string".equalsIgnoreCase(schema.getType())) {
            return SchemaValidator.createStringNode(value);
        }
        if ("number".equalsIgnoreCase(schema.getType()) || "integer".equalsIgnoreCase(schema.getType())) {
            return SchemaValidator.createNumericNode(value);
        }
        return Json.mapper().readTree(value);
    }

    private static JsonNode createStringNode(String value) {
        return new TextNode(value);
    }

    private static JsonNode createNumericNode(String value) throws IOException {
        try {
            Double.parseDouble(value);
            return Json.mapper().readTree(value);
        }
        catch (NumberFormatException e) {
            return SchemaValidator.createStringNode(value);
        }
    }

    private static String normaliseDateTime(String dateTime) {
        try {
            LocalDateTime rfc3339dt = LocalDateTime.parse(dateTime, CustomDateTimeFormatter.getRFC3339Formatter());
            return rfc3339dt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"));
        }
        catch (DateTimeParseException e) {
            return dateTime;
        }
    }

    private boolean additionalPropertiesValidationEnabled() {
        return !this.messages.isIgnored(ADDITIONAL_PROPERTIES_KEY);
    }

    private void checkForKnownGotchasAndLogMessage(JsonNode schemaObject) {
        if (this.additionalPropertiesValidationEnabled() && schemaObject.has(ALLOF_FIELD)) {
            log.info("Note: Schema uses the 'allOf' keyword. Validation of 'additionalProperties' may fail with unexpected errors. See the project README FAQ for more information.");
        }
    }

    private ValidationReport getProcessingMessage(ProcessingMessage pm, String keywordOverride, String keyPrefix) {
        return ValidationReport.singleton(this.toValidationReportMessage(pm.asJson(), keywordOverride, keyPrefix));
    }

    private ValidationReport.Message toValidationReportMessage(JsonNode processingMessage, String keywordOverride, String keyPrefix) {
        String validationKeyword = keywordOverride != null ? keywordOverride : processingMessage.get("keyword").textValue() + (processingMessage.has("attribute") ? "." + processingMessage.get("attribute").textValue() : "");
        String pointer = processingMessage.has("instance") ? processingMessage.get("instance").get("pointer").textValue() : "";
        ArrayList subReports = new ArrayList();
        if (processingMessage.has("reports")) {
            JsonNode reports = processingMessage.get("reports");
            reports.fields().forEachRemaining(field -> ((JsonNode)field.getValue()).elements().forEachRemaining(report -> subReports.add((String)field.getKey() + ": " + StringUtils.capitalize((String)report.get("message").textValue()))));
        }
        String message = (pointer.isEmpty() ? "" : "[Path '" + pointer + "'] ") + StringUtils.capitalize((String)processingMessage.get("message").textValue());
        ValidationReport.Message validationReportMessage = this.messages.create("validation." + keyPrefix + ".schema." + validationKeyword, message, subReports.toArray(new String[0]));
        return this.withNestedMessages(processingMessage, keywordOverride, keyPrefix, validationReportMessage);
    }

    private ValidationReport.Message withNestedMessages(JsonNode processingMessage, String keywordOverride, String keyPrefix, ValidationReport.Message validationReportMessage) {
        if (!processingMessage.has("reports")) {
            return validationReportMessage;
        }
        ArrayList<ValidationReport.Message> nestedMessages = new ArrayList<ValidationReport.Message>();
        JsonNode reports = processingMessage.get("reports");
        reports.fields().forEachRemaining(field -> ((JsonNode)field.getValue()).elements().forEachRemaining(report -> nestedMessages.add(this.toValidationReportMessage((JsonNode)report, keywordOverride, keyPrefix))));
        return validationReportMessage.withNestedMessages(nestedMessages);
    }

    private static class JsonSchemaKey {
        private final Schema schema;
        private final boolean forRequest;
        private final boolean forResponse;

        private JsonSchemaKey(Schema schema, boolean forRequest, boolean forResponse) {
            this.schema = schema;
            this.forRequest = forRequest;
            this.forResponse = forResponse;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonSchemaKey that = (JsonSchemaKey)o;
            return this.forRequest == that.forRequest && this.forResponse == that.forResponse && Objects.equals(this.schema, that.schema);
        }

        public int hashCode() {
            return Objects.hash(this.forRequest, this.forResponse, this.schema);
        }
    }

    @FunctionalInterface
    public static interface JsonNodeSupplier {
        public JsonNode get() throws IOException;
    }
}

