/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.report;

import com.atlassian.oai.validator.report.ValidationReport;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LevelLoader {
    public static LevelLoader systemPropertyLoader() {
        return new PropertiesLoader(System.getProperties(), "swagger.");
    }

    public static LevelLoader currentDirectoryLoader() {
        return new PropertiesLoader(new File(System.getProperty("user.dir"), ".swagger-validator"), null);
    }

    public static LevelLoader classpathLoader() {
        return new PropertiesLoader(LevelLoader.class.getClassLoader().getResource("swagger-validator.properties"), null);
    }

    public static LevelLoader defaultsLoader() {
        return new PropertiesLoader(LevelLoader.class.getResource("/default-levels.properties"), null);
    }

    public static LevelLoader defaultLoaderChain() {
        return new ChainingLoader(LevelLoader.classpathLoader(), LevelLoader.currentDirectoryLoader(), LevelLoader.systemPropertyLoader());
    }

    public Map<String, ValidationReport.Level> loadLevels();

    public Optional<ValidationReport.Level> defaultLevel();

    public static class ChainingLoader
    implements LevelLoader {
        private final LevelLoader[] loaders;

        public ChainingLoader(LevelLoader ... loaders) {
            this.loaders = loaders;
        }

        @Override
        public Map<String, ValidationReport.Level> loadLevels() {
            HashMap<String, ValidationReport.Level> result = new HashMap<String, ValidationReport.Level>();
            for (LevelLoader l : this.loaders) {
                result.putAll(l.loadLevels());
            }
            return result;
        }

        @Override
        public Optional<ValidationReport.Level> defaultLevel() {
            for (int i = this.loaders.length - 1; i >= 0; --i) {
                Optional<ValidationReport.Level> level = this.loaders[i].defaultLevel();
                if (!level.isPresent()) continue;
                return level;
            }
            return Optional.empty();
        }
    }

    public static class PropertiesLoader
    implements LevelLoader {
        private static final Logger log = LoggerFactory.getLogger(PropertiesLoader.class);
        private static final String VALIDATION_KEY_PREFIX = "validation";
        private static final String DEFAULT_LEVEL_KEY = "defaultLevel";
        private final Properties props;
        private final String prefix;

        public PropertiesLoader(String sourcePath, String prefix) {
            this(new File(sourcePath), prefix);
        }

        public PropertiesLoader(File source, String prefix) {
            this.prefix = prefix;
            this.props = new Properties();
            if (!source.exists()) {
                log.debug("Levels file {} does not exist. Skipping.", (Object)source);
                return;
            }
            try {
                this.props.load(new FileReader(source));
            }
            catch (IOException e) {
                log.warn(String.format("Unable to load levels file %s", source.getAbsolutePath()), (Throwable)e);
            }
        }

        public PropertiesLoader(URL source, String prefix) {
            this.prefix = prefix;
            this.props = new Properties();
            if (source == null) {
                return;
            }
            try {
                this.props.load(new InputStreamReader(source.openStream()));
            }
            catch (IOException e) {
                log.warn(String.format("Unable to load levels file %s", source.toExternalForm()), (Throwable)e);
            }
        }

        public PropertiesLoader(Properties source, String prefix) {
            this.prefix = prefix;
            this.props = source;
        }

        @Override
        public Map<String, ValidationReport.Level> loadLevels() {
            HashMap<String, ValidationReport.Level> result = new HashMap<String, ValidationReport.Level>();
            this.props.stringPropertyNames().forEach(n -> {
                if (!n.startsWith(this.toPropertyName(VALIDATION_KEY_PREFIX))) {
                    return;
                }
                String key = this.fromPropertyName((String)n);
                String value = this.props.getProperty((String)n).toUpperCase();
                try {
                    result.put(key, ValidationReport.Level.valueOf(value));
                }
                catch (Exception e) {
                    log.warn("Unable to load level {} from property with value '{}'.", (Object)key, (Object)value);
                }
            });
            return result;
        }

        @Override
        public Optional<ValidationReport.Level> defaultLevel() {
            if (!this.props.containsKey(this.toPropertyName(DEFAULT_LEVEL_KEY))) {
                return Optional.empty();
            }
            String value = this.props.getProperty(this.toPropertyName(DEFAULT_LEVEL_KEY));
            try {
                return Optional.of(ValidationReport.Level.valueOf(value.toUpperCase()));
            }
            catch (Exception e) {
                log.warn("Unable to load the default level from property '{}'.", (Object)value);
                return Optional.empty();
            }
        }

        private String toPropertyName(String keyName) {
            if (this.prefix == null || this.prefix.isEmpty()) {
                return keyName;
            }
            return this.prefix + keyName;
        }

        private String fromPropertyName(String propertyName) {
            if (this.prefix == null || this.prefix.isEmpty()) {
                return propertyName;
            }
            return propertyName.replace(this.prefix, "");
        }
    }
}

