/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.report;

import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.report.ValidationReportFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

public class JsonValidationReportFormat
implements ValidationReportFormat {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final JsonValidationReportFormat INSTANCE;

    public static JsonValidationReportFormat getInstance() {
        return INSTANCE;
    }

    @Override
    public String apply(ValidationReport report) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)report);
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    private JsonValidationReportFormat() {
    }

    static {
        OBJECT_MAPPER.findAndRegisterModules();
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        OBJECT_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        INSTANCE = new JsonValidationReportFormat();
    }
}

