/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.report;

import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.whitelist.NamedWhitelistRule;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.Objects;
import java.util.Optional;

class ImmutableMessageContext
implements ValidationReport.MessageContext {
    private final String requestPath;
    private final Request.Method method;
    private final ApiOperation apiOperation;
    private final Parameter parameter;
    private final RequestBody apiRequestBodyDefinition;
    private final String apiRequestContentType;
    private final Integer responseStatus;
    private final ApiResponse apiResponseDefinition;
    private final ValidationReport.MessageContext.Location location;
    private final NamedWhitelistRule whitelistRule;

    ImmutableMessageContext(ValidationReport.MessageContext.Builder builder) {
        this.requestPath = builder.requestPath;
        this.method = builder.method;
        this.apiOperation = builder.apiOperation;
        this.parameter = builder.parameter;
        this.apiRequestBodyDefinition = builder.apiRequestBodyDefinition;
        this.apiRequestContentType = builder.apiRequestContentType;
        this.responseStatus = builder.responseStatus;
        this.apiResponseDefinition = builder.apiResponse;
        this.location = builder.location;
        this.whitelistRule = builder.whitelistRule;
    }

    @Override
    public Optional<String> getRequestPath() {
        return Optional.ofNullable(this.requestPath);
    }

    @Override
    public Optional<Request.Method> getRequestMethod() {
        return Optional.ofNullable(this.method);
    }

    @Override
    @JsonIgnore
    public Optional<ApiOperation> getApiOperation() {
        return Optional.ofNullable(this.apiOperation);
    }

    @Override
    public Optional<Parameter> getParameter() {
        return Optional.ofNullable(this.parameter);
    }

    @Override
    @JsonIgnore
    public Optional<RequestBody> getApiRequestBodyDefinition() {
        return Optional.ofNullable(this.apiRequestBodyDefinition);
    }

    @Override
    public Optional<String> getApiRequestContentType() {
        return Optional.ofNullable(this.apiRequestContentType);
    }

    @Override
    public Optional<Integer> getResponseStatus() {
        return Optional.ofNullable(this.responseStatus);
    }

    @Override
    @JsonIgnore
    public Optional<ApiResponse> getApiResponseDefinition() {
        return Optional.ofNullable(this.apiResponseDefinition);
    }

    @Override
    public Optional<ValidationReport.MessageContext.Location> getLocation() {
        return Optional.ofNullable(this.location);
    }

    @Override
    public Optional<NamedWhitelistRule> getAppliedWhitelistRule() {
        return Optional.ofNullable(this.whitelistRule);
    }

    @Override
    public boolean hasData() {
        return this.requestPath != null || this.method != null || this.apiOperation != null || this.apiRequestContentType != null || this.apiRequestBodyDefinition != null || this.parameter != null || this.responseStatus != null || this.apiResponseDefinition != null || this.location != null || this.whitelistRule != null;
    }

    @Override
    public ValidationReport.MessageContext enhanceWith(ValidationReport.MessageContext other) {
        return ValidationReport.MessageContext.from(this).withAdditionalDataFrom(other).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableMessageContext that = (ImmutableMessageContext)o;
        return Objects.equals(this.requestPath, that.requestPath) && this.method == that.method && Objects.equals(this.apiOperation, that.apiOperation) && Objects.equals(this.parameter, that.parameter) && Objects.equals(this.apiRequestBodyDefinition, that.apiRequestBodyDefinition) && Objects.equals(this.apiRequestContentType, that.apiRequestContentType) && Objects.equals(this.responseStatus, that.responseStatus) && Objects.equals(this.apiResponseDefinition, that.apiResponseDefinition) && Objects.equals(this.whitelistRule, that.whitelistRule) && this.location == that.location;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestPath, this.method, this.apiOperation, this.parameter, this.apiRequestBodyDefinition, this.apiRequestContentType, this.responseStatus, this.apiResponseDefinition, this.location, this.whitelistRule});
    }
}

