/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.model;

import com.atlassian.oai.validator.model.Body;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.util.Json;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public class StringBody
implements Body {
    private final String content;
    private final Charset charset;

    public StringBody(@Nonnull String content, @Nonnull Charset charset) {
        this.content = content;
        this.charset = charset;
    }

    @Override
    public boolean hasBody() {
        return this.content.length() > 0;
    }

    @Override
    public JsonNode toJsonNode() throws IOException {
        return Json.mapper().readTree(this.content);
    }

    @Override
    public String toString(@Nonnull Charset encoding) {
        if (this.charset == encoding) {
            return this.content;
        }
        return new String(this.content.getBytes(this.charset), encoding);
    }
}

