/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.model;

import com.atlassian.oai.validator.model.Body;
import com.atlassian.oai.validator.model.ByteArrayBody;
import com.atlassian.oai.validator.model.InputStreamBody;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.StringBody;
import com.atlassian.oai.validator.util.ContentTypeUtils;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleRequest
implements Request {
    private final Request.Method method;
    private final String path;
    private final Map<String, Collection<String>> headers;
    private final Map<String, Collection<String>> queryParams;
    private final Optional<Body> requestBody;

    private SimpleRequest(@Nonnull Request.Method method, @Nonnull String path, @Nonnull Map<String, Collection<String>> headers, @Nonnull Map<String, Collection<String>> queryParams, @Nullable Body body) {
        this.method = Objects.requireNonNull(method, "A method is required");
        this.path = Objects.requireNonNull(path, "A request path is required");
        this.queryParams = Objects.requireNonNull(queryParams);
        this.headers = Objects.requireNonNull(headers);
        this.requestBody = Optional.ofNullable(body);
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Override
    @Nonnull
    public Request.Method getMethod() {
        return this.method;
    }

    @Override
    @Nonnull
    public Optional<String> getBody() {
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<Body> getRequestBody() {
        return this.requestBody;
    }

    @Override
    @Nonnull
    public Collection<String> getQueryParameterValues(String name) {
        return SimpleRequest.getFromMapOrEmptyList(this.queryParams, name);
    }

    @Override
    @Nonnull
    public Collection<String> getQueryParameters() {
        return Collections.unmodifiableCollection(this.queryParams.keySet());
    }

    @Override
    @Nonnull
    public Map<String, Collection<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    @Nonnull
    public Collection<String> getHeaderValues(String name) {
        return SimpleRequest.getFromMapOrEmptyList(this.headers, name);
    }

    static Collection<String> getFromMapOrEmptyList(Map<String, Collection<String>> map, String name) {
        if (name == null || !map.containsKey(name)) {
            return Collections.emptyList();
        }
        return map.get(name).stream().filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public static class Builder {
        private final Request.Method method;
        private final String path;
        private final Multimap<String, String> headers;
        private final Multimap<String, String> queryParams;
        private Body body;
        private String bodyAsStringFallback;

        public static Builder get(String path) {
            return new Builder(Request.Method.GET, path);
        }

        public static Builder put(String path) {
            return new Builder(Request.Method.PUT, path);
        }

        public static Builder post(String path) {
            return new Builder(Request.Method.POST, path);
        }

        public static Builder delete(String path) {
            return new Builder(Request.Method.DELETE, path);
        }

        public static Builder patch(String path) {
            return new Builder(Request.Method.PATCH, path);
        }

        public static Builder head(String path) {
            return new Builder(Request.Method.HEAD, path);
        }

        public static Builder options(String path) {
            return new Builder(Request.Method.OPTIONS, path);
        }

        public static Builder trace(String path) {
            return new Builder(Request.Method.TRACE, path);
        }

        public Builder(String method, String path) {
            this(method, path, false);
        }

        public Builder(Request.Method method, String path) {
            this(method, path, false);
        }

        public Builder(String method, String path, boolean queryParametersCaseSensitive) {
            this(Request.Method.valueOf(Objects.requireNonNull(method, "A method is required").toUpperCase()), path, queryParametersCaseSensitive);
        }

        public Builder(Request.Method method, String path, boolean queryParametersCaseSensitive) {
            this.method = Objects.requireNonNull(method, "A method is required");
            this.path = Objects.requireNonNull(path, "A path is required");
            this.headers = Builder.multimapBuilder(false);
            this.queryParams = Builder.multimapBuilder(queryParametersCaseSensitive);
        }

        public Builder withBody(String content) {
            this.bodyAsStringFallback = content;
            return this;
        }

        public Builder withBody(String content, Charset charset) {
            if (content != null && charset != null) {
                this.body = new StringBody(content, charset);
                return this;
            }
            return this.withBody(content);
        }

        public Builder withBody(byte[] content) {
            this.body = content != null ? new ByteArrayBody(content) : null;
            return this;
        }

        public Builder withBody(InputStream content) {
            this.body = content != null ? new InputStreamBody(content) : null;
            return this;
        }

        public Builder withHeader(String name, List<String> values) {
            Builder.putValuesToMapOrDefault(this.headers, name, values, "");
            return this;
        }

        public Builder withHeader(String name, String ... values) {
            return this.withHeader(name, Arrays.asList(values));
        }

        public Builder withContentType(String contentType) {
            return this.withHeader("Content-Type", contentType);
        }

        public Builder withAccept(String ... accept) {
            return this.withHeader("Accept", accept);
        }

        public Builder withAuthorization(String auth) {
            return this.withHeader("Authorization", auth);
        }

        public Builder withQueryParam(String name, List<String> values) {
            Builder.putValuesToMapOrDefault(this.queryParams, name, values, null);
            return this;
        }

        public Builder withQueryParam(String name, String ... values) {
            return this.withQueryParam(name, Arrays.asList(values));
        }

        public SimpleRequest build() {
            if (this.body == null && this.bodyAsStringFallback != null) {
                Charset charset = ContentTypeUtils.getCharsetFromContentType(this.headers).orElse(StandardCharsets.UTF_8);
                this.body = new StringBody(this.bodyAsStringFallback, charset);
            }
            return new SimpleRequest(this.method, this.path, this.headers.asMap(), this.queryParams.asMap(), this.body);
        }

        static Multimap<String, String> multimapBuilder(boolean caseSensitive) {
            return caseSensitive ? MultimapBuilder.hashKeys().arrayListValues().build() : MultimapBuilder.treeKeys((Comparator)String.CASE_INSENSITIVE_ORDER).arrayListValues().build();
        }

        static void putValuesToMapOrDefault(Multimap<String, String> map, String name, List<String> values, String defaultIfNotSet) {
            if (values == null || values.isEmpty()) {
                map.put((Object)name, (Object)defaultIfNotSet);
            } else {
                map.putAll((Object)name, values);
            }
        }
    }
}

