/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.model;

import com.atlassian.oai.validator.model.NormalisedPath;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class NormalisedPathImpl
implements NormalisedPath {
    private final List<String> pathParts;
    private final String original;
    private final String normalised;

    public NormalisedPathImpl(@Nonnull String path, @Nullable String apiPrefix) {
        this.original = Objects.requireNonNull(path, "A path is required");
        this.normalised = NormalisedPathImpl.normalise(apiPrefix, path);
        this.pathParts = Collections.unmodifiableList(Arrays.asList(this.normalised.substring(1).split("/")));
    }

    @Override
    public int numberOfParts() {
        return this.pathParts.size();
    }

    @Override
    @Nonnull
    public String part(int index) {
        return this.pathParts.get(index);
    }

    @Override
    @Nonnull
    public String original() {
        return this.original;
    }

    @Override
    @Nonnull
    public String normalised() {
        return this.normalised;
    }

    private static String normalise(@Nullable String prefix, @Nonnull String requestPath) {
        String trimmedPath = NormalisedPathImpl.trimPrefix(NormalisedPathImpl.normaliseToLeadingSlash(prefix), NormalisedPathImpl.normaliseToLeadingSlash(requestPath));
        return NormalisedPathImpl.normaliseToLeadingSlash(trimmedPath);
    }

    private static String trimPrefix(@Nullable String apiPrefix, @Nonnull String requestPath) {
        if (apiPrefix == null || !requestPath.startsWith(apiPrefix)) {
            return requestPath;
        }
        return requestPath.substring(apiPrefix.length());
    }

    private static String normaliseToLeadingSlash(@Nullable String pathPart) {
        return StringUtils.prependIfMissing((String)StringUtils.trimToEmpty((String)pathPart), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

