/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.model;

import com.atlassian.oai.validator.model.Body;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.util.Json;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;

public class InputStreamBody
implements Body {
    private final PushbackInputStream content;

    public InputStreamBody(@Nonnull InputStream content) {
        this.content = new PushbackInputStream(content);
    }

    @Override
    public boolean hasBody() {
        try {
            int firstSign = this.content.read();
            this.content.unread(firstSign);
            return firstSign != -1;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public JsonNode toJsonNode() throws IOException {
        return Json.mapper().readTree((InputStream)this.content);
    }

    @Override
    public String toString(Charset encoding) throws IOException {
        return IOUtils.toString((InputStream)this.content, (Charset)encoding);
    }
}

