/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.interaction.response;

import com.atlassian.oai.validator.interaction.response.CustomResponseValidator;
import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.Body;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.schema.SchemaValidator;
import com.atlassian.oai.validator.util.ContentTypeUtils;
import com.atlassian.oai.validator.util.HttpParsingUtils;
import com.google.common.net.MediaType;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseValidator {
    private static final Logger log = LoggerFactory.getLogger(ResponseValidator.class);
    private final SchemaValidator schemaValidator;
    private final MessageResolver messages;
    private final OpenAPI api;
    private final List<CustomResponseValidator> customResponseValidators;

    public ResponseValidator(SchemaValidator schemaValidator, MessageResolver messages, OpenAPI api, List<CustomResponseValidator> customResponseValidators) {
        this.schemaValidator = Objects.requireNonNull(schemaValidator, "A schema validator is required");
        this.messages = Objects.requireNonNull(messages, "A message resolver is required");
        this.api = Objects.requireNonNull(api, "An OAI definition is required");
        this.customResponseValidators = customResponseValidators;
    }

    @Nonnull
    public ValidationReport validateResponse(Response response, ApiOperation apiOperation) {
        Objects.requireNonNull(response, "A response is required");
        Objects.requireNonNull(apiOperation, "An API operation is required");
        ApiResponse apiResponse = this.getApiResponse(response, apiOperation);
        ValidationReport.MessageContext.Builder contextBuilder = ValidationReport.MessageContext.create().in(ValidationReport.MessageContext.Location.RESPONSE).withApiOperation(apiOperation);
        if (apiResponse == null) {
            return ValidationReport.singleton(this.messages.get("validation.response.status.unknown", response.getStatus(), apiOperation.getApiPath().original())).withAdditionalContext(contextBuilder.build());
        }
        return this.validateResponseBody(response, apiResponse, apiOperation).merge(this.validateContentType(response, apiOperation)).merge(this.validateHeaders(response, apiResponse, apiOperation)).merge(this.validateCustom(response, apiOperation)).withAdditionalContext(contextBuilder.withResponseStatus(response.getStatus()).withApiResponseDefinition(apiResponse).build());
    }

    @Nullable
    private ApiResponse getApiResponse(Response response, ApiOperation apiOperation) {
        ApiResponse apiResponse = (ApiResponse)apiOperation.getOperation().getResponses().get((Object)Integer.toString(response.getStatus()));
        if (apiResponse == null) {
            return (ApiResponse)apiOperation.getOperation().getResponses().get((Object)"default");
        }
        return apiResponse;
    }

    @Nonnull
    private ValidationReport validateResponseBody(Response response, ApiResponse apiResponse, ApiOperation apiOperation) {
        if (apiResponse.getContent() == null) {
            return ValidationReport.empty();
        }
        Optional<String> mostSpecificMatch = ContentTypeUtils.findMostSpecificMatch(response, (Set<String>)apiResponse.getContent().keySet());
        if (!mostSpecificMatch.isPresent()) {
            return ValidationReport.empty();
        }
        io.swagger.v3.oas.models.media.MediaType apiMediaType = (io.swagger.v3.oas.models.media.MediaType)apiResponse.getContent().get((Object)mostSpecificMatch.get());
        if (apiMediaType.getSchema() == null) {
            return ValidationReport.empty();
        }
        Optional<Body> responseBody = response.getResponseBody();
        boolean hasBody = responseBody.map(Body::hasBody).orElse(false);
        if (!hasBody) {
            return ValidationReport.singleton(this.messages.get("validation.response.body.missing", apiOperation.getMethod(), apiOperation.getApiPath().original()));
        }
        if (ContentTypeUtils.isJsonContentType(response)) {
            return this.schemaValidator.validate(() -> ((Body)responseBody.get()).toJsonNode(), apiMediaType.getSchema(), "response.body");
        }
        if (ContentTypeUtils.isFormDataContentType(response)) {
            return this.schemaValidator.validate(() -> HttpParsingUtils.parseUrlEncodedFormDataBodyAsJsonNode(((Body)responseBody.get()).toString(StandardCharsets.UTF_8)), apiMediaType.getSchema(), "response.body");
        }
        if (response.getContentType().isPresent()) {
            log.info("Validation of '{}' not supported. Response body not validated.", (Object)response.getContentType().get());
        }
        return ValidationReport.empty();
    }

    @Nonnull
    private ValidationReport validateContentType(Response response, ApiOperation apiOperation) {
        MediaType responseMediaType;
        Optional<String> responseContentTypeHeader = response.getContentType();
        if (!responseContentTypeHeader.isPresent()) {
            return ValidationReport.empty();
        }
        try {
            responseMediaType = MediaType.parse((String)responseContentTypeHeader.get());
        }
        catch (IllegalArgumentException e) {
            return ValidationReport.singleton(this.messages.get("validation.response.contentType.invalid", responseContentTypeHeader.get()));
        }
        Collection<String> apiMediaTypes = this.getApiMediaTypesForResponse(response, apiOperation);
        if (apiMediaTypes.isEmpty() || ContentTypeUtils.containsGlobalAccept(apiMediaTypes)) {
            return ValidationReport.empty();
        }
        if (!ContentTypeUtils.matchesAny(responseMediaType, apiMediaTypes)) {
            return ValidationReport.singleton(this.messages.get("validation.response.contentType.notAllowed", responseContentTypeHeader.get(), apiMediaTypes));
        }
        return ValidationReport.empty();
    }

    @Nonnull
    private Collection<String> getApiMediaTypesForResponse(Response response, ApiOperation apiOperation) {
        ApiResponse apiResponse = this.getApiResponse(response, apiOperation);
        if (apiResponse == null) {
            return Collections.emptyList();
        }
        return ((Content)ObjectUtils.defaultIfNull((Object)apiResponse.getContent(), (Object)new Content())).keySet();
    }

    @Nonnull
    private ValidationReport validateHeaders(Response response, ApiResponse apiResponse, ApiOperation apiOperation) {
        Map apiHeaders = apiResponse.getHeaders();
        if (apiHeaders == null || apiHeaders.isEmpty()) {
            return ValidationReport.empty();
        }
        return apiHeaders.entrySet().stream().map(h -> this.validateHeader(apiOperation, (String)h.getKey(), (Header)h.getValue(), response.getHeaderValues((String)h.getKey()))).reduce(ValidationReport.empty(), ValidationReport::merge);
    }

    @Nonnull
    private ValidationReport validateHeader(ApiOperation apiOperation, String headerName, Header apiHeader, Collection<String> propertyValues) {
        if (propertyValues.isEmpty() && Boolean.TRUE.equals(apiHeader.getRequired())) {
            return ValidationReport.singleton(this.messages.get("validation.response.header.missing", headerName, apiOperation.getApiPath().original()));
        }
        return propertyValues.stream().map(v -> this.schemaValidator.validate((String)v, apiHeader.getSchema(), "response.header")).reduce(ValidationReport.empty(), ValidationReport::merge);
    }

    @Nonnull
    private ValidationReport validateCustom(Response response, ApiOperation apiOperation) {
        return this.customResponseValidators.stream().map(customResponseValidator -> customResponseValidator.validate(response, apiOperation)).reduce(ValidationReport.empty(), ValidationReport::merge);
    }
}

