/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.interaction.request;

import com.atlassian.oai.validator.interaction.request.CustomRequestValidator;
import com.atlassian.oai.validator.interaction.request.ParameterValidator;
import com.atlassian.oai.validator.interaction.request.RequestBodyValidator;
import com.atlassian.oai.validator.interaction.request.SecurityValidator;
import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.NormalisedPath;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.schema.SchemaValidator;
import com.atlassian.oai.validator.util.HttpAcceptUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Joiner;
import com.google.common.net.MediaType;
import io.swagger.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestValidator {
    private static final Logger log = LoggerFactory.getLogger(RequestValidator.class);
    private final MessageResolver messages;
    private final Components components;
    private final ParameterValidator parameterValidator;
    private final SecurityValidator securityValidator;
    private final RequestBodyValidator requestBodyValidator;
    private final List<CustomRequestValidator> customRequestValidators;

    public RequestValidator(SchemaValidator schemaValidator, MessageResolver messages, OpenAPI api, List<CustomRequestValidator> customRequestValidators) {
        this.messages = Objects.requireNonNull(messages, "A message resolver is required");
        this.components = (Components)ObjectUtils.defaultIfNull((Object)api.getComponents(), (Object)new Components());
        this.customRequestValidators = customRequestValidators;
        this.parameterValidator = new ParameterValidator(schemaValidator, messages);
        this.securityValidator = new SecurityValidator(messages, api);
        this.requestBodyValidator = new RequestBodyValidator(messages, schemaValidator);
    }

    @Nonnull
    public ValidationReport validateRequest(Request request, ApiOperation apiOperation) {
        Objects.requireNonNull(request, "A request is required");
        Objects.requireNonNull(apiOperation, "An API operation is required");
        ValidationReport.MessageContext context = ValidationReport.MessageContext.create().in(ValidationReport.MessageContext.Location.REQUEST).withApiOperation(apiOperation).withRequestPath(apiOperation.getRequestPath().original()).withRequestMethod(request.getMethod()).build();
        return this.securityValidator.validateSecurity(request, apiOperation).merge(this.validateContentType(request, apiOperation)).merge(this.validateAccepts(request, apiOperation)).merge(this.validateHeaders(request, apiOperation)).merge(this.validatePathParameters(apiOperation)).merge(this.requestBodyValidator.validateRequestBody(request, apiOperation.getOperation().getRequestBody())).merge(this.validateQueryParameters(request, apiOperation)).merge(this.validateDeepObjectQueryParameters(request, apiOperation)).merge(this.validateUnexpectedQueryParameters(request, apiOperation)).merge(this.validateCookieParameters(request, apiOperation)).merge(this.validateCustom(request, apiOperation)).withAdditionalContext(context);
    }

    @Nonnull
    private ValidationReport validateContentType(Request request, ApiOperation apiOperation) {
        return this.validateMediaTypes(request, "Content-Type", this.getConsumes(apiOperation), "validation.request.contentType.invalid", "validation.request.contentType.notAllowed");
    }

    @Nonnull
    private ValidationReport validateAccepts(Request request, ApiOperation apiOperation) {
        return this.validateMediaTypes(request, "Accept", this.getProduces(apiOperation), "validation.request.accept.invalid", "validation.request.accept.notAllowed");
    }

    @Nonnull
    private ValidationReport validateMediaTypes(Request request, String headerName, Collection<String> specMediaTypes, String invalidTypeKey, String notAllowedKey) {
        Collection requestHeaderValues = request.getHeaderValues(headerName).stream().flatMap(v -> HttpAcceptUtils.splitAcceptHeader(v).stream()).collect(Collectors.toList());
        if (requestHeaderValues.isEmpty()) {
            return ValidationReport.empty();
        }
        ArrayList<MediaType> requestMediaTypes = new ArrayList<MediaType>();
        for (String requestHeaderValue : requestHeaderValues) {
            try {
                requestMediaTypes.add(MediaType.parse((String)requestHeaderValue));
            }
            catch (IllegalArgumentException e) {
                return ValidationReport.singleton(this.messages.get(invalidTypeKey, requestHeaderValue));
            }
        }
        if (specMediaTypes.isEmpty()) {
            return ValidationReport.empty();
        }
        if (specMediaTypes.stream().allMatch("*/*"::equals)) {
            return ValidationReport.empty();
        }
        return specMediaTypes.stream().map(MediaType::parse).filter(specType -> requestMediaTypes.stream().anyMatch(requestType -> specType.withoutParameters().is(requestType.withoutParameters()))).findFirst().map(m -> ValidationReport.empty()).orElse(ValidationReport.singleton(this.messages.get(notAllowedKey, requestHeaderValues, specMediaTypes)));
    }

    @Nonnull
    private Collection<String> getConsumes(ApiOperation apiOperation) {
        if (apiOperation.getOperation().getRequestBody() == null) {
            return Collections.emptyList();
        }
        return (Collection)ObjectUtils.defaultIfNull((Object)apiOperation.getOperation().getRequestBody().getContent().keySet(), Collections.emptySet());
    }

    @Nonnull
    private Collection<String> getProduces(ApiOperation apiOperation) {
        return apiOperation.getOperation().getResponses().values().stream().filter(apiResponse -> apiResponse.getContent() != null).flatMap(apiResponse -> apiResponse.getContent().keySet().stream()).collect(Collectors.toSet());
    }

    @Nonnull
    private ValidationReport validatePathParameters(ApiOperation apiOperation) {
        ValidationReport validationReport = ValidationReport.empty();
        NormalisedPath requestPath = apiOperation.getRequestPath();
        for (int i = 0; i < apiOperation.getApiPath().numberOfParts(); ++i) {
            if (!apiOperation.getApiPath().hasParams(i)) continue;
            ValidationReport pathPartValidation = apiOperation.getApiPath().paramValues(i, requestPath.part(i)).entrySet().stream().map(param -> this.validatePathParameter(apiOperation, (String)param.getKey(), (Optional)param.getValue())).reduce(ValidationReport.empty(), ValidationReport::merge);
            validationReport = validationReport.merge(pathPartValidation);
        }
        return validationReport;
    }

    @Nonnull
    private ValidationReport validatePathParameter(ApiOperation apiOperation, String paramName, Optional<String> paramValue) {
        return ((List)ObjectUtils.defaultIfNull((Object)apiOperation.getOperation().getParameters(), Collections.emptyList())).stream().filter(RequestValidator::isPathParam).filter(p -> p.getName().equalsIgnoreCase(paramName)).findFirst().map(p -> this.parameterValidator.validate((String)paramValue.orElse(null), (Parameter)p)).orElse(ValidationReport.empty());
    }

    @Nonnull
    private ValidationReport validateQueryParameters(Request request, ApiOperation apiOperation) {
        return ((List)ObjectUtils.defaultIfNull((Object)apiOperation.getOperation().getParameters(), Collections.emptyList())).stream().filter(p -> RequestValidator.isQueryParam(p) && !RequestValidator.isDeepObjectParam(p)).map(p -> this.validateParameter(apiOperation, (Parameter)p, request.getQueryParameterValues(p.getName()), "validation.request.parameter.query.missing")).reduce(ValidationReport.empty(), ValidationReport::merge);
    }

    @Nonnull
    private ValidationReport validateDeepObjectQueryParameters(Request request, ApiOperation apiOperation) {
        return ((List)ObjectUtils.defaultIfNull((Object)apiOperation.getOperation().getParameters(), Collections.emptyList())).stream().filter(p -> RequestValidator.isQueryParam(p) && RequestValidator.isDeepObjectParam(p)).map(p -> this.validateDeepObjectQueryParameter(request, apiOperation, (Parameter)p)).reduce(ValidationReport.empty(), ValidationReport::merge);
    }

    @Nonnull
    private ValidationReport validateDeepObjectQueryParameter(Request request, ApiOperation apiOperation, Parameter parameter) {
        String deepObjectAsJson;
        String queryParam = parameter.getName();
        Pattern fieldPattern = Pattern.compile(String.format("%s\\[(\\S*)\\]", queryParam));
        HashMap deepObject = new HashMap();
        request.getQueryParameters().stream().map(qp -> fieldPattern.matcher((CharSequence)qp)).filter(matcher -> matcher.matches()).forEach(matcher -> deepObject.putIfAbsent(matcher.group(1), request.getQueryParameterValues(matcher.group(0)).iterator().next()));
        if (deepObject.isEmpty() && !Boolean.TRUE.equals(parameter.getRequired())) {
            return ValidationReport.empty();
        }
        try {
            deepObjectAsJson = Json.mapper().writeValueAsString(deepObject);
        }
        catch (JsonProcessingException e) {
            ValidationReport.MessageContext context = ValidationReport.MessageContext.create().withApiOperation(apiOperation).withParameter(parameter).build();
            return ValidationReport.singleton(this.messages.get("validation.request.parameter.query.unexpected", queryParam, apiOperation.getApiPath().original())).withAdditionalContext(context);
        }
        return this.validateParameter(apiOperation, parameter, Collections.singletonList(deepObjectAsJson), "validation.request.parameter.query.missing");
    }

    @Nonnull
    private ValidationReport validateUnexpectedQueryParameters(Request request, ApiOperation apiOperation) {
        Set allowedQueryParams = Stream.concat(((List)ObjectUtils.defaultIfNull((Object)apiOperation.getOperation().getParameters(), Collections.emptyList())).stream().filter(p -> RequestValidator.isQueryParam(p)).map(Parameter::getName), ((Map)ObjectUtils.defaultIfNull((Object)this.components.getSecuritySchemes(), Collections.emptyMap())).values().stream().filter(sc -> sc.getIn() != null && sc.getIn() == SecurityScheme.In.QUERY).map(SecurityScheme::getName)).collect(Collectors.toSet());
        return request.getQueryParameters().stream().map(queryParam -> this.validateUnexpectedQueryParameter(allowedQueryParams, (String)queryParam, apiOperation)).reduce(ValidationReport.empty(), ValidationReport::merge);
    }

    @Nonnull
    private ValidationReport validateUnexpectedQueryParameter(Set<String> allowedQueryParameters, String queryParam, ApiOperation apiOperation) {
        if (allowedQueryParameters.contains(queryParam)) {
            return ValidationReport.empty();
        }
        if (allowedQueryParameters.stream().anyMatch(p -> Pattern.matches(String.format("%s\\[(\\S*)\\]", p), queryParam))) {
            return ValidationReport.empty();
        }
        ValidationReport.MessageContext context = ValidationReport.MessageContext.create().withApiOperation(apiOperation).withParameter(new Parameter().name(queryParam).in("query")).build();
        return ValidationReport.singleton(this.messages.get("validation.request.parameter.query.unexpected", queryParam, apiOperation.getApiPath().original())).withAdditionalContext(context);
    }

    @Nonnull
    private ValidationReport validateHeaders(Request request, ApiOperation apiOperation) {
        return ((List)ObjectUtils.defaultIfNull((Object)apiOperation.getOperation().getParameters(), Collections.emptyList())).stream().filter(RequestValidator::isHeaderParam).map(p -> this.validateParameter(apiOperation, (Parameter)p, request.getHeaderValues(p.getName()), "validation.request.parameter.header.missing")).reduce(ValidationReport.empty(), ValidationReport::merge);
    }

    @Nonnull
    private ValidationReport validateCookieParameters(Request request, ApiOperation apiOperation) {
        Map<String, Collection<String>> cookieParams = this.getCookieParameterValues(request);
        return ((List)ObjectUtils.defaultIfNull((Object)apiOperation.getOperation().getParameters(), Collections.emptyList())).stream().filter(RequestValidator::isCookieParam).map(p -> this.validateParameter(apiOperation, (Parameter)p, (Collection)ObjectUtils.defaultIfNull(cookieParams.get(p.getName()), Collections.emptyList()), "validation.request.parameter.cookie.missing")).reduce(ValidationReport.empty(), ValidationReport::merge);
    }

    private Map<String, Collection<String>> getCookieParameterValues(Request request) {
        HashMap<String, Collection<String>> paramsMap = new HashMap<String, Collection<String>>();
        Collection<String> cookieValues = request.getHeaderValues("Cookie");
        if (!cookieValues.isEmpty()) {
            String[] cookieValuesArray;
            String cookieValuesStr = Joiner.on((String)",").join(cookieValues);
            for (String cookieVal : cookieValuesArray = cookieValuesStr.split("; ")) {
                int index = cookieVal.indexOf(61);
                if (index <= 0) continue;
                String name = cookieVal.substring(0, index);
                String value = cookieVal.substring(index + 1);
                paramsMap.putIfAbsent(name, new ArrayList());
                ((Collection)paramsMap.get(name)).add(value);
            }
        }
        return paramsMap;
    }

    @Nonnull
    private ValidationReport validateParameter(ApiOperation apiOperation, Parameter parameter, Collection<String> parameterValues, String missingKey) {
        ValidationReport.MessageContext context = ValidationReport.MessageContext.create().withParameter(parameter).build();
        if (parameterValues.isEmpty() && Boolean.TRUE.equals(parameter.getRequired())) {
            return ValidationReport.singleton(this.messages.get(missingKey, parameter.getName(), apiOperation.getApiPath().original())).withAdditionalContext(context);
        }
        if (parameterValues.size() > 1) {
            return this.parameterValidator.validate(parameterValues, parameter);
        }
        return parameterValues.stream().map(v -> this.parameterValidator.validate((String)v, parameter)).reduce(ValidationReport.empty(), ValidationReport::merge);
    }

    @Nonnull
    private ValidationReport validateCustom(Request request, ApiOperation apiOperation) {
        return this.customRequestValidators.stream().map(customValidator -> customValidator.validate(request, apiOperation)).reduce(ValidationReport.empty(), ValidationReport::merge);
    }

    private static boolean isPathParam(Parameter p) {
        return RequestValidator.isParam(p, "path");
    }

    private static boolean isQueryParam(Parameter p) {
        return RequestValidator.isParam(p, "query");
    }

    private static boolean isHeaderParam(Parameter p) {
        return RequestValidator.isParam(p, "header");
    }

    private static boolean isCookieParam(Parameter p) {
        return RequestValidator.isParam(p, "cookie");
    }

    private static boolean isDeepObjectParam(Parameter p) {
        return p != null && p.getStyle() != null && p.getStyle().equals((Object)Parameter.StyleEnum.DEEPOBJECT);
    }

    private static boolean isParam(Parameter p, String type) {
        return p != null && p.getIn() != null && p.getIn().equalsIgnoreCase(type);
    }
}

