/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.interaction.request;

import com.atlassian.oai.validator.model.Body;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.schema.SchemaValidator;
import com.atlassian.oai.validator.util.ContentTypeUtils;
import com.atlassian.oai.validator.util.HttpParsingUtils;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestBodyValidator {
    private static final Logger log = LoggerFactory.getLogger(RequestBodyValidator.class);
    private final MessageResolver messages;
    private final SchemaValidator schemaValidator;

    RequestBodyValidator(@Nullable MessageResolver messages, SchemaValidator schemaValidator) {
        this.schemaValidator = Objects.requireNonNull(schemaValidator, "A schema validator is required");
        this.messages = messages == null ? new MessageResolver() : messages;
    }

    @Nonnull
    ValidationReport validateRequestBody(Request request, @Nullable RequestBody apiRequestBodyDefinition) {
        Optional<Body> requestBody = request.getRequestBody();
        boolean hasBody = requestBody.map(Body::hasBody).orElse(false);
        if (apiRequestBodyDefinition == null) {
            if (hasBody) {
                return ValidationReport.singleton(this.messages.get("validation.request.body.unexpected", new Object[0]));
            }
            return ValidationReport.empty();
        }
        ValidationReport.MessageContext context = ValidationReport.MessageContext.create().withApiRequestBodyDefinition(apiRequestBodyDefinition).build();
        if (!hasBody) {
            if (Boolean.TRUE.equals(apiRequestBodyDefinition.getRequired())) {
                return ValidationReport.singleton(this.messages.get("validation.request.body.missing", new Object[0])).withAdditionalContext(context);
            }
            return ValidationReport.empty();
        }
        Optional<Pair<String, MediaType>> maybeApiMediaTypeForRequest = this.findApiMediaTypeForRequest(request, apiRequestBodyDefinition);
        if (!maybeApiMediaTypeForRequest.isPresent()) {
            return ValidationReport.empty();
        }
        context = ValidationReport.MessageContext.from(context).withMatchedApiContentType((String)maybeApiMediaTypeForRequest.get().getLeft()).build();
        if (ContentTypeUtils.isJsonContentType(request)) {
            return this.schemaValidator.validate(() -> ((Body)requestBody.get()).toJsonNode(), ((MediaType)maybeApiMediaTypeForRequest.get().getRight()).getSchema(), "request.body").withAdditionalContext(context);
        }
        if (ContentTypeUtils.isFormDataContentType(request)) {
            return this.schemaValidator.validate(() -> HttpParsingUtils.parseUrlEncodedFormDataBodyAsJsonNode(((Body)requestBody.get()).toString(StandardCharsets.UTF_8)), ((MediaType)maybeApiMediaTypeForRequest.get().getRight()).getSchema(), "request.body").withAdditionalContext(context);
        }
        log.info("Validation of '{}' not supported. Request body not validated.", maybeApiMediaTypeForRequest.get().getLeft());
        return ValidationReport.empty();
    }

    private Optional<Pair<String, MediaType>> findApiMediaTypeForRequest(Request request, @Nullable RequestBody apiRequestBodyDefinition) {
        return Optional.ofNullable(apiRequestBodyDefinition).map(RequestBody::getContent).flatMap(content -> ContentTypeUtils.findMostSpecificMatch(request, (Set<String>)content.keySet()).map(mostSpecificMatch -> Pair.of((Object)mostSpecificMatch, (Object)content.get(mostSpecificMatch))));
    }
}

