/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.interaction.request;

import com.atlassian.oai.validator.interaction.request.ArraySeparator;
import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.schema.SchemaValidator;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;

class ParameterValidator {
    private final SchemaValidator schemaValidator;
    private final MessageResolver messages;

    ParameterValidator(SchemaValidator schemaValidator, MessageResolver messages) {
        this.schemaValidator = Objects.requireNonNull(schemaValidator);
        this.messages = Objects.requireNonNull(messages);
    }

    ValidationReport validate(@Nullable String value, Parameter parameter) {
        Objects.requireNonNull(parameter);
        ValidationReport.MessageContext context = ValidationReport.MessageContext.create().withParameter(parameter).build();
        if (Boolean.TRUE.equals(parameter.getRequired())) {
            if (value == null || value.trim().isEmpty() && !this.emptyAllowed(parameter)) {
                return ValidationReport.singleton(this.messages.get("validation.request.parameter.missing", parameter.getName())).withAdditionalContext(context);
            }
        } else if (value == null || value.trim().isEmpty()) {
            return ValidationReport.empty();
        }
        if (parameter.getSchema() instanceof ArraySchema) {
            return this.validateArrayParam(value, parameter).withAdditionalContext(context);
        }
        return this.schemaValidator.validate(value, parameter.getSchema(), "request.parameter").withAdditionalContext(context);
    }

    ValidationReport validate(@Nullable Collection<String> values, Parameter parameter) {
        ValidationReport.MessageContext context = ValidationReport.MessageContext.create().withParameter(parameter).build();
        if (values == null) {
            if (Boolean.TRUE.equals(parameter.getRequired())) {
                return ValidationReport.singleton(this.messages.get("validation.request.parameter.missing", parameter.getName())).withAdditionalContext(context);
            }
            return ValidationReport.empty();
        }
        if (!(parameter.getSchema() instanceof ArraySchema)) {
            if (values.size() > 1) {
                return ValidationReport.singleton(this.messages.get("validation.request.parameter.collection.invalid", parameter.getName())).withAdditionalContext(context);
            }
            return this.schemaValidator.validate(values.iterator().next(), parameter.getSchema(), "request.parameter");
        }
        if (!ArraySeparator.from(parameter).isMultiValueParam()) {
            return ValidationReport.singleton(this.messages.get("validation.request.parameter.collection.invalidFormat", parameter.getName(), parameter.getStyle(), false)).withAdditionalContext(context);
        }
        return this.validateArrayParam(values, parameter).withAdditionalContext(context);
    }

    private ValidationReport validateArrayParam(String value, Parameter parameter) {
        return this.validateArrayParam(ArraySeparator.from(parameter).split(value), parameter);
    }

    private ValidationReport validateArrayParam(Collection<String> values, Parameter parameter) {
        ValidationReport report = Stream.of(this.validateMaxItems(values, parameter), this.validateMinItems(values, parameter), this.validateUniqueItems(values, parameter)).reduce(ValidationReport.empty(), ValidationReport::merge);
        if (parameter.getSchema().getEnum() != null && !parameter.getSchema().getEnum().isEmpty()) {
            HashSet enumValues = new HashSet(parameter.getSchema().getEnum());
            return values.stream().filter(v -> !enumValues.contains(v)).map(v -> ValidationReport.singleton(this.messages.get("validation.request.parameter.enum.invalid", v, parameter.getName(), parameter.getSchema().getEnum()))).reduce(report, ValidationReport::merge);
        }
        return values.stream().map(v -> this.schemaValidator.validate((String)v, ((ArraySchema)parameter.getSchema()).getItems(), "request.parameter")).reduce(report, ValidationReport::merge);
    }

    private ValidationReport validateUniqueItems(Collection<String> values, Parameter parameter) {
        if (Boolean.TRUE.equals(parameter.getSchema().getUniqueItems()) && values.stream().distinct().count() != (long)values.size()) {
            return ValidationReport.singleton(this.messages.get("validation.request.parameter.collection.duplicateItems", parameter.getName()));
        }
        return ValidationReport.empty();
    }

    private ValidationReport validateMinItems(Collection<String> values, Parameter parameter) {
        if (parameter.getSchema().getMinItems() != null && values.size() < parameter.getSchema().getMinItems()) {
            return ValidationReport.singleton(this.messages.get("validation.request.parameter.collection.tooFewItems", parameter.getName(), parameter.getSchema().getMinItems(), values.size()));
        }
        return ValidationReport.empty();
    }

    private ValidationReport validateMaxItems(Collection<String> values, Parameter parameter) {
        if (parameter.getSchema().getMaxItems() != null && values.size() > parameter.getSchema().getMaxItems()) {
            return ValidationReport.singleton(this.messages.get("validation.request.parameter.collection.tooManyItems", parameter.getName(), parameter.getSchema().getMaxItems(), values.size()));
        }
        return ValidationReport.empty();
    }

    private boolean emptyAllowed(Parameter parameter) {
        return Boolean.TRUE.equals(parameter.getAllowEmptyValue()) && "query".equalsIgnoreCase(parameter.getIn()) && parameter.getSchema() instanceof StringSchema || parameter.getSchema() instanceof ArraySchema;
    }
}

