/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator;

import com.atlassian.oai.validator.interaction.ApiOperationResolver;
import com.atlassian.oai.validator.interaction.request.CustomRequestValidator;
import com.atlassian.oai.validator.interaction.request.RequestValidator;
import com.atlassian.oai.validator.interaction.response.CustomResponseValidator;
import com.atlassian.oai.validator.interaction.response.ResponseValidator;
import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.ApiOperationMatch;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.report.LevelResolver;
import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.schema.SchemaValidator;
import com.atlassian.oai.validator.util.OpenApiLoader;
import com.atlassian.oai.validator.util.StringUtils;
import com.atlassian.oai.validator.whitelist.NamedWhitelistRule;
import com.atlassian.oai.validator.whitelist.ValidationErrorsWhitelist;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;

public class OpenApiInteractionValidator {
    private final MessageResolver messages;
    private final ApiOperationResolver apiOperationResolver;
    private final RequestValidator requestValidator;
    private final ResponseValidator responseValidator;
    private final ValidationErrorsWhitelist whitelist;

    public static Builder createFor(@Nonnull String specUrlOrPayload) {
        return new Builder().withApiSpecification(specUrlOrPayload);
    }

    public static Builder createForInlineApiSpecification(@Nonnull String specAsString) {
        return new Builder().withInlineApiSpecification(specAsString);
    }

    public static Builder createForSpecificationUrl(@Nonnull String specUrl) {
        return new Builder().withApiSpecificationUrl(specUrl);
    }

    public static Builder createFor(@Nonnull OpenAPI api) {
        return new Builder().withApi(api);
    }

    private OpenApiInteractionValidator(@Nonnull OpenAPI api, @Nullable String basePathOverride, @Nonnull MessageResolver messages, @Nonnull ValidationErrorsWhitelist whitelist, @Nonnull List<CustomRequestValidator> customRequestValidators, @Nonnull List<CustomResponseValidator> customResponseValidators) {
        this.messages = messages;
        this.apiOperationResolver = new ApiOperationResolver(api, basePathOverride);
        SchemaValidator schemaValidator = new SchemaValidator(api, messages);
        this.requestValidator = new RequestValidator(schemaValidator, messages, api, customRequestValidators);
        this.responseValidator = new ResponseValidator(schemaValidator, messages, api, customResponseValidators);
        this.whitelist = whitelist;
    }

    @Nonnull
    public ValidationReport validate(@Nonnull Request request, @Nonnull Response response) {
        Objects.requireNonNull(request, "A request is required");
        Objects.requireNonNull(response, "A response is required");
        return this.validateOnApiOperation(request.getPath(), request.getMethod(), apiOperation -> this.requestValidator.validateRequest(request, (ApiOperation)apiOperation).merge(this.responseValidator.validateResponse(response, (ApiOperation)apiOperation)), (apiOperation, report) -> this.withWhitelistApplied((ValidationReport)report, (ApiOperation)apiOperation, request, response));
    }

    @Nonnull
    public ValidationReport validateRequest(@Nonnull Request request) {
        Objects.requireNonNull(request, "A request is required");
        return this.validateOnApiOperation(request.getPath(), request.getMethod(), apiOperation -> this.requestValidator.validateRequest(request, (ApiOperation)apiOperation), (apiOperation, report) -> this.withWhitelistApplied((ValidationReport)report, (ApiOperation)apiOperation, request, null));
    }

    @Nonnull
    public ValidationReport validateResponse(@Nonnull String path, @Nonnull Request.Method method, @Nonnull Response response) {
        Objects.requireNonNull(path, "A path is required");
        Objects.requireNonNull(method, "A method is required");
        Objects.requireNonNull(response, "A response is required");
        return this.validateOnApiOperation(path, method, apiOperation -> this.responseValidator.validateResponse(response, (ApiOperation)apiOperation), (apiOperation, report) -> this.withWhitelistApplied((ValidationReport)report, (ApiOperation)apiOperation, null, response));
    }

    private ValidationReport validateOnApiOperation(@Nonnull String path, @Nonnull Request.Method method, @Nonnull Function<ApiOperation, ValidationReport> validationFunction, @Nonnull BiFunction<ApiOperation, ValidationReport, ValidationReport> whitelistingFunction) {
        ValidationReport.MessageContext context = ValidationReport.MessageContext.create().withRequestPath(path).withRequestMethod(method).build();
        ApiOperationMatch apiOperationMatch = this.apiOperationResolver.findApiOperation(path, method);
        if (!apiOperationMatch.isPathFound()) {
            return whitelistingFunction.apply(null, ValidationReport.singleton(this.messages.get("validation.request.path.missing", path)).withAdditionalContext(context));
        }
        if (!apiOperationMatch.isOperationAllowed()) {
            return whitelistingFunction.apply(null, ValidationReport.singleton(this.messages.get("validation.request.operation.notAllowed", new Object[]{method, path})).withAdditionalContext(context));
        }
        ApiOperation apiOperation = apiOperationMatch.getApiOperation();
        return validationFunction.andThen(report -> (ValidationReport)whitelistingFunction.apply(apiOperation, (ValidationReport)report)).apply(apiOperation).withAdditionalContext(context);
    }

    private ValidationReport withWhitelistApplied(ValidationReport report, @Nullable ApiOperation operation, @Nullable Request request, @Nullable Response response) {
        return ValidationReport.from(report.getMessages().stream().map(message -> this.whitelist.whitelistedBy((ValidationReport.Message)message, operation, request, response).map(rule -> message.withLevel(ValidationReport.Level.IGNORE).withAdditionalContext(ValidationReport.MessageContext.create().withAppliedWhitelistRule((NamedWhitelistRule)rule).build())).orElse((ValidationReport.Message)message)).collect(Collectors.toList()));
    }

    public static class ApiLoadException
    extends IllegalArgumentException {
        private final String specUrlOrPayload;
        private final List<String> parseMessages;

        public ApiLoadException(String specUrlOrPayload, @Nullable SwaggerParseResult parseResult) {
            super("Unable to load API spec from provided URL or payload");
            this.specUrlOrPayload = specUrlOrPayload;
            this.parseMessages = parseResult != null ? (List<Object>)ObjectUtils.defaultIfNull((Object)parseResult.getMessages(), Collections.emptyList()) : Collections.emptyList();
        }

        public ApiLoadException(String specUrlOrPayload, Throwable cause) {
            super("Unable to load API spec from provided URL or payload", cause);
            this.specUrlOrPayload = specUrlOrPayload;
            this.parseMessages = Collections.emptyList();
        }

        @Override
        public String getMessage() {
            if (this.parseMessages.isEmpty()) {
                return super.getMessage();
            }
            return super.getMessage() + ":\n\t- " + String.join((CharSequence)"\n\t- ", this.parseMessages);
        }

        public List<String> getParseMessages() {
            return this.parseMessages;
        }

        public String getSpecUrlOrPayload() {
            return this.specUrlOrPayload;
        }
    }

    public static class Builder {
        private SpecSource specSource;
        private String basePathOverride;
        private LevelResolver levelResolver = LevelResolver.defaultResolver();
        private List<AuthorizationValue> authData;
        private ValidationErrorsWhitelist whitelist = ValidationErrorsWhitelist.create();
        private final List<CustomRequestValidator> customRequestValidators = new ArrayList<CustomRequestValidator>();
        private final List<CustomResponseValidator> customResponseValidators = new ArrayList<CustomResponseValidator>();
        private OpenAPI api;

        @Deprecated
        public Builder withSwaggerJsonUrl(String specUrlOrPayload) {
            return this.withApiSpecification(specUrlOrPayload);
        }

        @Deprecated
        public Builder withApiSpecification(String specUrlOrPayload) {
            StringUtils.requireNonEmpty(specUrlOrPayload, "A specification URL or payload is required");
            this.specSource = SpecSource.unknown(specUrlOrPayload);
            return this;
        }

        public Builder withInlineApiSpecification(String inlineSpecPayload) {
            StringUtils.requireNonEmpty(inlineSpecPayload, "A specification payload is required");
            this.specSource = SpecSource.inline(inlineSpecPayload);
            return this;
        }

        public Builder withApiSpecificationUrl(String specUrl) {
            StringUtils.requireNonEmpty(specUrl, "A specification URL is required");
            this.specSource = SpecSource.specUrl(specUrl);
            return this;
        }

        public Builder withApi(OpenAPI api) {
            Objects.requireNonNull(api, "An API is required");
            this.api = api;
            return this;
        }

        public Builder withBasePathOverride(String basePathOverride) {
            this.basePathOverride = basePathOverride;
            return this;
        }

        public Builder withLevelResolver(LevelResolver levelResolver) {
            this.levelResolver = levelResolver;
            return this;
        }

        public Builder withWhitelist(ValidationErrorsWhitelist whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public Builder withAuthHeaderData(String key, String value) {
            Objects.requireNonNull(key, "A key for the auth header is required");
            this.authData = Collections.singletonList(new AuthorizationValue(key, value, "header"));
            return this;
        }

        public Builder withCustomRequestValidation(CustomRequestValidator validator) {
            Objects.requireNonNull(validator, "A validator is required");
            this.customRequestValidators.add(validator);
            return this;
        }

        public Builder withCustomResponseValidation(CustomResponseValidator validator) {
            Objects.requireNonNull(validator, "A validator is required");
            this.customResponseValidators.add(validator);
            return this;
        }

        public OpenApiInteractionValidator build() {
            if (this.api == null) {
                this.api = new OpenApiLoader().loadApi(this.specSource, this.authData);
            }
            return new OpenApiInteractionValidator(this.api, this.basePathOverride, new MessageResolver(this.levelResolver), this.whitelist, this.customRequestValidators, this.customResponseValidators);
        }
    }

    public static class SpecSource {
        @Nullable
        private final String value;
        @Nonnull
        private final Type type;

        private static SpecSource unknown(String specUrlOrPayload) {
            return new SpecSource(specUrlOrPayload, Type.UNKNOWN);
        }

        private static SpecSource inline(String inlineApiSpec) {
            return new SpecSource(inlineApiSpec, Type.INLINE_SPEC);
        }

        private static SpecSource specUrl(String specUrl) {
            return new SpecSource(specUrl, Type.SPEC_URL);
        }

        private SpecSource(String value, Type type) {
            this.value = value;
            this.type = type;
        }

        public boolean isInlineSpecification() {
            return this.type == Type.INLINE_SPEC;
        }

        public boolean isSpecUrl() {
            return this.type == Type.SPEC_URL;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        private static enum Type {
            INLINE_SPEC,
            SPEC_URL,
            UNKNOWN;

        }
    }
}

