/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.profile.ui.client;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.util.AdminServicesUtil;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.identity.user.profile.ui.client.UserProfileUIException;
import org.wso2.carbon.user.core.UserStoreException;

public class UserProfileUIUtil {
    private static final Log log = LogFactory.getLog(UserProfileUIUtil.class);
    private static final String ENCRYPT_USERNAME_IN_URL = "encryptUsernameInUrl";
    private static final String bypassRoleName = "Internal/system";

    public static String getEncryptedAndBase64encodedUsername(String username) throws UserProfileUIException {
        String encryptedAndBase64EncodedUsername;
        block4: {
            encryptedAndBase64EncodedUsername = null;
            try {
                if (!StringUtils.isNotBlank((String)username)) break block4;
                boolean isUsernameEncryptionEnabled = UserProfileUIUtil.isUsernameEncryptionEnabled();
                if (isUsernameEncryptionEnabled) {
                    encryptedAndBase64EncodedUsername = CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(username.getBytes());
                    break block4;
                }
                return username;
            }
            catch (CryptoException e) {
                String message = String.format("Error while trying to encrypt the username : '%s' ", username);
                log.error((Object)message, (Throwable)e);
                throw new UserProfileUIException(message, e);
            }
            catch (CarbonException | UserStoreException e) {
                String message = "Error while trying to get UserRealm";
                log.error((Object)message, e);
                throw new UserProfileUIException(message, e);
            }
        }
        return encryptedAndBase64EncodedUsername;
    }

    public static String getDecryptedUsername(String encryptedAndBase64EncodedUsername) throws UserProfileUIException {
        try {
            boolean isUsernameEncryptionEnabled = UserProfileUIUtil.isUsernameEncryptionEnabled();
            if (isUsernameEncryptionEnabled) {
                return new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(encryptedAndBase64EncodedUsername));
            }
            return encryptedAndBase64EncodedUsername;
        }
        catch (CryptoException e) {
            String message = String.format("Error while trying to decrypt the username : '%s' ", encryptedAndBase64EncodedUsername);
            log.error((Object)message, (Throwable)e);
            throw new UserProfileUIException(message, e);
        }
        catch (CarbonException | UserStoreException e) {
            String message = "Error while trying to get UserRealm";
            log.error((Object)message, e);
            throw new UserProfileUIException(message, e);
        }
    }

    private static boolean isUsernameEncryptionEnabled() throws CarbonException, UserStoreException {
        return Boolean.parseBoolean((String)AdminServicesUtil.getUserRealm().getRealmConfiguration().getRealmProperties().get(ENCRYPT_USERNAME_IN_URL));
    }

    public static boolean isAccountLockable(String userName) throws CarbonException, UserStoreException {
        boolean isLockable = true;
        String[] roleList = AdminServicesUtil.getUserRealm().getUserStoreManager().getRoleListOfUser(userName);
        if (roleList != null) {
            for (String roleName : roleList) {
                if (!roleName.equals(bypassRoleName)) continue;
                isLockable = false;
                break;
            }
        }
        return isLockable;
    }
}

