/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.profile.ui.client;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.user.profile.stub.UserProfileMgtServiceStub;
import org.wso2.carbon.identity.user.profile.stub.types.UserFieldDTO;
import org.wso2.carbon.identity.user.profile.stub.types.UserProfileDTO;

public class UserProfileCient {
    private static final Log log = LogFactory.getLog(UserProfileCient.class);
    private UserProfileMgtServiceStub stub = null;
    private String serviceEndPoint = null;

    public UserProfileCient(String cookie, String url, ConfigurationContext configContext) throws Exception {
        try {
            this.serviceEndPoint = url + "UserProfileMgtService";
            this.stub = new UserProfileMgtServiceStub(configContext, this.serviceEndPoint);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public static String extractDomainFromName(String nameWithDomain) {
        if (nameWithDomain.indexOf("/") > 0) {
            String[] names = nameWithDomain.split("/");
            return names[0];
        }
        return null;
    }

    public void setUserProfile(String username, UserProfileDTO profile) throws Exception {
        try {
            this.stub.setUserProfile(username, profile);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public void deleteUserProfile(String username, String profileName) throws Exception {
        try {
            this.stub.deleteUserProfile(username, profileName);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public UserProfileDTO[] getUserProfiles(String userName) throws Exception {
        try {
            return this.stub.getUserProfiles(userName);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public UserProfileDTO getProfileFieldsForInternalStore() throws Exception {
        try {
            return this.stub.getProfileFieldsForInternalStore();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public boolean isReadOnlyUserStore() throws Exception {
        try {
            return this.stub.isReadOnlyUserStore();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public UserProfileDTO getUserProfile(String username, String profile) throws Exception {
        try {
            return this.stub.getUserProfile(username, profile);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public UserFieldDTO[] getOrderedUserFields(UserFieldDTO[] userFields) throws Exception {
        Arrays.sort(userFields, new UserFieldComparator());
        return userFields;
    }

    public boolean isAddProfileEnabled() throws Exception {
        try {
            return this.stub.isAddProfileEnabled();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public boolean isAddProfileEnabledForDomain(String domain) throws Exception {
        try {
            return this.stub.isAddProfileEnabledForDomain(domain);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    class UserFieldComparator
    implements Comparator<UserFieldDTO> {
        UserFieldComparator() {
        }

        @Override
        public int compare(UserFieldDTO filed1, UserFieldDTO filed2) {
            if (filed1.getDisplayOrder() == 0) {
                filed1.setDisplayOrder(Integer.MAX_VALUE);
            }
            if (filed2.getDisplayOrder() == 0) {
                filed2.setDisplayOrder(Integer.MAX_VALUE);
            }
            if (filed1.getDisplayOrder() < filed2.getDisplayOrder()) {
                return -1;
            }
            if (filed1.getDisplayOrder() == filed2.getDisplayOrder()) {
                return 0;
            }
            if (filed1.getDisplayOrder() > filed2.getDisplayOrder()) {
                return 1;
            }
            return 0;
        }
    }
}

