/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.ui.util;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthConsumerAppDTO;

public class OAuthUIUtil {
    private static final Log log = LogFactory.getLog(OAuthUIUtil.class);
    private static final String SCOPE_VALIDATOR_PREFIX = "scope_validator_";
    private static final String TOKEN_TYPE_PREFIX = "token_type_";

    private OAuthUIUtil() {
    }

    public static String getAbsoluteEndpointURL(String endpointType, String oauthVersion, HttpServletRequest request) {
        String endpointURL = null;
        endpointURL = oauthVersion.equals("OAuth-1.0a") ? IdentityUtil.getServerURL((String)("/oauth" + endpointType), (boolean)true, (boolean)true) : IdentityUtil.getServerURL((String)("/oauth2" + endpointType), (boolean)true, (boolean)false);
        return endpointURL;
    }

    public static OAuthConsumerAppDTO[] doPaging(int pageNumber, OAuthConsumerAppDTO[] oAuthConsumerAppDTOSet) {
        int itemsPerPageInt = 10;
        int startIndex = pageNumber * itemsPerPageInt;
        int endIndex = (pageNumber + 1) * itemsPerPageInt;
        OAuthConsumerAppDTO[] returnedOAuthConsumerSet = itemsPerPageInt < oAuthConsumerAppDTOSet.length ? new OAuthConsumerAppDTO[itemsPerPageInt] : new OAuthConsumerAppDTO[oAuthConsumerAppDTOSet.length];
        int i = startIndex;
        int j = 0;
        while (i < endIndex && i < oAuthConsumerAppDTOSet.length) {
            returnedOAuthConsumerSet[j] = oAuthConsumerAppDTOSet[i];
            ++i;
            ++j;
        }
        return returnedOAuthConsumerSet;
    }

    public static boolean isValidURI(String uri) {
        try {
            new URI(uri);
            return true;
        }
        catch (URISyntaxException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Malformed URL: " + uri), (Throwable)e);
            }
            return false;
        }
    }

    public static boolean isAudienceNotEmpty(String[] audiences) {
        if (ArrayUtils.isEmpty((Object[])audiences)) {
            return false;
        }
        for (String audience : audiences) {
            if (!StringUtils.isNotEmpty((String)audience) || StringUtils.equalsIgnoreCase((String)audience, (String)"null")) continue;
            return true;
        }
        return false;
    }

    public static String getScopeValidatorId(String name) {
        return SCOPE_VALIDATOR_PREFIX + name.replaceAll(" ", "_");
    }

    public static String getTokenTypeId(String type) {
        return TOKEN_TYPE_PREFIX + type.replaceAll(" ", "_");
    }
}

