/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.ui.internal;

import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.http.helper.ContextPathServletAdaptor;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.identity.oauth.ui.OAuthServlet;
import org.wso2.carbon.identity.oauth.ui.internal.OAuthUIServiceComponentHolder;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="identity.provider.oauth.ui.component", immediate=true)
public class OAuthUIServiceComponent {
    public static final String OAUTH_URL = "/oauth";
    private static final Log log = LogFactory.getLog(OAuthUIServiceComponent.class);

    protected void activate(ComponentContext context) {
        log.debug((Object)"Activating Identity OAuth UI bundle.");
        HttpService httpService = OAuthUIServiceComponentHolder.getInstance().getHttpService();
        try {
            ContextPathServletAdaptor oauth1aServlet = new ContextPathServletAdaptor((Servlet)new OAuthServlet(), OAUTH_URL);
            httpService.registerServlet(OAUTH_URL, (Servlet)oauth1aServlet, null, null);
            log.debug((Object)"Successfully registered an instance of OAuthServlet");
        }
        catch (Exception e) {
            String errMsg = "Error when registering an OAuth endpoint via the HttpService.";
            log.error((Object)errMsg, (Throwable)e);
            throw new RuntimeException(errMsg, e);
        }
        log.debug((Object)"Successfully activated Identity OAuth UI bundle.");
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Identity OAuth UI bundle is deactivated");
    }

    @Reference(name="osgi.http.service", service=HttpService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetHttpService")
    protected void setHttpService(HttpService httpService) {
        OAuthUIServiceComponentHolder.getInstance().setHttpService(httpService);
    }

    protected void unsetHttpService(HttpService httpService) {
        httpService.unregister(OAUTH_URL);
        OAuthUIServiceComponentHolder.getInstance().setHttpService(null);
    }

    @Reference(name="configuration.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        OAuthUIServiceComponentHolder.getInstance().setConfigurationContextService(configurationContextService);
        log.debug((Object)"ConfigurationContextService Instance was set.");
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        OAuthUIServiceComponentHolder.getInstance().setConfigurationContextService(null);
        log.debug((Object)"ConfigurationContextService Instance was unset.");
    }

    @Reference(name="server.configuration.service", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(ServerConfigurationService serverConfigService) {
        OAuthUIServiceComponentHolder.getInstance().setServerConfigurationService(serverConfigService);
        log.debug((Object)"ServerConfigurationService instance was set.");
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigService) {
        OAuthUIServiceComponentHolder.getInstance().setServerConfigurationService(null);
        log.debug((Object)"ServerConfigurationService instance was unset.");
    }
}

