/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.ui.client;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang.ArrayUtils;
import org.wso2.carbon.identity.oauth.stub.OAuthAdminServiceIdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.stub.OAuthAdminServiceStub;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthIDTokenAlgorithmDTO;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthRevocationRequestDTO;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthRevocationResponseDTO;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthTokenExpiryTimeDTO;
import org.wso2.carbon.identity.oauth.stub.dto.ScopeDTO;
import org.wso2.carbon.identity.oauth.stub.dto.TokenBindingMetaDataDTO;

public class OAuthAdminClient {
    private static String[] allowedGrantTypes = null;
    private static String[] scopeValidators = null;
    private String[] supportedTokenTypes = ArrayUtils.EMPTY_STRING_ARRAY;
    private OAuthAdminServiceStub stub;

    public OAuthAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "OAuthAdminService";
        this.stub = new OAuthAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public OAuthConsumerAppDTO[] getAllOAuthApplicationData() throws Exception {
        return this.stub.getAllOAuthApplicationData();
    }

    public OAuthConsumerAppDTO getOAuthApplicationData(String consumerkey) throws Exception {
        return this.stub.getOAuthApplicationData(consumerkey);
    }

    public OAuthConsumerAppDTO getOAuthApplicationDataByAppName(String appName) throws Exception {
        return this.stub.getOAuthApplicationDataByAppName(appName);
    }

    public void registerOAuthApplicationData(OAuthConsumerAppDTO application) throws Exception {
        this.stub.registerOAuthApplicationData(application);
    }

    public OAuthConsumerAppDTO registerAndRetrieveOAuthApplicationData(OAuthConsumerAppDTO application) throws Exception {
        return this.stub.registerAndRetrieveOAuthApplicationData(application);
    }

    public OAuthConsumerAppDTO getOAuthApplicationDataByName(String applicationName) throws Exception {
        OAuthConsumerAppDTO[] dtos = this.stub.getAllOAuthApplicationData();
        if (dtos != null && dtos.length > 0) {
            for (OAuthConsumerAppDTO dto : dtos) {
                if (!applicationName.equals(dto.getApplicationName())) continue;
                return dto;
            }
        }
        return null;
    }

    public void removeOAuthApplicationData(String consumerkey) throws Exception {
        this.stub.removeOAuthApplicationData(consumerkey);
    }

    public void updateOAuthApplicationData(OAuthConsumerAppDTO consumerAppDTO) throws Exception {
        this.stub.updateConsumerApplication(consumerAppDTO);
    }

    public OAuthConsumerAppDTO[] getAppsAuthorizedByUser() throws Exception {
        return this.stub.getAppsAuthorizedByUser();
    }

    public OAuthRevocationResponseDTO revokeAuthzForAppsByRessourceOwner(OAuthRevocationRequestDTO reqDTO) throws Exception {
        return this.stub.revokeAuthzForAppsByResoureOwner(reqDTO);
    }

    public boolean isPKCESupportedEnabled() throws Exception {
        return this.stub.isPKCESupportEnabled();
    }

    public boolean isHashDisabled() throws Exception {
        return this.stub.isHashDisabled();
    }

    public String[] getAllowedOAuthGrantTypes() throws Exception {
        if (allowedGrantTypes == null) {
            allowedGrantTypes = this.stub.getAllowedGrantTypes();
        }
        return allowedGrantTypes;
    }

    public void regenerateSecretKey(String consumerkey) throws Exception {
        this.stub.updateOauthSecretKey(consumerkey);
    }

    public OAuthConsumerAppDTO regenerateAndRetrieveOauthSecretKey(String consumerKey) throws Exception {
        return this.stub.updateAndRetrieveOauthSecretKey(consumerKey);
    }

    public String getOauthApplicationState(String consumerKey) throws Exception {
        return this.stub.getOauthApplicationState(consumerKey);
    }

    public void updateOauthApplicationState(String consumerKey, String newState) throws Exception {
        this.stub.updateConsumerAppState(consumerKey, newState);
    }

    public OAuthTokenExpiryTimeDTO getOAuthTokenExpiryTimeDTO() throws RemoteException {
        return this.stub.getTokenExpiryTimes();
    }

    public void addScope(String scope, String[] claims) throws RemoteException, OAuthAdminServiceIdentityOAuthAdminException {
        this.stub.addScope(scope, claims);
    }

    public ScopeDTO[] getScopes() throws OAuthAdminServiceIdentityOAuthAdminException, RemoteException {
        return this.stub.getScopes();
    }

    public String[] getScopeNames() throws OAuthAdminServiceIdentityOAuthAdminException, RemoteException {
        return this.stub.getScopeNames();
    }

    public String[] getClaims(String scope) throws OAuthAdminServiceIdentityOAuthAdminException, RemoteException {
        return this.stub.getClaims(scope);
    }

    public boolean isScopeExist(String scope) throws OAuthAdminServiceIdentityOAuthAdminException, RemoteException {
        return this.stub.isScopeExist(scope);
    }

    public void deleteScope(String scope) throws OAuthAdminServiceIdentityOAuthAdminException, RemoteException {
        this.stub.deleteScope(scope);
    }

    public void updateScope(String scope, String[] addClaims, String[] deleteClaims) throws RemoteException, OAuthAdminServiceIdentityOAuthAdminException {
        this.stub.updateScope(scope, addClaims, deleteClaims);
    }

    public String[] getAllowedScopeValidators() throws RemoteException {
        if (scopeValidators == null && (scopeValidators = this.stub.getAllowedScopeValidators()) == null) {
            scopeValidators = new String[0];
        }
        return scopeValidators;
    }

    public String[] getSupportedTokenTypes() throws RemoteException {
        if (this.stub.getSupportedTokenTypes() != null) {
            this.supportedTokenTypes = this.stub.getSupportedTokenTypes();
        }
        return this.supportedTokenTypes;
    }

    public OAuthIDTokenAlgorithmDTO getSupportedIDTokenAlgorithms() throws RemoteException {
        return this.stub.getSupportedIDTokenAlgorithms();
    }

    public boolean isRefreshTokenRenewalEnabled() throws RemoteException {
        return this.stub.isRefreshTokenRenewalEnabled();
    }

    public TokenBindingMetaDataDTO[] getSupportedTokenBindingsMetaData() throws RemoteException {
        return this.stub.getSupportedTokenBindingsMetaData();
    }
}

