/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.owasp.encoder.Encode;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.stub.OAuthServiceAuthenticationException;
import org.wso2.carbon.identity.oauth.stub.types.Parameters;
import org.wso2.carbon.identity.oauth.ui.client.OAuthServiceClient;
import org.wso2.carbon.identity.oauth.ui.internal.OAuthUIServiceComponentHolder;
import org.wso2.carbon.ui.CarbonUIUtil;

public class OAuthServlet
extends HttpServlet {
    private static final long serialVersionUID = -7309826651165509449L;
    private static final Log log = LogFactory.getLog(OAuthServlet.class);

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestType = req.getPathInfo();
        Parameters params = this.populateOauthConsumerData(req);
        Parameters token = null;
        String oauthToken = null;
        String oauthTokenSecret = null;
        String oauthCallbackConfirmed = null;
        try {
            String backendServerURL = CarbonUIUtil.getServerURL((ServerConfigurationService)OAuthUIServiceComponentHolder.getInstance().getServerConfigurationService());
            ConfigurationContext configContext = OAuthUIServiceComponentHolder.getInstance().getConfigurationContextService().getServerConfigContext();
            OAuthServiceClient client = new OAuthServiceClient(backendServerURL, configContext);
            if (requestType.indexOf("/request-token") > -1) {
                String reqToken = null;
                PrintWriter out = resp.getWriter();
                token = client.getOauthRequestToken(params);
                oauthToken = token.getOauthToken();
                oauthTokenSecret = token.getOauthTokenSecret();
                oauthCallbackConfirmed = "true";
                reqToken = "oauth_token=" + Encode.forUriComponent((String)oauthToken) + "&" + "oauth_token_secret" + "=" + Encode.forUriComponent((String)oauthTokenSecret) + "&" + "oauth_callback_confirmed" + "=" + Encode.forUriComponent((String)oauthCallbackConfirmed);
                out.write(reqToken);
                out.close();
                resp.setStatus(200);
            } else if (requestType.indexOf("/authorize-token") > -1) {
                String userName = req.getParameter("oauth_user_name");
                String password = req.getParameter("oauth_user_password");
                String tokenFromSession = (String)req.getSession().getAttribute("oauth_req_token");
                if (userName == null || password == null || tokenFromSession == null) {
                    Parameters metadata = client.getScope(params.getOauthToken());
                    req.getSession().setAttribute("oauth_req_token", (Object)params.getOauthToken());
                    req.getSession().setAttribute("oauth_scope", (Object)metadata.getScope());
                    req.getSession().setAttribute("oauth_app_name", (Object)metadata.getAppName());
                    resp.sendRedirect(IdentityUtil.getServerURL((String)"/carbon/oauth/oauth-login.jsp", (boolean)false, (boolean)true));
                }
            } else if (requestType.indexOf("/access-token") > -1) {
                String accessToken = null;
                PrintWriter out = resp.getWriter();
                token = client.getAccessToken(params);
                accessToken = "oauth_token=" + Encode.forUriComponent((String)token.getOauthToken()) + "&" + "oauth_token_secret" + "=" + Encode.forUriComponent((String)token.getOauthTokenSecret());
                out.write(accessToken);
                out.close();
                resp.setStatus(200);
            }
        }
        catch (OAuthServiceAuthenticationException e) {
            log.debug((Object)e);
            resp.setStatus(401);
            resp.setHeader("WWW-Authenticate", "Basic realm=\"WSO2 IS\"");
        }
        catch (Exception e) {
            log.error((Object)e);
            resp.setStatus(400);
        }
    }

    private Parameters populateOauthConsumerData(HttpServletRequest request) {
        String scope;
        String authHeader = null;
        Parameters params = null;
        String splitChar = ",";
        boolean noAuthorizationHeader = false;
        authHeader = request.getHeader("Authorization");
        params = new Parameters();
        if (authHeader == null) {
            noAuthorizationHeader = true;
            authHeader = request.getQueryString();
            splitChar = "&";
        }
        StringBuilder nonAuthParams = new StringBuilder();
        if (authHeader != null) {
            String[] headers;
            if (authHeader.startsWith("OAuth ") || authHeader.startsWith("oauth ")) {
                authHeader = authHeader.substring(authHeader.indexOf("o"));
            }
            if ((headers = authHeader.split(splitChar)) != null && headers.length > 0) {
                for (int i = 0; i < headers.length; ++i) {
                    String[] elements = headers[i].split("=");
                    if (elements == null || elements.length <= 0) continue;
                    if ("oauth_consumer_key".equals(elements[0].trim())) {
                        params.setOauthConsumerKey(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_nonce".equals(elements[0].trim())) {
                        params.setOauthNonce(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_signature".equals(elements[0].trim())) {
                        params.setOauthSignature(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_signature_method".equals(elements[0].trim())) {
                        params.setOauthSignatureMethod(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_timestamp".equals(elements[0].trim())) {
                        params.setOauthTimeStamp(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_callback".equals(elements[0].trim())) {
                        params.setOauthCallback(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("scope".equals(elements[0].trim())) {
                        params.setScope(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("xoauth_displayname".equals(elements[0].trim())) {
                        params.setDisplayName(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_token".equals(elements[0].trim())) {
                        params.setOauthToken(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_verifier".equals(elements[0].trim())) {
                        params.setOauthTokenVerifier(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_token_secret".equals(elements[0].trim())) {
                        params.setOauthTokenSecret(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_version".equals(elements[0].trim())) {
                        params.setVersion(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    nonAuthParams.append(elements[0].trim() + "=" + this.removeLeadingAndTrailingQuatation(elements[1].trim()) + "&");
                }
            }
        }
        String nonOauthParamStr = nonAuthParams.toString();
        if (!noAuthorizationHeader) {
            nonOauthParamStr = request.getQueryString() + "&";
        }
        if ((scope = request.getParameter("scope")) != null) {
            params.setScope(scope);
        }
        params.setHttpMethod(request.getMethod());
        if (nonOauthParamStr.length() > 1) {
            params.setBaseString(request.getRequestURL().toString() + "?" + nonOauthParamStr.substring(0, nonOauthParamStr.length() - 1));
        } else {
            params.setBaseString(request.getRequestURL().toString());
        }
        return params;
    }

    private String removeLeadingAndTrailingQuatation(String base) {
        String result = base;
        if (base.startsWith("\"") || base.endsWith("\"")) {
            result = base.replace("\"", "");
        }
        result = URLDecoder.decode(result);
        return result.trim();
    }
}

